/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.context;

import com.datastax.oss.driver.api.core.addresstranslation.AddressTranslator;
import com.datastax.oss.driver.api.core.auth.AuthProvider;
import com.datastax.oss.driver.api.core.config.DriverConfig;
import com.datastax.oss.driver.api.core.config.DriverConfigLoader;
import com.datastax.oss.driver.api.core.connection.ReconnectionPolicy;
import com.datastax.oss.driver.api.core.detach.AttachmentPoint;
import com.datastax.oss.driver.api.core.loadbalancing.LoadBalancingPolicy;
import com.datastax.oss.driver.api.core.metadata.NodeStateListener;
import com.datastax.oss.driver.api.core.metadata.schema.SchemaChangeListener;
import com.datastax.oss.driver.api.core.retry.RetryPolicy;
import com.datastax.oss.driver.api.core.session.throttling.RequestThrottler;
import com.datastax.oss.driver.api.core.specex.SpeculativeExecutionPolicy;
import com.datastax.oss.driver.api.core.ssl.SslEngineFactory;
import com.datastax.oss.driver.api.core.time.TimestampGenerator;
import com.datastax.oss.driver.api.core.tracker.RequestTracker;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Map;
import java.util.Optional;

public interface DriverContext
extends AttachmentPoint {
    @NonNull
    public String getSessionName();

    @NonNull
    public DriverConfig getConfig();

    @NonNull
    public DriverConfigLoader getConfigLoader();

    @NonNull
    public Map<String, LoadBalancingPolicy> getLoadBalancingPolicies();

    @NonNull
    default public LoadBalancingPolicy getLoadBalancingPolicy(@NonNull String profileName) {
        LoadBalancingPolicy policy = this.getLoadBalancingPolicies().get(profileName);
        return policy != null ? policy : this.getLoadBalancingPolicies().get("default");
    }

    @NonNull
    public Map<String, RetryPolicy> getRetryPolicies();

    @NonNull
    default public RetryPolicy getRetryPolicy(@NonNull String profileName) {
        RetryPolicy policy = this.getRetryPolicies().get(profileName);
        return policy != null ? policy : this.getRetryPolicies().get("default");
    }

    @NonNull
    public Map<String, SpeculativeExecutionPolicy> getSpeculativeExecutionPolicies();

    @NonNull
    default public SpeculativeExecutionPolicy getSpeculativeExecutionPolicy(@NonNull String profileName) {
        SpeculativeExecutionPolicy policy = this.getSpeculativeExecutionPolicies().get(profileName);
        return policy != null ? policy : this.getSpeculativeExecutionPolicies().get("default");
    }

    @NonNull
    public TimestampGenerator getTimestampGenerator();

    @NonNull
    public ReconnectionPolicy getReconnectionPolicy();

    @NonNull
    public AddressTranslator getAddressTranslator();

    @NonNull
    public Optional<AuthProvider> getAuthProvider();

    @NonNull
    public Optional<SslEngineFactory> getSslEngineFactory();

    @NonNull
    public RequestTracker getRequestTracker();

    @NonNull
    public RequestThrottler getRequestThrottler();

    @NonNull
    public NodeStateListener getNodeStateListener();

    @NonNull
    public SchemaChangeListener getSchemaChangeListener();
}

