/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.action.validator;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.workflow.action.validator.ActionValidatorUtils;
import org.apache.hop.workflow.action.validator.IActionValidator;
import org.apache.hop.workflow.action.validator.ValidatorContext;

public class NotNullValidator
implements IActionValidator {
    public static final NotNullValidator INSTANCE = new NotNullValidator();
    private static final String VALIDATOR_NAME = "notNull";

    @Override
    public boolean validate(ICheckResultSource source, String propertyName, List<ICheckResult> remarks, ValidatorContext context) {
        Object value = null;
        try {
            value = PropertyUtils.getProperty((Object)source, (String)propertyName);
            if (null == value) {
                ActionValidatorUtils.addFailureRemark(source, propertyName, VALIDATOR_NAME, remarks, ActionValidatorUtils.getLevelOnFail(context, VALIDATOR_NAME));
                return false;
            }
            return true;
        }
        catch (IllegalAccessException e) {
            ActionValidatorUtils.addExceptionRemark(source, propertyName, VALIDATOR_NAME, remarks, e);
        }
        catch (InvocationTargetException e) {
            ActionValidatorUtils.addExceptionRemark(source, propertyName, VALIDATOR_NAME, remarks, e);
        }
        catch (NoSuchMethodException e) {
            ActionValidatorUtils.addExceptionRemark(source, propertyName, VALIDATOR_NAME, remarks, e);
        }
        return false;
    }

    @Override
    public String getName() {
        return VALIDATOR_NAME;
    }
}

