/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.www;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hop.core.annotations.HopServerServlet;
import org.apache.hop.core.util.Utils;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.WorkflowSvgPainter;
import org.apache.hop.workflow.engine.IWorkflowEngine;
import org.apache.hop.www.BaseHttpServlet;
import org.apache.hop.www.GetPipelineStatusServlet;
import org.apache.hop.www.HopServerObjectEntry;
import org.apache.hop.www.IHopServerPlugin;

@HopServerServlet(id="workflowImage", name="Generate a PNG image of a workflow")
public class GetWorkflowImageServlet
extends BaseHttpServlet
implements IHopServerPlugin {
    private static final long serialVersionUID = -4365372274638005929L;
    public static final float ZOOM_FACTOR = 1.5f;
    private static final Class<?> PKG = GetPipelineStatusServlet.class;
    public static final String CONTEXT_PATH = "/hop/workflowImage";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block16: {
            IWorkflowEngine<WorkflowMeta> workflow;
            if (this.isJettyMode() && !request.getContextPath().startsWith(CONTEXT_PATH)) {
                return;
            }
            if (!this.supportGraphicEnvironment) {
                response.setStatus(204);
                return;
            }
            if (this.log.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"GetWorkflowImageServlet.Log.WorkflowImageRequested", (String[])new String[0]));
            }
            String workflowName = request.getParameter("name");
            String id = request.getParameter("id");
            if (Utils.isEmpty((CharSequence)id)) {
                HopServerObjectEntry entry = this.getWorkflowMap().getFirstHopServerObjectEntry(workflowName);
                if (entry == null) {
                    workflow = null;
                } else {
                    id = entry.getId();
                    workflow = this.getWorkflowMap().getWorkflow(entry);
                }
            } else {
                HopServerObjectEntry entry = new HopServerObjectEntry(workflowName, id);
                workflow = this.getWorkflowMap().getWorkflow(entry);
            }
            try (ByteArrayOutputStream svgStream = null;){
                if (workflow == null) break block16;
                response.setStatus(200);
                response.setCharacterEncoding("UTF-8");
                response.setContentType("image/svg+xml");
                String svgXml = WorkflowSvgPainter.generateWorkflowSvg(workflow.getWorkflowMeta(), 1.0f, this.variables);
                svgStream = new ByteArrayOutputStream();
                try {
                    svgStream.write(svgXml.getBytes(StandardCharsets.UTF_8));
                }
                finally {
                    svgStream.flush();
                }
                response.setContentLength(svgStream.size());
                ServletOutputStream out = response.getOutputStream();
                out.write(svgStream.toByteArray());
            }
        }
    }

    public String toString() {
        return "Workflow Image Handler";
    }

    @Override
    public String getService() {
        return "/hop/workflowImage (" + this.toString() + ")";
    }

    @Override
    public String getContextPath() {
        return CONTEXT_PATH;
    }
}

