/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.UnionSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public final class SharingAllowlistRemoveError {
    public static final SharingAllowlistRemoveError NO_ENTRIES_PROVIDED = new SharingAllowlistRemoveError().withTag(Tag.NO_ENTRIES_PROVIDED);
    public static final SharingAllowlistRemoveError TOO_MANY_ENTRIES_PROVIDED = new SharingAllowlistRemoveError().withTag(Tag.TOO_MANY_ENTRIES_PROVIDED);
    public static final SharingAllowlistRemoveError UNKNOWN_ERROR = new SharingAllowlistRemoveError().withTag(Tag.UNKNOWN_ERROR);
    public static final SharingAllowlistRemoveError OTHER = new SharingAllowlistRemoveError().withTag(Tag.OTHER);
    private Tag _tag;
    private String malformedEntryValue;
    private String entriesDoNotExistValue;

    private SharingAllowlistRemoveError() {
    }

    private SharingAllowlistRemoveError withTag(Tag _tag) {
        SharingAllowlistRemoveError result = new SharingAllowlistRemoveError();
        result._tag = _tag;
        return result;
    }

    private SharingAllowlistRemoveError withTagAndMalformedEntry(Tag _tag, String malformedEntryValue) {
        SharingAllowlistRemoveError result = new SharingAllowlistRemoveError();
        result._tag = _tag;
        result.malformedEntryValue = malformedEntryValue;
        return result;
    }

    private SharingAllowlistRemoveError withTagAndEntriesDoNotExist(Tag _tag, String entriesDoNotExistValue) {
        SharingAllowlistRemoveError result = new SharingAllowlistRemoveError();
        result._tag = _tag;
        result.entriesDoNotExistValue = entriesDoNotExistValue;
        return result;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isMalformedEntry() {
        return this._tag == Tag.MALFORMED_ENTRY;
    }

    public static SharingAllowlistRemoveError malformedEntry(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new SharingAllowlistRemoveError().withTagAndMalformedEntry(Tag.MALFORMED_ENTRY, value);
    }

    public String getMalformedEntryValue() {
        if (this._tag != Tag.MALFORMED_ENTRY) {
            throw new IllegalStateException("Invalid tag: required Tag.MALFORMED_ENTRY, but was Tag." + this._tag.name());
        }
        return this.malformedEntryValue;
    }

    public boolean isEntriesDoNotExist() {
        return this._tag == Tag.ENTRIES_DO_NOT_EXIST;
    }

    public static SharingAllowlistRemoveError entriesDoNotExist(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new SharingAllowlistRemoveError().withTagAndEntriesDoNotExist(Tag.ENTRIES_DO_NOT_EXIST, value);
    }

    public String getEntriesDoNotExistValue() {
        if (this._tag != Tag.ENTRIES_DO_NOT_EXIST) {
            throw new IllegalStateException("Invalid tag: required Tag.ENTRIES_DO_NOT_EXIST, but was Tag." + this._tag.name());
        }
        return this.entriesDoNotExistValue;
    }

    public boolean isNoEntriesProvided() {
        return this._tag == Tag.NO_ENTRIES_PROVIDED;
    }

    public boolean isTooManyEntriesProvided() {
        return this._tag == Tag.TOO_MANY_ENTRIES_PROVIDED;
    }

    public boolean isUnknownError() {
        return this._tag == Tag.UNKNOWN_ERROR;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.malformedEntryValue, this.entriesDoNotExistValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof SharingAllowlistRemoveError) {
            SharingAllowlistRemoveError other = (SharingAllowlistRemoveError)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case MALFORMED_ENTRY: {
                    return this.malformedEntryValue == other.malformedEntryValue || this.malformedEntryValue.equals(other.malformedEntryValue);
                }
                case ENTRIES_DO_NOT_EXIST: {
                    return this.entriesDoNotExistValue == other.entriesDoNotExistValue || this.entriesDoNotExistValue.equals(other.entriesDoNotExistValue);
                }
                case NO_ENTRIES_PROVIDED: {
                    return true;
                }
                case TOO_MANY_ENTRIES_PROVIDED: {
                    return true;
                }
                case UNKNOWN_ERROR: {
                    return true;
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<SharingAllowlistRemoveError> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(SharingAllowlistRemoveError value, JsonGenerator g) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case MALFORMED_ENTRY: {
                    g.writeStartObject();
                    this.writeTag("malformed_entry", g);
                    g.writeFieldName("malformed_entry");
                    StoneSerializers.string().serialize(value.malformedEntryValue, g);
                    g.writeEndObject();
                    break;
                }
                case ENTRIES_DO_NOT_EXIST: {
                    g.writeStartObject();
                    this.writeTag("entries_do_not_exist", g);
                    g.writeFieldName("entries_do_not_exist");
                    StoneSerializers.string().serialize(value.entriesDoNotExistValue, g);
                    g.writeEndObject();
                    break;
                }
                case NO_ENTRIES_PROVIDED: {
                    g.writeString("no_entries_provided");
                    break;
                }
                case TOO_MANY_ENTRIES_PROVIDED: {
                    g.writeString("too_many_entries_provided");
                    break;
                }
                case UNKNOWN_ERROR: {
                    g.writeString("unknown_error");
                    break;
                }
                default: {
                    g.writeString("other");
                }
            }
        }

        @Override
        public SharingAllowlistRemoveError deserialize(JsonParser p) throws IOException, JsonParseException {
            SharingAllowlistRemoveError value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("malformed_entry".equals(tag)) {
                String fieldValue = null;
                Serializer.expectField("malformed_entry", p);
                fieldValue = StoneSerializers.string().deserialize(p);
                value = SharingAllowlistRemoveError.malformedEntry(fieldValue);
            } else if ("entries_do_not_exist".equals(tag)) {
                String fieldValue = null;
                Serializer.expectField("entries_do_not_exist", p);
                fieldValue = StoneSerializers.string().deserialize(p);
                value = SharingAllowlistRemoveError.entriesDoNotExist(fieldValue);
            } else {
                value = "no_entries_provided".equals(tag) ? NO_ENTRIES_PROVIDED : ("too_many_entries_provided".equals(tag) ? TOO_MANY_ENTRIES_PROVIDED : ("unknown_error".equals(tag) ? UNKNOWN_ERROR : OTHER));
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        MALFORMED_ENTRY,
        ENTRIES_DO_NOT_EXIST,
        NO_ENTRIES_PROVIDED,
        TOO_MANY_ENTRIES_PROVIDED,
        UNKNOWN_ERROR,
        OTHER;

    }
}

