/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.DPIZoomChangeRegistry;
import org.eclipse.swt.internal.win32.CANDIDATEFORM;
import org.eclipse.swt.internal.win32.COMPOSITIONFORM;
import org.eclipse.swt.internal.win32.LOGFONT;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.IME;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class Caret
extends Widget {
    private static Caret currentCaret;
    Canvas parent;
    int x;
    int y;
    int width;
    int height;
    boolean moved;
    boolean resized;
    boolean isVisible;
    Image image;
    Font font;
    LOGFONT oldFont;

    static {
        DPIZoomChangeRegistry.registerHandler(Caret::handleDPIChange, Caret.class);
    }

    public Caret(Canvas parent, int style) {
        super(parent, style);
        this.parent = parent;
        this.createWidget();
    }

    void createWidget() {
        this.isVisible = true;
        if (this.parent.getCaret() == null) {
            this.parent.setCaret(this);
        }
    }

    long defaultFont() {
        long hwnd = this.parent.handle;
        long hwndIME = OS.ImmGetDefaultIMEWnd(hwnd);
        long hFont = 0L;
        if (hwndIME != 0L) {
            hFont = OS.SendMessage(hwndIME, 49, 0L, 0L);
        }
        if (hFont == 0L) {
            hFont = OS.SendMessage(hwnd, 49, 0L, 0L);
        }
        if (hFont == 0L) {
            return this.parent.defaultFont();
        }
        return hFont;
    }

    public Rectangle getBounds() {
        this.checkWidget();
        return DPIUtil.scaleDown(this.getBoundsInPixels(), this.getZoom());
    }

    Rectangle getBoundsInPixels() {
        int[] buffer;
        if (this.image != null) {
            Rectangle rect = this.image.getBoundsInPixels();
            return new Rectangle(this.getXInPixels(), this.getYInPixels(), rect.width, rect.height);
        }
        if (this.width == 0 && OS.SystemParametersInfo(8198, 0, buffer = new int[1], 0)) {
            return new Rectangle(this.getXInPixels(), this.getYInPixels(), buffer[0], this.getHeightInPixels());
        }
        return new Rectangle(this.getXInPixels(), this.getYInPixels(), this.getWidthInPixels(), this.getHeightInPixels());
    }

    public Font getFont() {
        this.checkWidget();
        if (this.font == null) {
            long hFont = this.defaultFont();
            return Font.win32_new((Device)this.display, hFont, this.getZoom());
        }
        return this.font;
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    public Point getLocation() {
        this.checkWidget();
        return new Point(this.x, this.y);
    }

    public Canvas getParent() {
        this.checkWidget();
        return this.parent;
    }

    public Point getSize() {
        this.checkWidget();
        return DPIUtil.scaleDown(this.getSizeInPixels(), this.getZoom());
    }

    Point getSizeInPixels() {
        int[] buffer;
        if (this.image != null) {
            Rectangle rect = this.image.getBoundsInPixels();
            return new Point(rect.width, rect.height);
        }
        if (this.width == 0 && OS.SystemParametersInfo(8198, 0, buffer = new int[1], 0)) {
            return new Point(buffer[0], this.getHeightInPixels());
        }
        return new Point(this.getWidthInPixels(), this.getHeightInPixels());
    }

    private int getWidthInPixels() {
        return DPIUtil.scaleUp(this.width, this.getZoom());
    }

    private int getHeightInPixels() {
        return DPIUtil.scaleUp(this.height, this.getZoom());
    }

    private int getXInPixels() {
        return DPIUtil.scaleUp(this.x, this.getZoom());
    }

    private int getYInPixels() {
        return DPIUtil.scaleUp(this.y, this.getZoom());
    }

    public boolean getVisible() {
        this.checkWidget();
        return this.isVisible;
    }

    boolean hasFocus() {
        return this.parent.handle == OS.GetFocus();
    }

    boolean isFocusCaret() {
        return this.parent.caret == this && this.hasFocus();
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.isVisible && this.parent.isVisible() && this.hasFocus();
    }

    void killFocus() {
        OS.DestroyCaret();
        this.restoreIMEFont();
    }

    void move() {
        this.moved = false;
        this.setCurrentCaret(this);
        if (!OS.SetCaretPos(this.getXInPixels(), this.getYInPixels())) {
            return;
        }
        this.resizeIME();
    }

    void resizeIME() {
        if (!OS.IsDBLocale) {
            return;
        }
        POINT ptCurrentPos = new POINT();
        if (!OS.GetCaretPos(ptCurrentPos)) {
            return;
        }
        long hwnd = this.parent.handle;
        long hIMC = OS.ImmGetContext(hwnd);
        IME ime = this.parent.getIME();
        if (ime != null && ime.isInlineEnabled()) {
            Point size = this.getSizeInPixels();
            CANDIDATEFORM lpCandidate = new CANDIDATEFORM();
            lpCandidate.dwStyle = 128;
            lpCandidate.ptCurrentPos = ptCurrentPos;
            lpCandidate.rcArea = new RECT();
            OS.SetRect(lpCandidate.rcArea, ptCurrentPos.x, ptCurrentPos.y, ptCurrentPos.x + size.x, ptCurrentPos.y + size.y);
            OS.ImmSetCandidateWindow(hIMC, lpCandidate);
        } else {
            RECT rect = new RECT();
            OS.GetClientRect(hwnd, rect);
            COMPOSITIONFORM lpCompForm = new COMPOSITIONFORM();
            lpCompForm.dwStyle = 1;
            lpCompForm.x = ptCurrentPos.x;
            lpCompForm.y = ptCurrentPos.y;
            lpCompForm.left = rect.left;
            lpCompForm.right = rect.right;
            lpCompForm.top = rect.top;
            lpCompForm.bottom = rect.bottom;
            OS.ImmSetCompositionWindow(hIMC, lpCompForm);
        }
        OS.ImmReleaseContext(hwnd, hIMC);
    }

    @Override
    void releaseParent() {
        super.releaseParent();
        if (this.parent != null && this == this.parent.caret) {
            if (!this.parent.isDisposed()) {
                this.parent.setCaret(null);
            } else {
                this.parent.caret = null;
            }
        }
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if (this.isCurrentCaret()) {
            this.setCurrentCaret(null);
        }
        this.parent = null;
        this.image = null;
        this.font = null;
        this.oldFont = null;
    }

    void resize() {
        int[] buffer;
        this.resized = false;
        long hwnd = this.parent.handle;
        OS.DestroyCaret();
        long hBitmap = this.image != null ? Image.win32_getHandle(this.image, this.getZoom()) : 0L;
        int widthInPixels = this.getWidthInPixels();
        if (this.image == null && widthInPixels == 0 && OS.SystemParametersInfo(8198, 0, buffer = new int[1], 0)) {
            widthInPixels = buffer[0];
        }
        OS.CreateCaret(hwnd, hBitmap, widthInPixels, this.getHeightInPixels());
        OS.SetCaretPos(this.getXInPixels(), this.getYInPixels());
        OS.ShowCaret(hwnd);
        this.move();
    }

    void restoreIMEFont() {
        if (!OS.IsDBLocale) {
            return;
        }
        if (this.oldFont == null) {
            return;
        }
        long hwnd = this.parent.handle;
        long hIMC = OS.ImmGetContext(hwnd);
        OS.ImmSetCompositionFont(hIMC, this.oldFont);
        OS.ImmReleaseContext(hwnd, hIMC);
        this.oldFont = null;
    }

    public void setBounds(int x, int y, int width, int height) {
        boolean sameExtent;
        this.checkWidget();
        boolean samePosition = this.x == x && this.y == y;
        boolean bl = sameExtent = this.width == width && this.height == height;
        if (samePosition && sameExtent && this.isCurrentCaret()) {
            return;
        }
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        if (sameExtent) {
            this.moved = true;
            if (this.isVisible && this.hasFocus()) {
                this.move();
            }
        } else {
            this.resized = true;
            if (this.isVisible && this.hasFocus()) {
                this.resize();
            }
        }
    }

    public void setBounds(Rectangle rect) {
        if (rect == null) {
            this.error(4);
        }
        this.setBounds(rect.x, rect.y, rect.width, rect.height);
    }

    void setFocus() {
        int[] buffer;
        long hwnd = this.parent.handle;
        long hBitmap = 0L;
        if (this.image != null) {
            hBitmap = Image.win32_getHandle(this.image, this.getZoom());
        }
        int widthInPixels = this.getWidthInPixels();
        if (this.image == null && widthInPixels == 0 && OS.SystemParametersInfo(8198, 0, buffer = new int[1], 0)) {
            widthInPixels = buffer[0];
        }
        OS.CreateCaret(hwnd, hBitmap, widthInPixels, this.getHeightInPixels());
        this.move();
        this.setIMEFont();
        if (this.isVisible) {
            OS.ShowCaret(hwnd);
        }
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            this.error(5);
        }
        Shell shell = this.parent.getShell();
        Font font2 = this.font = font == null ? null : Font.win32_new(font, shell.nativeZoom);
        if (this.hasFocus()) {
            this.setIMEFont();
        }
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        this.image = image;
        if (this.isVisible && this.hasFocus()) {
            this.resize();
        }
    }

    void setIMEFont() {
        LOGFONT logFont;
        if (!OS.IsDBLocale) {
            return;
        }
        long hFont = 0L;
        if (this.font != null) {
            hFont = this.font.handle;
        }
        if (hFont == 0L) {
            hFont = this.defaultFont();
        }
        long hwnd = this.parent.handle;
        long hIMC = OS.ImmGetContext(hwnd);
        if (this.oldFont == null) {
            this.oldFont = new LOGFONT();
            if (!OS.ImmGetCompositionFont(hIMC, this.oldFont)) {
                this.oldFont = null;
            }
        }
        if (OS.GetObject(hFont, LOGFONT.sizeof, logFont = new LOGFONT()) != 0) {
            OS.ImmSetCompositionFont(hIMC, logFont);
        }
        OS.ImmReleaseContext(hwnd, hIMC);
    }

    public void setLocation(int x, int y) {
        this.checkWidget();
        if (this.x == x && this.y == y && this.isCurrentCaret()) {
            return;
        }
        this.x = x;
        this.y = y;
        this.moved = true;
        if (this.isVisible && this.hasFocus()) {
            this.move();
        }
    }

    private boolean isCurrentCaret() {
        return currentCaret == this;
    }

    private void setCurrentCaret(Caret caret) {
        currentCaret = caret;
    }

    public void setLocation(Point location) {
        this.checkWidget();
        if (location == null) {
            this.error(4);
        }
        this.setLocation(location.x, location.y);
    }

    public void setSize(int width, int height) {
        this.checkWidget();
        if (this.width == width && this.height == height && this.isCurrentCaret()) {
            return;
        }
        this.width = width;
        this.height = height;
        this.resized = true;
        if (this.isVisible && this.hasFocus()) {
            this.resize();
        }
    }

    public void setSize(Point size) {
        this.checkWidget();
        if (size == null) {
            this.error(4);
        }
        this.setSize(size.x, size.y);
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
        if (visible == this.isVisible) {
            return;
        }
        this.isVisible = visible;
        long hwnd = this.parent.handle;
        if (OS.GetFocus() != hwnd) {
            return;
        }
        if (!this.isVisible) {
            OS.HideCaret(hwnd);
        } else {
            if (this.resized) {
                this.resize();
            } else if (this.moved) {
                this.move();
            }
            OS.ShowCaret(hwnd);
        }
    }

    public static void win32_setHeight(Caret caret, int height) {
        caret.checkWidget();
        if (caret.height != height) {
            caret.height = height;
            caret.resized = true;
        }
        if (caret.isVisible && caret.hasFocus()) {
            caret.resize();
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void handleDPIChange(Widget widget, int newZoom, float scalingFactor) {
        void caret;
        if (!(widget instanceof Caret)) {
            return;
        }
        Caret caret2 = (Caret)widget;
        Image image = caret.getImage();
        if (image != null) {
            caret.setImage(image);
        }
        if (caret.font != null) {
            caret.setFont(caret.font);
        }
    }
}

