/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.language;

import com.github.pemistahl.lingua.api.Language;
import com.github.pemistahl.lingua.api.LanguageDetector;
import com.github.pemistahl.lingua.api.LanguageDetectorBuilder;
import java.util.ArrayList;
import java.util.Objects;
import java.util.SortedMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.language.DetectLanguageData;
import org.apache.hop.pipeline.transforms.language.DetectLanguageMeta;

public class DetectLanguage
extends BaseTransform<DetectLanguageMeta, DetectLanguageData> {
    private static final Class<?> PKG = DetectLanguage.class;
    public static final int OVER_ALLOCATE_SIZE = 10;
    private final int cores = Runtime.getRuntime().availableProcessors();
    private final int maxJobs = this.cores * 100;
    private final ExecutorService executor = ForkJoinPool.commonPool();
    private final AtomicInteger jobs = new AtomicInteger(0);
    private final Object lock = new Object();
    private final LanguageDetector detector = LanguageDetectorBuilder.fromAllSpokenLanguages().withPreloadedLanguageModels().build();

    public DetectLanguage(TransformMeta transformMeta, DetectLanguageMeta meta, DetectLanguageData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finish() {
        Object object = this.lock;
        synchronized (object) {
            while (this.jobs.get() > 0) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        this.detector.unloadLanguageModels();
        this.setOutputDone();
    }

    public boolean processRow() throws HopException {
        block7: {
            Object[] r = this.getRow();
            if (r == null) {
                this.finish();
                return false;
            }
            if (this.first) {
                this.first = false;
                ((DetectLanguageData)this.data).previousRowMeta = this.getInputRowMeta().clone();
                ((DetectLanguageData)this.data).NrPrevFields = ((DetectLanguageData)this.data).previousRowMeta.size();
                ((DetectLanguageData)this.data).outputRowMeta = this.getInputRowMeta().clone();
                ((DetectLanguageMeta)this.meta).getFields(((DetectLanguageData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
                if (Utils.isEmpty((CharSequence)((DetectLanguageMeta)this.meta).getCorpusField())) {
                    throw new HopException(BaseMessages.getString(PKG, (String)"DetectLanguage.Error.CorpusFieldMissing", (String[])new String[0]));
                }
                this.cacheIndexPositions();
            }
            boolean sendToErrorRow = false;
            String errorMessage = null;
            this.process(r);
            try {
                if (this.isRowLevel()) {
                    this.logRowlevel(BaseMessages.getString(PKG, (String)"DetectLanguage.LineNumber", (String[])new String[]{this.getLinesRead() + " : " + this.getInputRowMeta().getString(r)}));
                }
            }
            catch (Exception e) {
                if (!this.getTransformMeta().isDoingErrorHandling()) {
                    this.logError(BaseMessages.getString(PKG, (String)"DetectLanguage.ErrorInTransformRunning", (String[])new String[0]) + e.getMessage());
                    this.setErrors(1L);
                    this.stopAll();
                    this.setOutputDone();
                    return false;
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block7;
                this.putError(this.getInputRowMeta(), r, 1L, errorMessage, ((DetectLanguageMeta)this.meta).getCorpusField(), "DetectLanguage001");
            }
        }
        return true;
    }

    private void process(Object[] inputRow) throws HopTransformException {
        String corpus = StringUtils.trim((String)((String)inputRow[((DetectLanguageData)this.data).indexOfCorpusField]));
        if (StringUtils.isBlank((CharSequence)corpus)) {
            return;
        }
        if (((DetectLanguageMeta)this.meta).isParallelism()) {
            this.processAsync(corpus, inputRow);
        } else {
            this.processSync(corpus, inputRow);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processAsync(String corpus, Object[] inputRow) {
        Object object = this.lock;
        synchronized (object) {
            while (this.jobs.get() > this.maxJobs) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        this.executor.submit(() -> {
            try {
                this.processSync(corpus, inputRow);
                this.jobs.decrementAndGet();
                Object object = this.lock;
                synchronized (object) {
                    this.lock.notifyAll();
                }
            }
            catch (Exception e) {
                this.logError(e.getMessage(), e);
            }
        });
        this.jobs.incrementAndGet();
    }

    private void cacheIndexPositions() throws HopException {
        if (((DetectLanguageData)this.data).indexOfCorpusField < 0) {
            ((DetectLanguageData)this.data).indexOfCorpusField = ((DetectLanguageData)this.data).previousRowMeta.indexOfValue(((DetectLanguageMeta)this.meta).getCorpusField());
            if (((DetectLanguageData)this.data).indexOfCorpusField < 0) {
                throw new HopException(BaseMessages.getString(PKG, (String)"DetectLanguage.Exception.CouldnotFindField", (String[])new String[]{((DetectLanguageMeta)this.meta).getCorpusField()}));
            }
        }
        if (((DetectLanguageData)this.data).indexOfDetectedLanguage < 0) {
            ((DetectLanguageData)this.data).indexOfDetectedLanguage = ((DetectLanguageData)this.data).outputRowMeta.indexOfValue("detected_language");
            if (((DetectLanguageData)this.data).indexOfDetectedLanguage < 0) {
                throw new HopException(BaseMessages.getString(PKG, (String)"DetectLanguage.Exception.CouldnotFindField", (String[])new String[]{"detected_language"}));
            }
        }
        if (((DetectLanguageData)this.data).indexOfDetectedLanguageConfidence < 0) {
            ((DetectLanguageData)this.data).indexOfDetectedLanguageConfidence = ((DetectLanguageData)this.data).outputRowMeta.indexOfValue("detected_language_confidence");
            if (((DetectLanguageData)this.data).indexOfDetectedLanguageConfidence < 0) {
                throw new HopException(BaseMessages.getString(PKG, (String)"DetectLanguage.Exception.CouldnotFindField", (String[])new String[]{"detected_language_confidence"}));
            }
        }
    }

    private void processSync(String corpus, Object[] inputRow) throws HopTransformException {
        SortedMap confidenceValues = this.detector.computeLanguageConfidenceValues(corpus);
        Language detectedLanguage = Language.UNKNOWN;
        Double confidence = null;
        if (!confidenceValues.isEmpty()) {
            Language mostLikelyLanguage = (Language)confidenceValues.firstKey();
            Double mostLikelyLanguageProbability = (Double)confidenceValues.get(mostLikelyLanguage);
            if (confidenceValues.size() == 1) {
                detectedLanguage = mostLikelyLanguage;
                confidence = mostLikelyLanguageProbability;
            } else {
                boolean unk;
                Double secondMostLikelyLanguageProbability = (Double)new ArrayList(confidenceValues.values()).get(1);
                boolean eq = Objects.equals(mostLikelyLanguageProbability, secondMostLikelyLanguageProbability);
                boolean bl = unk = mostLikelyLanguageProbability - secondMostLikelyLanguageProbability < this.detector.getMinimumRelativeDistance$lingua();
                if (!eq && !unk) {
                    detectedLanguage = mostLikelyLanguage;
                    confidence = mostLikelyLanguageProbability;
                }
            }
        }
        Object[] outputRow = new Object[inputRow.length + 2 + 10];
        System.arraycopy(inputRow, 0, outputRow, 0, inputRow.length);
        outputRow[((DetectLanguageData)this.data).indexOfDetectedLanguage] = detectedLanguage.name();
        outputRow[((DetectLanguageData)this.data).indexOfDetectedLanguageConfidence] = confidence;
        this.putRow(((DetectLanguageData)this.data).outputRowMeta, outputRow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putRow(IRowMeta rowMeta, Object[] row) throws HopTransformException {
        DetectLanguage detectLanguage = this;
        synchronized (detectLanguage) {
            super.putRow(rowMeta, row);
        }
    }
}

