/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.mysqlbulkloader;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hop.core.Const;
import org.apache.hop.core.DbCache;
import org.apache.hop.core.SourceToTargetMapping;
import org.apache.hop.core.SqlStatement;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.mysqlbulkloader.MySqlBulkLoaderMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.database.dialog.DatabaseExplorerDialog;
import org.apache.hop.ui.core.database.dialog.SqlEditor;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.EnterMappingDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.dialog.ShowMessageDialog;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.MetaSelectionLine;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.pipeline.transform.ITableItemInsertListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class MySqlBulkLoaderDialog
extends BaseTransformDialog {
    private static final Class<?> PKG = MySqlBulkLoaderDialog.class;
    private MetaSelectionLine<DatabaseMeta> wConnection;
    private TextVar wSchema;
    private TextVar wTable;
    private TextVar wFifoFile;
    private Button wReplace;
    private Button wIgnore;
    private Button wLocal;
    private TextVar wDelimiter;
    private TextVar wEnclosure;
    private TextVar wEscapeChar;
    private TextVar wLoadCharSet;
    private TextVar wCharSet;
    private TextVar wBulkSize;
    private TableView wReturn;
    private final MySqlBulkLoaderMeta input;
    private ColumnInfo[] ciReturn;
    private final Map<String, Integer> inputFields;
    private final List<ColumnInfo> tableFieldColumns = new ArrayList<ColumnInfo>();

    public MySqlBulkLoaderDialog(Shell parent, IVariables variables, MySqlBulkLoaderMeta transformMeta, PipelineMeta pipelineMeta) {
        super(parent, variables, (ITransformMeta)transformMeta, pipelineMeta);
        this.input = transformMeta;
        this.inputFields = new HashMap<String, Integer>();
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        FocusAdapter lsFocusLost = new FocusAdapter(){

            public void focusLost(FocusEvent arg0) {
                MySqlBulkLoaderDialog.this.setTableFieldCombo();
            }
        };
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"MySqlBulkLoaderDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"MySqlBulkLoaderDialog.TransformName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        FormData fdlTransformName = new FormData();
        fdlTransformName.left = new FormAttachment(0, 0);
        fdlTransformName.right = new FormAttachment(middle, -margin);
        fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        FormData fdTransformName = new FormData();
        fdTransformName.left = new FormAttachment(middle, 0);
        fdTransformName.top = new FormAttachment(0, margin);
        fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)fdTransformName);
        this.wConnection = this.addConnectionLine((Composite)this.shell, (Control)this.wTransformName, this.input.getConnection(), lsMod);
        if (this.input.getConnection() == null) {
            this.wConnection.select(0);
        }
        this.wConnection.addModifyListener(lsMod);
        Label wlSchema = new Label((Composite)this.shell, 131072);
        wlSchema.setText(BaseMessages.getString(PKG, (String)"MySqlBulkLoaderDialog.TargetSchema.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlSchema);
        FormData fdlSchema = new FormData();
        fdlSchema.left = new FormAttachment(0, 0);
        fdlSchema.right = new FormAttachment(middle, -margin);
        fdlSchema.top = new FormAttachment(this.wConnection, margin * 2);
        wlSchema.setLayoutData((Object)fdlSchema);
        this.wSchema = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wSchema);
        this.wSchema.addModifyListener(lsMod);
        this.wSchema.addFocusListener((FocusListener)lsFocusLost);
        FormData fdSchema = new FormData();
        fdSchema.left = new FormAttachment(middle, 0);
        fdSchema.top = new FormAttachment(this.wConnection, margin * 2);
        fdSchema.right = new FormAttachment(100, 0);
        this.wSchema.setLayoutData((Object)fdSchema);
        Label wlTable = new Label((Composite)this.shell, 131072);
        wlTable.setText(BaseMessages.getString(PKG, (String)"MySqlBulkLoaderDialog.TargetTable.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlTable);
        FormData fdlTable = new FormData();
        fdlTable.left = new FormAttachment(0, 0);
        fdlTable.right = new FormAttachment(middle, -margin);
        fdlTable.top = new FormAttachment((Control)this.wSchema, margin);
        wlTable.setLayoutData((Object)fdlTable);
        Button wbTable = new Button((Composite)this.shell, 0x1000008);
        PropsUi.setLook((Widget)wbTable);
        wbTable.setText(BaseMessages.getString(PKG, (String)"MySqlBulkLoaderDialog.Browse.Button", (String[])new String[0]));
        FormData fdbTable = new FormData();
        fdbTable.right = new FormAttachment(100, 0);
        fdbTable.top = new FormAttachment((Control)this.wSchema, margin);
        wbTable.setLayoutData((Object)fdbTable);
        this.wTable = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wTable);
        this.wTable.addModifyListener(lsMod);
        this.wTable.addFocusListener((FocusListener)lsFocusLost);
        FormData fdTable = new FormData();
        fdTable.left = new FormAttachment(middle, 0);
        fdTable.top = new FormAttachment((Control)this.wSchema, margin);
        fdTable.right = new FormAttachment((Control)wbTable, -margin);
        this.wTable.setLayoutData((Object)fdTable);
        Label wlFifoFile = new Label((Composite)this.shell, 131072);
        wlFifoFile.setText(BaseMessages.getString(PKG, (String)"MySqlBulkLoaderDialog.FifoFile.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFifoFile);
        FormData fdlFifoFile = new FormData();
        fdlFifoFile.left = new FormAttachment(0, 0);
        fdlFifoFile.right = new FormAttachment(middle, -margin);
        fdlFifoFile.top = new FormAttachment((Control)this.wTable, margin);
        wlFifoFile.setLayoutData((Object)fdlFifoFile);
        this.wFifoFile = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wFifoFile);
        this.wFifoFile.addModifyListener(lsMod);
        FormData fdFifoFile = new FormData();
        fdFifoFile.left = new FormAttachment(middle, 0);
        fdFifoFile.top = new FormAttachment((Control)this.wTable, margin);
        fdFifoFile.right = new FormAttachment(100, 0);
        this.wFifoFile.setLayoutData((Object)fdFifoFile);
        Label wlDelimiter = new Label((Composite)this.shell, 131072);
        wlDelimiter.setText(BaseMessages.getString(PKG, (String)"MySqlBulkLoaderDialog.Delimiter.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlDelimiter);
        FormData fdlDelimiter = new FormData();
        fdlDelimiter.left = new FormAttachment(0, 0);
        fdlDelimiter.right = new FormAttachment(middle, -margin);
        fdlDelimiter.top = new FormAttachment((Control)this.wFifoFile, margin);
        wlDelimiter.setLayoutData((Object)fdlDelimiter);
        Button wbDelimiter = new Button((Composite)this.shell, 0x1000008);
        PropsUi.setLook((Widget)wbDelimiter);
        wbDelimiter.setText(BaseMessages.getString(PKG, (String)"MySqlBulkLoaderDialog.Delimiter.Button", (String[])new String[0]));
        FormData fdbDelimiter = new FormData();
        fdbDelimiter.top = new FormAttachment((Control)this.wFifoFile, margin);
        fdbDelimiter.right = new FormAttachment(100, 0);
        wbDelimiter.setLayoutData((Object)fdbDelimiter);
        this.wDelimiter = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wDelimiter);
        this.wDelimiter.addModifyListener(lsMod);
        FormData fdDelimiter = new FormData();
        fdDelimiter.left = new FormAttachment(middle, 0);
        fdDelimiter.top = new FormAttachment((Control)this.wFifoFile, margin);
        fdDelimiter.right = new FormAttachment((Control)wbDelimiter, -margin);
        this.wDelimiter.setLayoutData((Object)fdDelimiter);
        wbDelimiter.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                Text t = MySqlBulkLoaderDialog.this.wDelimiter.getTextWidget();
                if (t != null) {
                    t.insert("\t");
                }
            }
        });
        Label wlEnclosure = new Label((Composite)this.shell, 131072);
        wlEnclosure.setText(BaseMessages.getString(PKG, (String)"MySqlBulkLoaderDialog.Enclosure.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlEnclosure);
        FormData fdlEnclosure = new FormData();
        fdlEnclosure.left = new FormAttachment(0, 0);
        fdlEnclosure.right = new FormAttachment(middle, -margin);
        fdlEnclosure.top = new FormAttachment((Control)this.wDelimiter, margin);
        wlEnclosure.setLayoutData((Object)fdlEnclosure);
        this.wEnclosure = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wEnclosure);
        this.wEnclosure.addModifyListener(lsMod);
        FormData fdEnclosure = new FormData();
        fdEnclosure.left = new FormAttachment(middle, 0);
        fdEnclosure.top = new FormAttachment((Control)this.wDelimiter, margin);
        fdEnclosure.right = new FormAttachment(100, 0);
        this.wEnclosure.setLayoutData((Object)fdEnclosure);
        Label wlEscapeChar = new Label((Composite)this.shell, 131072);
        wlEscapeChar.setText(BaseMessages.getString(PKG, (String)"MySqlBulkLoaderDialog.EscapeChar.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlEscapeChar);
        FormData fdlEscapeChar = new FormData();
        fdlEscapeChar.left = new FormAttachment(0, 0);
        fdlEscapeChar.right = new FormAttachment(middle, -margin);
        fdlEscapeChar.top = new FormAttachment((Control)this.wEnclosure, margin);
        wlEscapeChar.setLayoutData((Object)fdlEscapeChar);
        this.wEscapeChar = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wEscapeChar);
        this.wEscapeChar.addModifyListener(lsMod);
        FormData fdEscapeChar = new FormData();
        fdEscapeChar.left = new FormAttachment(middle, 0);
        fdEscapeChar.top = new FormAttachment((Control)this.wEnclosure, margin);
        fdEscapeChar.right = new FormAttachment(100, 0);
        this.wEscapeChar.setLayoutData((Object)fdEscapeChar);
        Label wlLoadCharSet = new Label((Composite)this.shell, 131072);
        wlLoadCharSet.setText(BaseMessages.getString(PKG, (String)"MySqlBulkLoaderDialog.LoadCharSet.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlLoadCharSet);
        FormData fdlLoadCharSet = new FormData();
        fdlLoadCharSet.left = new FormAttachment(0, 0);
        fdlLoadCharSet.right = new FormAttachment(middle, -margin);
        fdlLoadCharSet.top = new FormAttachment((Control)this.wEscapeChar, margin);
        wlLoadCharSet.setLayoutData((Object)fdlLoadCharSet);
        this.wLoadCharSet = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wLoadCharSet);
        this.wLoadCharSet.addModifyListener(lsMod);
        FormData fdLoadCharSet = new FormData();
        fdLoadCharSet.left = new FormAttachment(middle, 0);
        fdLoadCharSet.top = new FormAttachment((Control)this.wEscapeChar, margin);
        fdLoadCharSet.right = new FormAttachment(100, 0);
        this.wLoadCharSet.setLayoutData((Object)fdLoadCharSet);
        Label wlCharSet = new Label((Composite)this.shell, 131072);
        wlCharSet.setText(BaseMessages.getString(PKG, (String)"MySqlBulkLoaderDialog.CharSet.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlCharSet);
        FormData fdlCharSet = new FormData();
        fdlCharSet.left = new FormAttachment(0, 0);
        fdlCharSet.right = new FormAttachment(middle, -margin);
        fdlCharSet.top = new FormAttachment((Control)this.wLoadCharSet, margin);
        wlCharSet.setLayoutData((Object)fdlCharSet);
        this.wCharSet = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wCharSet);
        this.wCharSet.addModifyListener(lsMod);
        FormData fdCharSet = new FormData();
        fdCharSet.left = new FormAttachment(middle, 0);
        fdCharSet.top = new FormAttachment((Control)this.wLoadCharSet, margin);
        fdCharSet.right = new FormAttachment(100, 0);
        this.wCharSet.setLayoutData((Object)fdCharSet);
        Label wlBulkSize = new Label((Composite)this.shell, 131072);
        wlBulkSize.setText(BaseMessages.getString(PKG, (String)"MySqlBulkLoaderDialog.BulkSize.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlBulkSize);
        FormData fdlBulkSize = new FormData();
        fdlBulkSize.left = new FormAttachment(0, 0);
        fdlBulkSize.right = new FormAttachment(middle, -margin);
        fdlBulkSize.top = new FormAttachment((Control)this.wCharSet, margin);
        wlBulkSize.setLayoutData((Object)fdlBulkSize);
        this.wBulkSize = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wBulkSize);
        this.wBulkSize.addModifyListener(lsMod);
        FormData fdBulkSize = new FormData();
        fdBulkSize.left = new FormAttachment(middle, 0);
        fdBulkSize.top = new FormAttachment((Control)this.wCharSet, margin);
        fdBulkSize.right = new FormAttachment(100, 0);
        this.wBulkSize.setLayoutData((Object)fdBulkSize);
        Label wlReplace = new Label((Composite)this.shell, 131072);
        wlReplace.setText(BaseMessages.getString(PKG, (String)"MySqlBulkLoaderDialog.Replace.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlReplace);
        FormData fdlReplace = new FormData();
        fdlReplace.left = new FormAttachment(0, 0);
        fdlReplace.right = new FormAttachment(middle, -margin);
        fdlReplace.top = new FormAttachment((Control)this.wBulkSize, margin * 2);
        wlReplace.setLayoutData((Object)fdlReplace);
        this.wReplace = new Button((Composite)this.shell, 16416);
        PropsUi.setLook((Widget)this.wReplace);
        FormData fdReplace = new FormData();
        fdReplace.left = new FormAttachment(middle, 0);
        fdReplace.top = new FormAttachment((Control)this.wBulkSize, margin * 2);
        fdReplace.right = new FormAttachment(100, 0);
        this.wReplace.setLayoutData((Object)fdReplace);
        this.wReplace.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                if (MySqlBulkLoaderDialog.this.wReplace.getSelection()) {
                    MySqlBulkLoaderDialog.this.wIgnore.setSelection(false);
                }
                MySqlBulkLoaderDialog.this.input.setChanged();
            }
        });
        Label wlIgnore = new Label((Composite)this.shell, 131072);
        wlIgnore.setText(BaseMessages.getString(PKG, (String)"MySqlBulkLoaderDialog.Ignore.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlIgnore);
        FormData fdlIgnore = new FormData();
        fdlIgnore.left = new FormAttachment(0, 0);
        fdlIgnore.right = new FormAttachment(middle, -margin);
        fdlIgnore.top = new FormAttachment((Control)this.wReplace, margin * 2);
        wlIgnore.setLayoutData((Object)fdlIgnore);
        this.wIgnore = new Button((Composite)this.shell, 16416);
        PropsUi.setLook((Widget)this.wIgnore);
        FormData fdIgnore = new FormData();
        fdIgnore.left = new FormAttachment(middle, 0);
        fdIgnore.top = new FormAttachment((Control)this.wReplace, margin * 2);
        fdIgnore.right = new FormAttachment(100, 0);
        this.wIgnore.setLayoutData((Object)fdIgnore);
        this.wIgnore.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                if (MySqlBulkLoaderDialog.this.wIgnore.getSelection()) {
                    MySqlBulkLoaderDialog.this.wReplace.setSelection(false);
                }
                MySqlBulkLoaderDialog.this.input.setChanged();
            }
        });
        Label wlLocal = new Label((Composite)this.shell, 131072);
        wlLocal.setText(BaseMessages.getString(PKG, (String)"MySqlBulkLoaderDialog.Local.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlLocal);
        FormData fdlLocal = new FormData();
        fdlLocal.left = new FormAttachment(0, 0);
        fdlLocal.right = new FormAttachment(middle, -margin);
        fdlLocal.top = new FormAttachment((Control)this.wIgnore, margin * 2);
        wlLocal.setLayoutData((Object)fdlLocal);
        this.wLocal = new Button((Composite)this.shell, 16416);
        PropsUi.setLook((Widget)this.wLocal);
        FormData fdLocal = new FormData();
        fdLocal.left = new FormAttachment(middle, 0);
        fdLocal.top = new FormAttachment((Control)this.wIgnore, margin * 2);
        fdLocal.right = new FormAttachment(100, 0);
        this.wLocal.setLayoutData((Object)fdLocal);
        this.wLocal.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                MySqlBulkLoaderDialog.this.input.setChanged();
            }
        });
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wSql = new Button((Composite)this.shell, 8);
        this.wSql.setText(BaseMessages.getString(PKG, (String)"MySqlBulkLoaderDialog.SQL.Button", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel, this.wSql}, margin, null);
        Label wlReturn = new Label((Composite)this.shell, 0);
        wlReturn.setText(BaseMessages.getString(PKG, (String)"MySqlBulkLoaderDialog.Fields.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlReturn);
        FormData fdlReturn = new FormData();
        fdlReturn.left = new FormAttachment(0, 0);
        fdlReturn.top = new FormAttachment((Control)this.wLocal, margin);
        wlReturn.setLayoutData((Object)fdlReturn);
        int upInsCols = 3;
        int upInsRows = this.input.getFields() != null ? this.input.getFields().size() : 1;
        this.ciReturn = new ColumnInfo[upInsCols];
        this.ciReturn[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"MySqlBulkLoaderDialog.ColumnInfo.TableField", (String[])new String[0]), 2, new String[]{""}, false);
        this.ciReturn[1] = new ColumnInfo(BaseMessages.getString(PKG, (String)"MySqlBulkLoaderDialog.ColumnInfo.StreamField", (String[])new String[0]), 2, new String[]{""}, false);
        this.ciReturn[2] = new ColumnInfo(BaseMessages.getString(PKG, (String)"MySqlBulkLoaderDialog.ColumnInfo.FormatOK", (String[])new String[0]), 2, MySqlBulkLoaderMeta.getFieldFormatTypeDescriptions(), true);
        this.tableFieldColumns.add(this.ciReturn[0]);
        this.wReturn = new TableView(this.variables, (Composite)this.shell, 68354, this.ciReturn, upInsRows, lsMod, this.props);
        Button wGetLU = new Button((Composite)this.shell, 8);
        wGetLU.setText(BaseMessages.getString(PKG, (String)"MySqlBulkLoaderDialog.GetFields.Label", (String[])new String[0]));
        FormData fdGetLU = new FormData();
        fdGetLU.top = new FormAttachment((Control)wlReturn, margin);
        fdGetLU.right = new FormAttachment(100, 0);
        wGetLU.setLayoutData((Object)fdGetLU);
        Button wDoMapping = new Button((Composite)this.shell, 8);
        wDoMapping.setText(BaseMessages.getString(PKG, (String)"MySqlBulkLoaderDialog.EditMapping.Label", (String[])new String[0]));
        FormData fdDoMapping = new FormData();
        fdDoMapping.top = new FormAttachment((Control)wGetLU, margin);
        fdDoMapping.right = new FormAttachment(100, 0);
        wDoMapping.setLayoutData((Object)fdDoMapping);
        wDoMapping.addListener(13, arg0 -> this.generateMappings());
        FormData fdReturn = new FormData();
        fdReturn.left = new FormAttachment(0, 0);
        fdReturn.top = new FormAttachment((Control)wlReturn, margin);
        fdReturn.right = new FormAttachment((Control)wDoMapping, -margin);
        fdReturn.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        this.wReturn.setLayoutData((Object)fdReturn);
        Runnable runnable = () -> {
            TransformMeta transformMeta = this.pipelineMeta.findTransform(this.transformName);
            if (transformMeta != null) {
                try {
                    IRowMeta row = this.pipelineMeta.getPrevTransformFields(this.variables, transformMeta);
                    for (int i = 0; i < row.size(); ++i) {
                        this.inputFields.put(row.getValueMeta(i).getName(), i);
                    }
                    this.setComboBoxes();
                }
                catch (HopException e) {
                    this.logError(BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]));
                }
            }
        };
        new Thread(runnable).start();
        this.wOk.addListener(13, e -> this.ok());
        wGetLU.addListener(13, e -> this.getUpdate());
        this.wSql.addListener(13, e -> this.create());
        this.wCancel.addListener(13, e -> this.cancel());
        wbTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MySqlBulkLoaderDialog.this.getTableName();
            }
        });
        this.setSize();
        this.getData();
        this.setTableFieldCombo();
        this.input.setChanged(this.changed);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    private void generateMappings() {
        EnterMappingDialog d;
        IRowMeta targetFields;
        IRowMeta sourceFields;
        try {
            sourceFields = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformMeta);
        }
        catch (HopException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"MySqlBulkLoaderDialog.DoMapping.UnableToFindSourceFields.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MySqlBulkLoaderDialog.DoMapping.UnableToFindSourceFields.Message", (String[])new String[0]), (Exception)((Object)e));
            return;
        }
        this.input.setConnection(this.wConnection.getText());
        this.input.setTableName(this.variables.resolve(this.wTable.getText()));
        ITransformMeta transformMetaInterface = this.transformMeta.getTransform();
        try {
            targetFields = transformMetaInterface.getRequiredFields(this.variables);
        }
        catch (HopException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"MySqlBulkLoaderDialog.DoMapping.UnableToFindTargetFields.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MySqlBulkLoaderDialog.DoMapping.UnableToFindTargetFields.Message", (String[])new String[0]), (Exception)((Object)e));
            return;
        }
        String[] inputNames = new String[sourceFields.size()];
        for (int i = 0; i < sourceFields.size(); ++i) {
            IValueMeta value = sourceFields.getValueMeta(i);
            inputNames[i] = value.getName() + "-" + value.getOrigin() + ")";
        }
        List<SourceToTargetMapping> mappings = new ArrayList();
        StringBuilder missingSourceFields = new StringBuilder();
        StringBuilder missingTargetFields = new StringBuilder();
        int nrFields = this.wReturn.nrNonEmpty();
        for (int i = 0; i < nrFields; ++i) {
            int targetIndex;
            TableItem item = this.wReturn.getNonEmpty(i);
            String source = item.getText(2);
            String target = item.getText(1);
            int sourceIndex = sourceFields.indexOfValue(source);
            if (sourceIndex < 0) {
                missingSourceFields.append(Const.CR).append("   ").append(source).append(" --> ").append(target);
            }
            if ((targetIndex = targetFields.indexOfValue(target)) < 0) {
                missingTargetFields.append(Const.CR).append("   ").append(source).append(" --> ").append(target);
            }
            if (sourceIndex < 0 || targetIndex < 0) continue;
            SourceToTargetMapping mapping = new SourceToTargetMapping(sourceIndex, targetIndex);
            mappings.add(mapping);
        }
        if (!missingSourceFields.isEmpty() || !missingTargetFields.isEmpty()) {
            Object message = "";
            if (!missingSourceFields.isEmpty()) {
                message = (String)message + BaseMessages.getString(PKG, (String)"MySqlBulkLoaderDialog.DoMapping.SomeSourceFieldsNotFound", (String[])new String[]{missingSourceFields.toString()}) + Const.CR;
            }
            if (!missingTargetFields.isEmpty()) {
                message = (String)message + BaseMessages.getString(PKG, (String)"MySqlBulkLoaderDialog.DoMapping.SomeTargetFieldsNotFound", (String[])new String[]{missingSourceFields.toString()}) + Const.CR;
            }
            message = (String)message + Const.CR;
            message = (String)message + BaseMessages.getString(PKG, (String)"MySqlBulkLoaderDialog.DoMapping.SomeFieldsNotFoundContinue", (String[])new String[0]) + Const.CR;
            ShowMessageDialog msgDialog = new ShowMessageDialog(this.shell, 34, BaseMessages.getString(PKG, (String)"MySqlBulkLoaderDialog.DoMapping.SomeFieldsNotFoundTitle", (String[])new String[0]), (String)message, false);
            msgDialog.open();
        }
        if ((mappings = (d = new EnterMappingDialog(this.shell, sourceFields.getFieldNames(), targetFields.getFieldNames(), mappings)).open()) != null) {
            this.wReturn.table.removeAll();
            this.wReturn.table.setItemCount(mappings.size());
            for (int i = 0; i < mappings.size(); ++i) {
                SourceToTargetMapping mapping = (SourceToTargetMapping)mappings.get(i);
                TableItem item = this.wReturn.table.getItem(i);
                item.setText(2, sourceFields.getValueMeta(mapping.getSourcePosition()).getName());
                item.setText(1, targetFields.getValueMeta(mapping.getTargetPosition()).getName());
                item.setText(3, MySqlBulkLoaderMeta.getFieldFormatTypeDescription(MySqlBulkLoaderMeta.getFieldFormatType(this.input.getFields().get(i).getFieldFormatType())));
            }
            this.wReturn.setRowNums();
            this.wReturn.optWidth(true);
        }
    }

    public void getData() {
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"MySqlBulkLoaderDialog.Log.GettingKeyInfo", (String[])new String[0]));
        }
        this.wEnclosure.setText(Const.NVL((String)this.input.getEnclosure(), (String)""));
        this.wDelimiter.setText(Const.NVL((String)this.input.getDelimiter(), (String)""));
        this.wEscapeChar.setText(Const.NVL((String)this.input.getEscapeChar(), (String)""));
        this.wLoadCharSet.setText(Const.NVL((String)this.input.getLoadCharSet(), (String)""));
        this.wCharSet.setText(Const.NVL((String)this.input.getEncoding(), (String)""));
        this.wReplace.setSelection(this.input.isReplacingData());
        this.wIgnore.setSelection(this.input.isIgnoringErrors());
        this.wLocal.setSelection(this.input.isLocalFile());
        this.wBulkSize.setText(Const.NVL((String)this.input.getBulkSize(), (String)""));
        if (this.input.getFields() != null) {
            for (int i = 0; i < this.input.getFields().size(); ++i) {
                TableItem item = this.wReturn.table.getItem(i);
                if (this.input.getFields().get(i).getFieldTable() != null) {
                    item.setText(1, this.input.getFields().get(i).getFieldTable());
                }
                if (this.input.getFields().get(i).getFieldStream() != null) {
                    item.setText(2, this.input.getFields().get(i).getFieldStream());
                }
                item.setText(3, MySqlBulkLoaderMeta.getFieldFormatTypeDescription(MySqlBulkLoaderMeta.getFieldFormatType(this.input.getFields().get(i).getFieldFormatType())));
            }
        }
        if (this.input.getConnection() != null) {
            this.wConnection.setText(this.input.getConnection());
        }
        if (this.input.getSchemaName() != null) {
            this.wSchema.setText(this.input.getSchemaName());
        }
        if (this.input.getTableName() != null) {
            this.wTable.setText(this.input.getTableName());
        }
        if (this.input.getFifoFileName() != null) {
            this.wFifoFile.setText(this.input.getFifoFileName());
        }
        this.wReturn.setRowNums();
        this.wReturn.optWidth(true);
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    protected void setComboBoxes() {
        HashMap<String, Integer> fields = new HashMap<String, Integer>();
        fields.putAll(this.inputFields);
        Set keySet = fields.keySet();
        ArrayList entries = new ArrayList(keySet);
        String[] fieldNames = entries.toArray(new String[entries.size()]);
        Const.sortStrings((String[])fieldNames);
        this.ciReturn[1].setComboValues(fieldNames);
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void getInfo(MySqlBulkLoaderMeta inf) {
        int nrfields = this.wReturn.nrNonEmpty();
        inf.setEnclosure(this.wEnclosure.getText());
        inf.setDelimiter(this.wDelimiter.getText());
        inf.setEscapeChar(this.wEscapeChar.getText());
        inf.setLoadCharSet(this.wLoadCharSet.getText());
        inf.setEncoding(this.wCharSet.getText());
        inf.setReplacingData(this.wReplace.getSelection());
        inf.setIgnoringErrors(this.wIgnore.getSelection());
        inf.setLocalFile(this.wLocal.getSelection());
        inf.setBulkSize(this.wBulkSize.getText());
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"MySqlBulkLoaderDialog.Log.FoundFields", (String[])new String[]{"" + nrfields}));
        }
        ArrayList<MySqlBulkLoaderMeta.Field> fields = new ArrayList<MySqlBulkLoaderMeta.Field>();
        for (int i = 0; i < nrfields; ++i) {
            TableItem item = this.wReturn.getNonEmpty(i);
            MySqlBulkLoaderMeta.Field field = new MySqlBulkLoaderMeta.Field();
            field.setFieldTable(item.getText(1));
            field.setFieldStream(item.getText(2));
            field.setFieldFormatType(MySqlBulkLoaderMeta.getFieldFormatTypeCode(MySqlBulkLoaderMeta.getFieldFormatType(item.getText(3))));
            fields.add(field);
        }
        inf.setFields(fields);
        inf.setSchemaName(this.wSchema.getText());
        inf.setTableName(this.wTable.getText());
        inf.setConnection(this.wConnection.getText());
        inf.setFifoFileName(this.wFifoFile.getText());
        this.transformName = this.wTransformName.getText();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.getInfo(this.input);
        if (this.input.getConnection() == null) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"MySqlBulkLoaderDialog.InvalidConnection.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"MySqlBulkLoaderDialog.InvalidConnection.DialogTitle", (String[])new String[0]));
            mb.open();
        }
        this.dispose();
    }

    private void getTableName() {
        DatabaseMeta inf = null;
        if (!this.wConnection.getText().isEmpty()) {
            inf = this.pipelineMeta.findDatabase(this.wConnection.getText(), this.variables);
        }
        if (inf != null) {
            if (this.log.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"MySqlBulkLoaderDialog.Log.LookingAtConnection", (String[])new String[0]) + inf.toString());
            }
            DatabaseExplorerDialog std = new DatabaseExplorerDialog(this.shell, 0, this.variables, inf, this.pipelineMeta.getDatabases(), false, true);
            std.setSelectedSchemaAndTable(this.wSchema.getText(), this.wTable.getText());
            if (std.open()) {
                this.wSchema.setText(Const.NVL((String)std.getSchemaName(), (String)""));
                this.wTable.setText(Const.NVL((String)std.getTableName(), (String)""));
            }
        } else {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"MySqlBulkLoaderDialog.InvalidConnection.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"MySqlBulkLoaderDialog.InvalidConnection.DialogTitle", (String[])new String[0]));
            mb.open();
        }
    }

    private void getUpdate() {
        try {
            IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            if (r != null) {
                ITableItemInsertListener listener = (tableItem, v) -> {
                    if (v.getType() == 3) {
                        tableItem.setText(3, BaseMessages.getString(PKG, (String)"MySqlBulkLoaderMeta.FieldFormatType.Date.Description", (String[])new String[0]));
                    } else {
                        tableItem.setText(3, BaseMessages.getString(PKG, (String)"MySqlBulkLoaderMeta.FieldFormatType.OK.Description", (String[])new String[0]));
                    }
                    return true;
                };
                BaseTransformDialog.getFieldsFromPrevious((IRowMeta)r, (TableView)this.wReturn, (int)1, (int[])new int[]{1, 2}, (int[])new int[0], (int)-1, (int)-1, (ITableItemInsertListener)listener);
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"MySqlBulkLoaderDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MySqlBulkLoaderDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    private void create() {
        try {
            MySqlBulkLoaderMeta info = new MySqlBulkLoaderMeta();
            this.getInfo(info);
            String name = this.transformName;
            TransformMeta transformMeta = new TransformMeta(BaseMessages.getString(PKG, (String)"MySqlBulkLoaderDialog.TransformMeta.Title", (String[])new String[0]), name, (ITransformMeta)info);
            IRowMeta prev = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            DatabaseMeta databaseMeta = this.pipelineMeta.findDatabase(this.wConnection.getText(), this.variables);
            SqlStatement sql = info.getSqlStatements(this.variables, this.pipelineMeta, transformMeta, prev, this.metadataProvider);
            if (!sql.hasError()) {
                if (sql.hasSql()) {
                    SqlEditor sqledit = new SqlEditor(this.shell, 0, this.variables, databaseMeta, DbCache.getInstance(), sql.getSql());
                    sqledit.open();
                } else {
                    MessageBox mb = new MessageBox(this.shell, 34);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"MySqlBulkLoaderDialog.NoSQLNeeds.DialogMessage", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"MySqlBulkLoaderDialog.NoSQLNeeds.DialogTitle", (String[])new String[0]));
                    mb.open();
                }
            } else {
                MessageBox mb = new MessageBox(this.shell, 33);
                mb.setMessage(sql.getError());
                mb.setText(BaseMessages.getString(PKG, (String)"MySqlBulkLoaderDialog.SQLError.DialogTitle", (String[])new String[0]));
                mb.open();
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"MySqlBulkLoaderDialog.CouldNotBuildSQL.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MySqlBulkLoaderDialog.CouldNotBuildSQL.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    private void setTableFieldCombo() {
        Runnable fieldLoader = () -> {
            block12: {
                if (!(this.wTable.isDisposed() || this.wConnection.isDisposed() || this.wSchema.isDisposed())) {
                    DatabaseMeta ci;
                    String tableName = this.wTable.getText();
                    String connectionName = this.wConnection.getText();
                    String schemaName = this.wSchema.getText();
                    for (ColumnInfo colInfo : this.tableFieldColumns) {
                        colInfo.setComboValues(new String[0]);
                    }
                    if (!Utils.isEmpty((CharSequence)tableName) && (ci = this.pipelineMeta.findDatabase(connectionName, this.variables)) != null) {
                        try (Database db = new Database(loggingObject, this.variables, ci);){
                            String[] fieldNames;
                            db.connect();
                            String schemaTable = ci.getQuotedSchemaTableCombination(this.variables, this.variables.resolve(schemaName), this.variables.resolve(tableName));
                            IRowMeta r = db.getTableFields(schemaTable);
                            if (null == r || null == (fieldNames = r.getFieldNames())) break block12;
                            for (ColumnInfo colInfo : this.tableFieldColumns) {
                                colInfo.setComboValues(fieldNames);
                            }
                        }
                        catch (Exception e) {
                            for (ColumnInfo colInfo : this.tableFieldColumns) {
                                colInfo.setComboValues(new String[0]);
                            }
                        }
                    }
                }
            }
        };
        this.shell.getDisplay().asyncExec(fieldLoader);
    }
}

