/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.core.fn;

import java.util.Date;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.values.KV;
import org.apache.hop.beam.core.BeamHop;
import org.apache.hop.beam.core.HopRow;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.JsonRowMeta;
import org.apache.hop.core.xml.XmlHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class StaticHopRowFn
extends DoFn<KV<byte[], byte[]>, HopRow> {
    private final String transformName;
    private final String rowMetaJson;
    private final String rowDataXml;
    private final boolean neverEnding;
    private final int currentTimeFieldIndex;
    private final int previousTimeFieldIndex;
    private transient RowMetaAndData rowMetaAndData;
    private transient Counter writtenCounter;
    private transient Date previousDate;

    public StaticHopRowFn(String transformName, String rowMetaJson, String rowDataXml, boolean neverEnding, int currentTimeFieldIndex, int previousTimeFieldIndex) {
        this.transformName = transformName;
        this.rowMetaJson = rowMetaJson;
        this.rowDataXml = rowDataXml;
        this.neverEnding = neverEnding;
        this.currentTimeFieldIndex = currentTimeFieldIndex;
        this.previousTimeFieldIndex = previousTimeFieldIndex;
    }

    @DoFn.Setup
    public void setUp() {
        try {
            this.writtenCounter = Metrics.counter((String)"written", (String)this.transformName);
            BeamHop.init();
            IRowMeta rowMeta = JsonRowMeta.fromJson((String)this.rowMetaJson);
            Document document = XmlHandler.loadXmlString((String)this.rowDataXml);
            Node node = XmlHandler.getSubNode((Node)document, (String)"row-data");
            Object[] rowData = rowMeta.getRow(node);
            this.rowMetaAndData = new RowMetaAndData(rowMeta, rowData);
            Metrics.counter((String)"init", (String)this.transformName).inc();
        }
        catch (Exception e) {
            Metrics.counter((String)"error", (String)this.transformName).inc();
            throw new RuntimeException("Error in setup of converting row generator row into Hop rows", e);
        }
    }

    @DoFn.ProcessElement
    public void processElement(DoFn.ProcessContext processContext) {
        processContext.element();
        try {
            IRowMeta rowMeta = this.rowMetaAndData.getRowMeta();
            Object[] rowData = this.rowMetaAndData.getData();
            Object[] rowCopy = rowMeta.cloneRow(rowData);
            if (this.neverEnding) {
                Date currentDate = new Date();
                if (this.currentTimeFieldIndex >= 0) {
                    rowCopy[this.currentTimeFieldIndex] = currentDate;
                }
                if (this.previousTimeFieldIndex >= 0) {
                    rowCopy[this.previousTimeFieldIndex] = this.previousDate;
                }
                this.previousDate = currentDate;
            }
            processContext.output((Object)new HopRow(rowCopy));
            this.writtenCounter.inc();
        }
        catch (HopException e) {
            throw new RuntimeException("Unable to create copy of row", e);
        }
    }
}

