/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.drools;

import java.util.Hashtable;
import java.util.Map;

public class Rules {

    public static class Column {
        private String name;
        private String type;
        private Object payload;
        private boolean external;

        public Column() {
            this.external = false;
        }

        public Column(Boolean external) {
            this.external = external;
        }

        public Column(String name, String type, Object payload) {
            this();
            this.name = name;
            this.type = type;
            this.payload = payload;
        }

        public Column(Boolean external, String name, String type, Object payload) {
            this(external);
            this.name = name;
            this.type = type;
            this.payload = payload;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public Object getPayload() {
            return this.payload;
        }

        public void setPayload(Object payload) {
            this.payload = payload;
        }

        public void setExternalSource(boolean external) {
            this.external = external;
        }

        public boolean isExternalSource() {
            return this.external;
        }
    }

    public static class Row {
        private final Map<String, Object> row;
        private final boolean external;

        public Row() {
            this(new Hashtable<String, Object>(), false);
        }

        public Row(Map<String, Object> row) {
            this(row, false);
        }

        public Row(boolean external) {
            this(new Hashtable<String, Object>(), external);
        }

        public Row(Map<String, Object> row, boolean external) {
            this.row = row;
            this.external = external;
        }

        public Map<String, Object> getColumn() {
            return this.row;
        }

        public boolean isExternalSource() {
            return this.external;
        }

        public void addColumn(String columnName, Object value) {
            this.row.put(columnName, value);
        }
    }
}

