/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.PxDSFactory;
import com.ibm.as400.access.PxDSRV;
import com.ibm.as400.access.PxRepCV;
import com.ibm.as400.access.StoppableThread;
import com.ibm.as400.access.Trace;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;

class PxClientReadDaemon
extends StoppableThread {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private PxDSFactory factory_ = new PxDSFactory();
    private InputStream input_;
    private InvocationTargetException invocationTargetException_ = null;
    private IOException ioException_ = null;
    private Hashtable replies_ = new Hashtable();
    private boolean running_ = false;
    private boolean started_ = false;

    public PxClientReadDaemon() {
        super("Proxy client read daemon-" + PxClientReadDaemon.newId());
        this.setDaemon(true);
    }

    public PxClientReadDaemon(InputStream input) {
        super("Proxy client read daemon-" + PxClientReadDaemon.newId());
        this.setDaemon(true);
        this.input_ = input;
    }

    public PxDSFactory getFactory() {
        return this.factory_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PxRepCV getReply(long correlationId) throws InvocationTargetException, IOException {
        Long key = correlationId;
        while (true) {
            if (this.ioException_ != null) {
                IOException ioEx = this.ioException_;
                this.ioException_ = null;
                throw ioEx;
            }
            if (this.invocationTargetException_ != null) {
                InvocationTargetException ite = this.invocationTargetException_;
                this.invocationTargetException_ = null;
                throw ite;
            }
            PxClientReadDaemon pxClientReadDaemon = this;
            synchronized (pxClientReadDaemon) {
                if (Trace.isTraceProxyOn()) {
                    Trace.log(6, this, "correlationId is " + correlationId);
                }
                if (this.replies_.containsKey(key)) {
                    PxRepCV reply = (PxRepCV)this.replies_.get(key);
                    this.replies_.remove(key);
                    return reply;
                }
                if (this.running_ || !this.started_) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                } else {
                    if (Trace.isTraceErrorOn()) {
                        Trace.log(2, "Proxy read daemon stopped, but replies are expected.");
                    }
                    throw new InternalErrorException(4);
                }
            }
        }
    }

    public void register(PxDSRV datastream) {
        this.factory_.register(datastream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        this.started_ = true;
        this.running_ = true;
        try {
            while (this.canContinue()) {
                long correlationId;
                this.ioException_ = null;
                if (Trace.isTraceProxyOn()) {
                    Trace.log(6, this, "calling factory_.getNextDS");
                }
                PxRepCV reply = (PxRepCV)this.factory_.getNextDS(this.input_);
                if (Trace.isTraceProxyOn()) {
                    reply.dump(Trace.getPrintWriter());
                }
                if ((correlationId = reply.getCorrelationId()) >= 0L) {
                    PxClientReadDaemon pxClientReadDaemon = this;
                    synchronized (pxClientReadDaemon) {
                        this.replies_.put(correlationId, reply);
                        this.notifyAll();
                        continue;
                    }
                }
                reply.process();
            }
            if (Trace.isTraceProxyOn()) {
                Trace.log(6, this, "Exited while loop");
            }
        }
        catch (InvocationTargetException e) {
            this.invocationTargetException_ = e;
        }
        catch (IOException e) {
            if (!this.wasStoppedSafely() && !(e instanceof EOFException)) {
                this.ioException_ = e;
                if (Trace.isTraceProxyOn()) {
                    Trace.log(6, "Ending read daemon", (Throwable)e);
                }
            }
            PxClientReadDaemon pxClientReadDaemon = this;
            synchronized (pxClientReadDaemon) {
                this.notifyAll();
            }
        }
        if (Trace.isTraceProxyOn()) {
            Trace.log(6, this, "Leaving running loop invocationTargetException_=" + this.invocationTargetException_ + " ioException_=" + this.ioException_);
        }
        this.running_ = false;
    }

    public PxRepCV getReply(long CID, InputStream input_) throws InvocationTargetException, IOException {
        PxRepCV reply;
        Long key;
        if (Trace.isTraceProxyOn()) {
            Trace.log(6, this, "getReply");
        }
        if (this.replies_.containsKey(key = Long.valueOf(CID))) {
            PxRepCV reply2 = (PxRepCV)this.replies_.get(key);
            this.replies_.remove(key);
            return reply2;
        }
        while (true) {
            long correlationId;
            if (Trace.isTraceProxyOn()) {
                Trace.log(6, this, "calling factory_.getNextDS");
            }
            reply = (PxRepCV)this.factory_.getNextDS(input_);
            if (Trace.isTraceProxyOn()) {
                reply.dump(Trace.getPrintWriter());
            }
            if ((correlationId = reply.getCorrelationId()) == CID) break;
            this.replies_.put(correlationId, reply);
        }
        reply.process();
        return reply;
    }
}

