/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.NetServerShare;
import com.ibm.as400.access.Trace;
import com.ibm.as400.data.PcmlException;
import com.ibm.as400.data.ProgramCallDocument;
import com.ibm.as400.resource.ProgramMap;
import com.ibm.as400.resource.ResourceException;
import com.ibm.as400.resource.ResourceList;

public class NetServerFileShare
extends NetServerShare {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private static ProgramMap setterMap_ = new ProgramMap();
    private static ProgramMap openListAttributeMap_ = new ProgramMap();
    private static final String ADFS_ = "qzlsadfs";
    private static final String CHFS_ = "qzlschfs";
    public static final String MAXIMUM_USERS = "MAXIMUM_USERS";
    public static final String PATH = "PATH";
    static final String PATH_LENGTH = "PATH_LENGTH";
    public static final String PERMISSION = "PERMISSION";
    public static final Integer PERMISSION_READ_ONLY;
    public static final Integer PERMISSION_READ_WRITE;

    public NetServerFileShare() {
    }

    public NetServerFileShare(AS400 system, String name) {
        super(system, name);
    }

    @Override
    public void add() throws ResourceException {
        try {
            this.freezeProperties();
            if (this.document_ == null) {
                this.document_ = (ProgramCallDocument)staticDocument_.clone();
            }
            this.document_.setSystem(this.getSystem());
            this.document_.setValue("qzlsadfs.shareName", this.getName());
            this.document_.setValue("qzlschfs.shareName", this.getName());
            if (this.hasUncommittedAttributeChanges("DESCRIPTION")) {
                this.document_.setValue("qzlsadfs.description", (String)this.getAttributeValue("DESCRIPTION"));
                this.document_.setValue("qzlschfs.description", (String)this.getAttributeValue("DESCRIPTION"));
            }
            if (!this.hasUncommittedAttributeChanges(PATH)) {
                throw new ExtendedIllegalStateException("path", 4);
            }
            String path = (String)this.getAttributeValue(PATH);
            Integer pathLength = path.length() * 2;
            this.document_.setValue("qzlsadfs.lengthOfPathName", pathLength);
            this.document_.setValue("qzlsadfs.pathName", path);
            this.document_.setValue("qzlschfs.lengthOfPathName", pathLength);
            this.document_.setValue("qzlschfs.pathName", path);
            if (this.hasUncommittedAttributeChanges(PERMISSION)) {
                this.document_.setValue("qzlsadfs.permissions", (Integer)this.getAttributeValue(PERMISSION));
                this.document_.setValue("qzlschfs.permissions", (Integer)this.getAttributeValue(PERMISSION));
            }
            if (this.hasUncommittedAttributeChanges(MAXIMUM_USERS)) {
                this.document_.setValue("qzlsadfs.maximumUsers", (Integer)this.getAttributeValue(MAXIMUM_USERS));
                this.document_.setValue("qzlschfs.maximumUsers", (Integer)this.getAttributeValue(MAXIMUM_USERS));
            }
            if (!this.isConnectionEstablished()) {
                this.establishConnection(false);
            }
            if (!this.document_.callProgram(ADFS_)) {
                throw new ResourceException(this.document_.getMessageList(ADFS_));
            }
            this.fireResourceCreated();
        }
        catch (PcmlException e) {
            Trace.log(2, "PcmlException when adding a file share.", (Throwable)e);
            throw new ResourceException(e);
        }
    }

    @Override
    protected void commitAttributeChanges(Object[] attributeIDs, Object[] values) throws ResourceException {
        for (int i = 0; i < attributeIDs.length; ++i) {
            String id = (String)attributeIDs[i];
            if (!id.equals(PATH)) continue;
            String path = (String)values[i];
            int pathLength = path.length() * 2;
            this.setAttributeValue(PATH_LENGTH, pathLength);
            int numIDs = attributeIDs.length;
            Object[] ids = new Object[numIDs + 1];
            System.arraycopy(attributeIDs, 0, ids, 0, numIDs);
            ids[numIDs] = PATH_LENGTH;
            Object[] vals = new Object[numIDs + 1];
            System.arraycopy(values, 0, vals, 0, numIDs);
            vals[numIDs] = pathLength;
            attributeIDs = ids;
            values = vals;
            break;
        }
        super.commitAttributeChanges(attributeIDs, values);
    }

    @Override
    protected void establishConnection() throws ResourceException {
        this.establishConnection(true);
    }

    @Override
    void establishConnection(boolean initializeSetterFromSystem) throws ResourceException {
        Object[] attrsToSetFirst = new Object[]{PATH_LENGTH};
        super.establishConnection(setterMap_, attrsToSetFirst, initializeSetterFromSystem);
    }

    static ResourceList list(AS400 sys) throws ResourceException {
        return NetServerFileShare.list(sys, "*ALL");
    }

    static ResourceList list(AS400 sys, String shareName) throws ResourceException {
        return NetServerShare.list(sys, 0, shareName, openListAttributeMap_);
    }

    static {
        try {
            Class.forName("com.ibm.as400.access.NetServerShare");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        setterMap_.add("DESCRIPTION", CHFS_, "description");
        openListAttributeMap_.add("DESCRIPTION", "qzlsolst_zlsl0100", "receiverVariable.description");
        openListAttributeMap_.add("USER_COUNT", "qzlsolst_zlsl0100", "receiverVariable.currentUsers");
        attributes_.add((Object)MAXIMUM_USERS, Integer.class, -1);
        getterMap_.add((Object)MAXIMUM_USERS, "qzlsolst_zlsl0100", "receiverVariable.maximumUsers", INDICES_);
        setterMap_.add(MAXIMUM_USERS, CHFS_, "maximumUsers");
        openListAttributeMap_.add(MAXIMUM_USERS, "qzlsolst_zlsl0100", "receiverVariable.maximumUsers");
        attributes_.add(PATH, String.class);
        getterMap_.add((Object)PATH, "qzlsolst_zlsl0100", "receiverVariable.pathName", INDICES_);
        setterMap_.add(PATH, CHFS_, "pathName");
        openListAttributeMap_.add(PATH, "qzlsolst_zlsl0100", "receiverVariable.pathName");
        attributes_.add(PATH_LENGTH, Integer.class);
        getterMap_.add((Object)PATH_LENGTH, "qzlsolst_zlsl0100", "receiverVariable.lengthOfPathName", INDICES_);
        setterMap_.add(PATH_LENGTH, CHFS_, "lengthOfPathName");
        openListAttributeMap_.add(PATH_LENGTH, "qzlsolst_zlsl0100", "receiverVariable.lengthOfPathName");
        PERMISSION_READ_ONLY = 1;
        PERMISSION_READ_WRITE = 2;
        attributes_.add(PERMISSION, Integer.class, false, new Object[]{PERMISSION_READ_ONLY, PERMISSION_READ_WRITE}, PERMISSION_READ_WRITE, true);
        getterMap_.add((Object)PERMISSION, "qzlsolst_zlsl0100", "receiverVariable.permissions", INDICES_);
        setterMap_.add(PERMISSION, CHFS_, "permissions");
        openListAttributeMap_.add(PERMISSION, "qzlsolst_zlsl0100", "receiverVariable.permissions");
    }
}

