/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.perspective.configuration.tabs;

import org.apache.hop.core.Const;
import org.apache.hop.core.config.HopConfig;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.tab.GuiTab;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.hopgui.HopGui;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

@GuiPlugin
public class ConfigGeneralOptionsTab {
    private static final Class<?> PKG = BaseDialog.class;
    private Text wDefaultPreview;
    private Button wUseCache;
    private Button wOpenLast;
    private Button wReloadFileOnChange;
    private Button wAutoSave;
    private Button wAutoSplit;
    private Button wCopyDistribute;
    private Button wExitWarning;
    private Button wToolTip;
    private Button wResolveVarsInTips;
    private Button wbUseGlobalFileBookmarks;
    private Button wSortFieldByName;
    private Text wMaxExecutionLoggingTextSize;
    private boolean isReloading = false;

    public void reloadValues() {
        if (this.wDefaultPreview == null || this.wDefaultPreview.isDisposed()) {
            return;
        }
        this.isReloading = true;
        try {
            PropsUi props = PropsUi.getInstance();
            this.wDefaultPreview.setText(Integer.toString(props.getDefaultPreviewSize()));
            this.wUseCache.setSelection(props.useDBCache());
            this.wOpenLast.setSelection(props.openLastFile());
            this.wReloadFileOnChange.setSelection(props.isReloadingFilesOnChange());
            this.wAutoSave.setSelection(!props.getAutoSave());
            this.wCopyDistribute.setSelection(props.showCopyOrDistributeWarning());
            this.wExitWarning.setSelection(props.showExitWarning());
            this.wAutoSplit.setSelection(!props.getAutoSplit());
            this.wToolTip.setSelection(props.showToolTips());
            this.wResolveVarsInTips.setSelection(props.resolveVariablesInToolTips());
            this.wSortFieldByName.setSelection(props.isSortFieldByName());
            this.wbUseGlobalFileBookmarks.setSelection(props.useGlobalFileBookmarks());
            this.wMaxExecutionLoggingTextSize.setText(Integer.toString(props.getMaxExecutionLoggingTextSize()));
        }
        finally {
            this.isReloading = false;
        }
    }

    @GuiTab(id="10000-config-perspective-general-options-tab", parentId="ConfigurationPerspective.Tabs.ID", description="General options tab")
    public void addGeneralOptionsTab(CTabFolder wTabFolder) {
        Shell shell = wTabFolder.getShell();
        PropsUi props = PropsUi.getInstance();
        int margin = PropsUi.getMargin();
        CTabItem wGeneralTab = new CTabItem(wTabFolder, 0);
        wGeneralTab.setImage(GuiResource.getInstance().getImageOptions());
        PropsUi.setLook((Widget)wGeneralTab);
        wGeneralTab.setText(BaseMessages.getString(PKG, (String)"EnterOptionsDialog.General.Label", (String[])new String[0]));
        ScrolledComposite sGeneralComp = new ScrolledComposite((Composite)wTabFolder, 768);
        sGeneralComp.setLayout((Layout)new FillLayout());
        Composite wGeneralComp = new Composite((Composite)sGeneralComp, 0);
        PropsUi.setLook((Widget)wGeneralComp);
        FormLayout generalLayout = new FormLayout();
        generalLayout.marginWidth = PropsUi.getFormMargin();
        generalLayout.marginHeight = PropsUi.getFormMargin();
        wGeneralComp.setLayout((Layout)generalLayout);
        Control[] filenameControls = this.createTextField(wGeneralComp, "EnterOptionsDialog.ConfigFilename.Label", null, Const.NVL((String)HopConfig.getInstance().getConfigFilename(), (String)""), null, margin);
        Text wFilename = (Text)filenameControls[1];
        String configFolder = System.getProperty("HOP_CONFIG_FOLDER");
        boolean isConfigFromEnv = configFolder != null && !configFolder.trim().isEmpty();
        wFilename.setEnabled(!isConfigFromEnv);
        Text lastControl = wFilename;
        Label wlWhatIsHopConfig = new Label(wGeneralComp, 16384);
        wlWhatIsHopConfig.setText(BaseMessages.getString(PKG, (String)"EnterOptionsDialog.WhatIsHopConfigSize.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlWhatIsHopConfig);
        FormData fdlWhatIsHopConfig = new FormData();
        fdlWhatIsHopConfig.left = new FormAttachment(0, 0);
        fdlWhatIsHopConfig.right = new FormAttachment(100, 0);
        fdlWhatIsHopConfig.top = new FormAttachment((Control)lastControl, margin);
        wlWhatIsHopConfig.setLayoutData((Object)fdlWhatIsHopConfig);
        lastControl = wlWhatIsHopConfig;
        Control[] previewControls = this.createTextField(wGeneralComp, "EnterOptionsDialog.DefaultPreviewSize.Label", null, Integer.toString(props.getDefaultPreviewSize()), (Control)lastControl, margin);
        this.wDefaultPreview = (Text)previewControls[1];
        this.wDefaultPreview.setMessage(BaseMessages.getString(PKG, (String)"EnterOptionsDialog.EnterNumber.Hint", (String[])new String[0]));
        this.wDefaultPreview.addListener(25, e -> {
            String currentText = ((Text)e.widget).getText();
            String newText = currentText.substring(0, e.start) + e.text + currentText.substring(e.end);
            if (!newText.isEmpty() && !newText.matches("\\d+")) {
                e.doit = false;
            }
        });
        lastControl = this.wDefaultPreview;
        this.wUseCache = this.createCheckbox(wGeneralComp, "EnterOptionsDialog.UseDatabaseCache.Label", null, props.useDBCache(), (Control)lastControl, margin);
        lastControl = this.wUseCache;
        this.wOpenLast = this.createCheckbox(wGeneralComp, "EnterOptionsDialog.OpenLastFileStartup.Label", null, props.openLastFile(), (Control)lastControl, margin);
        lastControl = this.wOpenLast;
        this.wReloadFileOnChange = this.createCheckbox(wGeneralComp, "EnterOptionsDialog.ReloadFileOnChange.Label", "EnterOptionsDialog.ReloadFileOnChange.ToolTip", props.isReloadingFilesOnChange(), (Control)lastControl, margin);
        lastControl = this.wReloadFileOnChange;
        this.wSortFieldByName = this.createCheckbox(wGeneralComp, "EnterOptionsDialog.SortFieldByName.Label", "EnterOptionsDialog.SortFieldByName.ToolTip", props.isSortFieldByName(), (Control)lastControl, margin);
        lastControl = this.wSortFieldByName;
        this.wbUseGlobalFileBookmarks = this.createCheckbox(wGeneralComp, "EnterOptionsDialog.UseGlobalFileBookmarks.Label", null, props.useGlobalFileBookmarks(), (Control)lastControl, margin);
        lastControl = this.wbUseGlobalFileBookmarks;
        Control[] loggingControls = this.createTextField(wGeneralComp, "EnterOptionsDialog.MaxExecutionLoggingTextSizeSize.Label", "EnterOptionsDialog.MaxExecutionLoggingTextSizeSize.ToolTip", Integer.toString(props.getMaxExecutionLoggingTextSize()), (Control)lastControl, 2 * margin);
        this.wMaxExecutionLoggingTextSize = (Text)loggingControls[1];
        this.wMaxExecutionLoggingTextSize.setMessage(BaseMessages.getString(PKG, (String)"EnterOptionsDialog.EnterNumber.Hint", (String[])new String[0]));
        this.wMaxExecutionLoggingTextSize.addListener(25, e -> {
            String currentText = ((Text)e.widget).getText();
            String newText = currentText.substring(0, e.start) + e.text + currentText.substring(e.end);
            if (!newText.isEmpty() && !newText.matches("\\d+")) {
                e.doit = false;
            }
        });
        lastControl = this.wMaxExecutionLoggingTextSize;
        ExpandBar expandBar = new ExpandBar(wGeneralComp, 512);
        PropsUi.setLook((Widget)expandBar);
        FormData fdExpandBar = new FormData();
        fdExpandBar.left = new FormAttachment(0, 0);
        fdExpandBar.right = new FormAttachment(100, 0);
        fdExpandBar.top = new FormAttachment((Control)lastControl, 2 * margin);
        expandBar.setLayoutData((Object)fdExpandBar);
        Composite confirmationContent = new Composite((Composite)expandBar, 0);
        PropsUi.setLook((Widget)confirmationContent);
        FormLayout contentLayout = new FormLayout();
        contentLayout.marginWidth = PropsUi.getFormMargin();
        contentLayout.marginHeight = PropsUi.getFormMargin();
        confirmationContent.setLayout((Layout)contentLayout);
        Button lastConfirmControl = null;
        lastConfirmControl = this.wExitWarning = this.createCheckbox(confirmationContent, "EnterOptionsDialog.AskOnExit.Label", null, props.showExitWarning(), (Control)lastConfirmControl, margin);
        lastConfirmControl = this.wCopyDistribute = this.createCheckbox(confirmationContent, "EnterOptionsDialog.CopyOrDistributeDialog.Label", "EnterOptionsDialog.CopyOrDistributeDialog.Tooltip", props.showCopyOrDistributeWarning(), (Control)lastConfirmControl, margin);
        lastConfirmControl = this.wAutoSplit = this.createCheckbox(confirmationContent, "EnterOptionsDialog.SplitHopsConfirm.Label", "EnterOptionsDialog.SplitHopsConfirm.Tooltip", !props.getAutoSplit(), (Control)lastConfirmControl, margin);
        lastConfirmControl = this.wAutoSave = this.createCheckbox(confirmationContent, "EnterOptionsDialog.SaveConfirm.Label", "EnterOptionsDialog.SaveConfirm.Tooltip", !props.getAutoSave(), (Control)lastConfirmControl, margin);
        Control[] resetButtonControls = this.createButton(confirmationContent, "EnterOptionsDialog.ResetConfirmations.Label", "EnterOptionsDialog.ResetConfirmations.Tooltip", (Control)lastConfirmControl, 2 * margin);
        Button wResetConfirmations = (Button)resetButtonControls[0];
        wResetConfirmations.addListener(13, e -> {
            this.wExitWarning.setSelection(true);
            this.wCopyDistribute.setSelection(true);
            this.wAutoSplit.setSelection(true);
            this.wAutoSave.setSelection(true);
            try {
                props.clearCustomParameters();
            }
            catch (Exception ex) {
                new ErrorDialog(shell, "Error", "Error clearing transform warning preferences", ex);
            }
            this.saveValues(null);
        });
        ExpandItem confirmationItem = new ExpandItem(expandBar, 0);
        confirmationItem.setText(BaseMessages.getString(PKG, (String)"EnterOptionsDialog.Section.ConfirmationDialogs", (String[])new String[0]));
        confirmationItem.setControl((Control)confirmationContent);
        confirmationItem.setHeight(confirmationContent.computeSize((int)-1, (int)-1).y);
        confirmationItem.setExpanded(true);
        Composite tooltipsContent = new Composite((Composite)expandBar, 0);
        PropsUi.setLook((Widget)tooltipsContent);
        FormLayout tooltipsLayout = new FormLayout();
        tooltipsLayout.marginWidth = PropsUi.getFormMargin();
        tooltipsLayout.marginHeight = PropsUi.getFormMargin();
        tooltipsContent.setLayout((Layout)tooltipsLayout);
        Button lastTooltipControl = null;
        lastTooltipControl = this.wToolTip = this.createCheckbox(tooltipsContent, "EnterOptionsDialog.ToolTipsEnabled.Label", null, props.showToolTips(), (Control)lastTooltipControl, margin);
        lastTooltipControl = this.wResolveVarsInTips = this.createCheckbox(tooltipsContent, "EnterOptionsDialog.ResolveVarsInTips.Label", null, props.resolveVariablesInToolTips(), (Control)lastTooltipControl, margin);
        Control[] resetTooltipControls = this.createButton(tooltipsContent, "EnterOptionsDialog.ResetTooltips.Label", "EnterOptionsDialog.ResetTooltips.Tooltip", (Control)lastTooltipControl, 2 * margin);
        Button wResetTooltips = (Button)resetTooltipControls[0];
        wResetTooltips.addListener(13, e -> {
            this.wToolTip.setSelection(true);
            this.wResolveVarsInTips.setSelection(true);
            this.saveValues(null);
        });
        ExpandItem tooltipsItem = new ExpandItem(expandBar, 0);
        tooltipsItem.setText(BaseMessages.getString(PKG, (String)"EnterOptionsDialog.Section.Tooltips", (String[])new String[0]));
        tooltipsItem.setControl((Control)tooltipsContent);
        tooltipsItem.setHeight(tooltipsContent.computeSize((int)-1, (int)-1).y);
        tooltipsItem.setExpanded(true);
        expandBar.addListener(17, e -> Display.getDefault().asyncExec(() -> {
            if (!wGeneralComp.isDisposed() && !sGeneralComp.isDisposed()) {
                wGeneralComp.layout();
                sGeneralComp.setMinHeight(wGeneralComp.computeSize((int)-1, (int)-1).y);
            }
        }));
        expandBar.addListener(18, e -> Display.getDefault().asyncExec(() -> {
            if (!wGeneralComp.isDisposed() && !sGeneralComp.isDisposed()) {
                wGeneralComp.layout();
                sGeneralComp.setMinHeight(wGeneralComp.computeSize((int)-1, (int)-1).y);
            }
        }));
        FormData fdGeneralComp = new FormData();
        fdGeneralComp.left = new FormAttachment(0, 0);
        fdGeneralComp.right = new FormAttachment(100, 0);
        fdGeneralComp.top = new FormAttachment(0, 0);
        fdGeneralComp.bottom = new FormAttachment(100, 100);
        wGeneralComp.setLayoutData((Object)fdGeneralComp);
        wGeneralComp.pack();
        Rectangle bounds = wGeneralComp.getBounds();
        sGeneralComp.setContent((Control)wGeneralComp);
        sGeneralComp.setExpandHorizontal(true);
        sGeneralComp.setExpandVertical(true);
        sGeneralComp.setMinWidth(bounds.width);
        sGeneralComp.setMinHeight(bounds.height);
        wGeneralTab.setControl((Control)sGeneralComp);
    }

    private Control[] createTextField(Composite parent, String labelKey, String tooltipKey, String initialValue, Control lastControl, int margin) {
        Label label = new Label(parent, 16384);
        PropsUi.setLook((Widget)label);
        label.setText(BaseMessages.getString(PKG, (String)labelKey, (String[])new String[0]));
        FormData fdLabel = new FormData();
        fdLabel.left = new FormAttachment(0, 0);
        fdLabel.right = new FormAttachment(100, 0);
        fdLabel.top = lastControl != null ? new FormAttachment(lastControl, margin) : new FormAttachment(0, margin);
        label.setLayoutData((Object)fdLabel);
        Text text = new Text(parent, 18436);
        PropsUi.setLook((Widget)text);
        text.setText(initialValue);
        if (tooltipKey != null) {
            text.setToolTipText(BaseMessages.getString(PKG, (String)tooltipKey, (String[])new String[0]));
        }
        text.addListener(24, this::saveValues);
        FormData fdText = new FormData();
        fdText.left = new FormAttachment(0, 0);
        fdText.right = new FormAttachment(100, 0);
        fdText.top = new FormAttachment((Control)label, margin / 2);
        text.setLayoutData((Object)fdText);
        return new Control[]{label, text};
    }

    private Control[] createButton(Composite parent, String labelKey, String tooltipKey, Control lastControl, int margin) {
        Button button = new Button(parent, 8);
        PropsUi.setLook((Widget)button);
        Image buttonImage = GuiResource.getInstance().getImageResetOption();
        if (buttonImage != null) {
            button.setImage(buttonImage);
            button.setBackground(GuiResource.getInstance().getColorWhite());
        } else {
            button.setText(BaseMessages.getString(PKG, (String)"EnterOptionsDialog.Button.Reset", (String[])new String[0]));
        }
        if (tooltipKey != null) {
            button.setToolTipText(BaseMessages.getString(PKG, (String)tooltipKey, (String[])new String[0]));
        }
        int buttonHeight = (int)(32.0 * PropsUi.getInstance().getZoomFactor());
        if (buttonImage != null) {
            buttonHeight = Math.max(buttonHeight, buttonImage.getBounds().height + 8);
        }
        FormData fdButton = new FormData();
        fdButton.left = new FormAttachment(0, 0);
        fdButton.height = buttonHeight;
        fdButton.top = lastControl != null ? new FormAttachment(lastControl, margin) : new FormAttachment(0, margin);
        button.setLayoutData((Object)fdButton);
        Label label = new Label(parent, 16384);
        PropsUi.setLook((Widget)label);
        label.setText(BaseMessages.getString(PKG, (String)labelKey, (String[])new String[0]));
        FormData fdLabel = new FormData();
        fdLabel.left = new FormAttachment((Control)button, margin);
        fdLabel.top = new FormAttachment((Control)button, 0, 0x1000000);
        fdLabel.right = new FormAttachment(100, 0);
        label.setLayoutData((Object)fdLabel);
        return new Control[]{button, label};
    }

    private Button createCheckbox(Composite parent, String labelKey, String tooltipKey, boolean selected, Control lastControl, int margin) {
        Button checkbox = new Button(parent, 32);
        PropsUi.setLook((Widget)checkbox);
        checkbox.setText(BaseMessages.getString(PKG, (String)labelKey, (String[])new String[0]));
        if (tooltipKey != null) {
            checkbox.setToolTipText(BaseMessages.getString(PKG, (String)tooltipKey, (String[])new String[0]));
        }
        checkbox.setSelection(selected);
        checkbox.addListener(13, this::saveValues);
        FormData fdCheckbox = new FormData();
        fdCheckbox.left = new FormAttachment(0, 0);
        fdCheckbox.right = new FormAttachment(100, 0);
        fdCheckbox.top = lastControl != null ? new FormAttachment(lastControl, margin) : new FormAttachment(0, margin);
        checkbox.setLayoutData((Object)fdCheckbox);
        return checkbox;
    }

    private void saveValues(Event event) {
        if (this.isReloading) {
            return;
        }
        PropsUi props = PropsUi.getInstance();
        props.setDefaultPreviewSize(Const.toInt((String)this.wDefaultPreview.getText(), (int)props.getDefaultPreviewSize()));
        props.setUseDBCache(this.wUseCache.getSelection());
        props.setOpenLastFile(this.wOpenLast.getSelection());
        props.setReloadingFilesOnChange(this.wReloadFileOnChange.getSelection());
        props.setAutoSave(!this.wAutoSave.getSelection());
        props.setAutoSplit(!this.wAutoSplit.getSelection());
        props.setShowCopyOrDistributeWarning(this.wCopyDistribute.getSelection());
        props.setExitWarningShown(this.wExitWarning.getSelection());
        props.setShowToolTips(this.wToolTip.getSelection());
        props.setResolveVariablesInToolTips(this.wResolveVarsInTips.getSelection());
        props.setSortFieldByName(this.wSortFieldByName.getSelection());
        props.setUseGlobalFileBookmarks(this.wbUseGlobalFileBookmarks.getSelection());
        props.setMaxExecutionLoggingTextSize(Const.toInt((String)this.wMaxExecutionLoggingTextSize.getText(), (int)2000000));
        try {
            HopConfig.getInstance().saveToFile();
        }
        catch (Exception e) {
            new ErrorDialog(HopGui.getInstance().getShell(), "Error", "Error saving configuration to file", e);
        }
    }
}

