/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.queryablestate.messages;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.ConfigConstants;
import org.apache.flink.queryablestate.network.messages.MessageBody;
import org.apache.flink.queryablestate.network.messages.MessageDeserializer;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBuf;
import org.apache.flink.util.Preconditions;

@Internal
public class KvStateRequest
extends MessageBody {
    private final JobID jobId;
    private final String stateName;
    private final int keyHashCode;
    private final byte[] serializedKeyAndNamespace;

    public KvStateRequest(JobID jobId, String stateName, int keyHashCode, byte[] serializedKeyAndNamespace) {
        this.jobId = (JobID)Preconditions.checkNotNull((Object)jobId);
        this.stateName = (String)Preconditions.checkNotNull((Object)stateName);
        this.keyHashCode = keyHashCode;
        this.serializedKeyAndNamespace = (byte[])Preconditions.checkNotNull((Object)serializedKeyAndNamespace);
    }

    public JobID getJobId() {
        return this.jobId;
    }

    public String getStateName() {
        return this.stateName;
    }

    public int getKeyHashCode() {
        return this.keyHashCode;
    }

    public byte[] getSerializedKeyAndNamespace() {
        return this.serializedKeyAndNamespace;
    }

    @Override
    public byte[] serialize() {
        byte[] serializedStateName = this.stateName.getBytes(ConfigConstants.DEFAULT_CHARSET);
        int size = 16 + serializedStateName.length + 4 + 4 + this.serializedKeyAndNamespace.length + 4;
        return ByteBuffer.allocate(size).putLong(this.jobId.getLowerPart()).putLong(this.jobId.getUpperPart()).putInt(serializedStateName.length).put(serializedStateName).putInt(this.keyHashCode).putInt(this.serializedKeyAndNamespace.length).put(this.serializedKeyAndNamespace).array();
    }

    public String toString() {
        return "KvStateRequest{jobId=" + this.jobId + ", stateName='" + this.stateName + '\'' + ", keyHashCode=" + this.keyHashCode + ", serializedKeyAndNamespace=" + Arrays.toString(this.serializedKeyAndNamespace) + '}';
    }

    public static class KvStateRequestDeserializer
    implements MessageDeserializer<KvStateRequest> {
        @Override
        public KvStateRequest deserializeMessage(ByteBuf buf) {
            JobID jobId = new JobID(buf.readLong(), buf.readLong());
            int statenameLength = buf.readInt();
            Preconditions.checkArgument((statenameLength >= 0 ? 1 : 0) != 0, (Object)"Negative length for state name. This indicates a serialization error.");
            String stateName = "";
            if (statenameLength > 0) {
                byte[] name = new byte[statenameLength];
                buf.readBytes(name);
                stateName = new String(name, ConfigConstants.DEFAULT_CHARSET);
            }
            int keyHashCode = buf.readInt();
            int knamespaceLength = buf.readInt();
            Preconditions.checkArgument((knamespaceLength >= 0 ? 1 : 0) != 0, (Object)"Negative length for key and namespace. This indicates a serialization error.");
            byte[] serializedKeyAndNamespace = new byte[knamespaceLength];
            if (knamespaceLength > 0) {
                buf.readBytes(serializedKeyAndNamespace);
            }
            return new KvStateRequest(jobId, stateName, keyHashCode, serializedKeyAndNamespace);
        }
    }
}

