/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.logicaltypes;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.BiMap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableBiMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class EnumerationType
implements Schema.LogicalType<Value, Integer> {
    public static final @UnknownKeyFor @NonNull @Initialized String IDENTIFIER = "Enum";
    final @UnknownKeyFor @NonNull @Initialized BiMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Integer> enumValues;
    final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> values;

    private EnumerationType(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Integer> enumValues) {
        this.enumValues = ImmutableBiMap.copyOf(enumValues);
        this.values = enumValues.entrySet().stream().sorted(Comparator.comparingInt(e -> (Integer)e.getValue())).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public static @UnknownKeyFor @NonNull @Initialized EnumerationType create(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Integer> enumValues) {
        return new EnumerationType(enumValues);
    }

    public static @UnknownKeyFor @NonNull @Initialized EnumerationType create(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> enumValues) {
        return new EnumerationType(IntStream.range(0, enumValues.size()).boxed().collect(Collectors.toMap(i -> (String)enumValues.get((int)i), i -> i)));
    }

    public static @UnknownKeyFor @NonNull @Initialized EnumerationType create(String ... enumValues) {
        return EnumerationType.create(Arrays.asList(enumValues));
    }

    public @UnknownKeyFor @NonNull @Initialized Value valueOf(@UnknownKeyFor @NonNull @Initialized String stringValue) {
        return new Value(Preconditions.checkArgumentNotNull((Integer)this.enumValues.get((Object)stringValue), "Unknown enumeration value {}", (Object)stringValue));
    }

    public @UnknownKeyFor @NonNull @Initialized Value valueOf(@UnknownKeyFor @NonNull @Initialized int value) {
        return new Value(value);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getIdentifier() {
        return IDENTIFIER;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Schema.FieldType getArgumentType() {
        return Schema.FieldType.map(Schema.FieldType.STRING, Schema.FieldType.INT32);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Integer> getArgument() {
        return this.enumValues;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Schema.FieldType getBaseType() {
        return Schema.FieldType.INT32;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Integer toBaseType(@UnknownKeyFor @NonNull @Initialized Value input) {
        return input.getValue();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Value toInputType(@UnknownKeyFor @NonNull @Initialized Integer base) {
        return this.valueOf(base);
    }

    public @UnknownKeyFor @NonNull @Initialized BiMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Integer> getValuesMap() {
        return this.enumValues;
    }

    public @Nullable @UnknownKeyFor @Initialized String getEnumName(@UnknownKeyFor @NonNull @Initialized int number) {
        return (String)this.enumValues.inverse().get((Object)number);
    }

    public @Nullable @UnknownKeyFor @Initialized Integer getEnumValue(@UnknownKeyFor @NonNull @Initialized String enumName) {
        return (Integer)this.enumValues.get((Object)enumName);
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> getValues() {
        return this.values;
    }

    public @UnknownKeyFor @NonNull @Initialized String toString(@UnknownKeyFor @NonNull @Initialized Value value) {
        return Preconditions.checkArgumentNotNull((String)this.enumValues.inverse().get((Object)value.getValue()), "Unknown enumeration value {}", value.getValue());
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return "Enumeration: " + this.enumValues;
    }

    public static class Value
    implements Serializable {
        private final @UnknownKeyFor @NonNull @Initialized int value;

        public Value(@UnknownKeyFor @NonNull @Initialized int value) {
            this.value = value;
        }

        public @UnknownKeyFor @NonNull @Initialized int getValue() {
            return this.value;
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Value enumValue = (Value)o;
            return this.value == enumValue.value;
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return Objects.hash(this.value);
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return "enum value: " + this.value;
        }
    }
}

