/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.logging;

import org.apache.hop.core.logging.HopLogLayout;
import org.apache.hop.core.logging.HopLogStore;
import org.apache.hop.core.logging.HopLoggingEvent;
import org.apache.hop.core.logging.IHopLoggingEventListener;
import org.apache.hop.core.logging.LogLevel;
import org.apache.hop.core.util.EnvUtil;

public class ConsoleLoggingEventListener
implements IHopLoggingEventListener {
    private static final String ANSI_RESET = "\u001b[0m";
    private static final String ANSI_RED = "\u001b[31m";
    private HopLogLayout layout = new HopLogLayout(true);
    private boolean useColors;

    public ConsoleLoggingEventListener() {
        String colorConfig = EnvUtil.getSystemProperty("HOP_CONSOLE_COLORS");
        if (colorConfig == null) {
            colorConfig = System.getenv("HOP_CONSOLE_COLORS");
        }
        if (colorConfig == null) {
            colorConfig = "auto";
        }
        this.useColors = "true".equals(colorConfig = colorConfig.toLowerCase()) ? true : ("false".equals(colorConfig) ? false : System.console() != null);
    }

    @Override
    public void eventAdded(HopLoggingEvent event) {
        Object logText = this.layout.format(event);
        if (event.getLevel() == LogLevel.ERROR) {
            if (this.useColors) {
                logText = ANSI_RED + (String)logText + ANSI_RESET;
            }
            HopLogStore.OriginalSystemErr.println((String)logText);
            HopLogStore.OriginalSystemErr.flush();
        } else {
            HopLogStore.OriginalSystemOut.println((String)logText);
            HopLogStore.OriginalSystemOut.flush();
        }
    }
}

