/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.translation;

import java.util.ArrayDeque;
import java.util.Iterator;
import javax.annotation.CheckForNull;
import org.apache.beam.runners.spark.translation.AbstractInOutIterator;
import org.apache.beam.runners.spark.translation.SparkInputDataProcessor;
import org.apache.beam.runners.spark.translation.SparkProcessContext;
import org.apache.beam.sdk.transforms.reflect.DoFnInvokers;
import org.apache.beam.sdk.util.WindowedValueMultiReceiver;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.WindowedValue;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import scala.Tuple2;

class UnboundedSparkInputDataProcessor<@UnknownKeyFor FnInputT, @UnknownKeyFor FnOutputT>
implements SparkInputDataProcessor<FnInputT, FnOutputT, Tuple2<TupleTag<?>, WindowedValue<?>>> {
    private final @UnknownKeyFor @NonNull @Initialized UnboundedDoFnOutputManager outputManager = new UnboundedDoFnOutputManager();

    UnboundedSparkInputDataProcessor() {
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized WindowedValueMultiReceiver getOutputManager() {
        return this.outputManager;
    }

    @Override
    public <K> /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Iterator<@UnknownKeyFor @NonNull @Initialized Tuple2<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>>> createOutputIterator(@UnknownKeyFor @NonNull @Initialized Iterator<@UnknownKeyFor @NonNull @Initialized WindowedValue<FnInputT>> input, @UnknownKeyFor @NonNull @Initialized SparkProcessContext<K, FnInputT, FnOutputT> ctx) {
        return new UnboundedInOutIterator<K>(input, ctx);
    }

    private class UnboundedInOutIterator<@UnknownKeyFor K>
    extends AbstractInOutIterator<K, FnInputT, FnOutputT> {
        private final @UnknownKeyFor @NonNull @Initialized Iterator<@UnknownKeyFor @NonNull @Initialized WindowedValue<FnInputT>> inputIterator;
        private volatile /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Iterator<@UnknownKeyFor @NonNull @Initialized Tuple2<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>>> outputIterator;
        private @UnknownKeyFor @NonNull @Initialized boolean isBundleStarted;
        private @UnknownKeyFor @NonNull @Initialized boolean isBundleFinished;

        UnboundedInOutIterator(@UnknownKeyFor @NonNull @Initialized Iterator<WindowedValue<FnInputT>> iterator, SparkProcessContext<K, FnInputT, FnOutputT> ctx) {
            super(ctx);
            this.inputIterator = iterator;
            this.outputIterator = UnboundedSparkInputDataProcessor.this.outputManager.iterator();
        }

        @CheckForNull
        protected /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @Nullable @Initialized Tuple2<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> computeNext() {
            try {
                if (!this.isBundleStarted) {
                    this.isBundleStarted = true;
                    this.ctx.getDoFnRunner().startBundle();
                }
                while (true) {
                    if (this.outputIterator.hasNext()) {
                        return this.outputIterator.next();
                    }
                    UnboundedSparkInputDataProcessor.this.outputManager.clear();
                    if (this.inputIterator.hasNext()) {
                        this.ctx.getDoFnRunner().processElement(this.inputIterator.next());
                        this.outputIterator = UnboundedSparkInputDataProcessor.this.outputManager.iterator();
                        continue;
                    }
                    if (this.ctx.getTimerDataIterator().hasNext()) {
                        this.fireTimer(this.ctx.getTimerDataIterator().next());
                        this.outputIterator = UnboundedSparkInputDataProcessor.this.outputManager.iterator();
                        continue;
                    }
                    if (this.isBundleFinished) break;
                    this.isBundleFinished = true;
                    this.ctx.getDoFnRunner().finishBundle();
                    this.outputIterator = UnboundedSparkInputDataProcessor.this.outputManager.iterator();
                }
                DoFnInvokers.invokerFor(this.ctx.getDoFn()).invokeTeardown();
                return (Tuple2)this.endOfData();
            }
            catch (RuntimeException re) {
                DoFnInvokers.invokerFor(this.ctx.getDoFn()).invokeTeardown();
                throw re;
            }
        }
    }

    private static class UnboundedDoFnOutputManager
    implements WindowedValueMultiReceiver,
    Iterable<Tuple2<TupleTag<?>, WindowedValue<?>>> {
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized ArrayDeque<@UnknownKeyFor @NonNull @Initialized Tuple2<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>>> outputs = new ArrayDeque();

        private UnboundedDoFnOutputManager() {
        }

        public void clear() {
            this.outputs.clear();
        }

        @Override
        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Iterator<@UnknownKeyFor @NonNull @Initialized Tuple2<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>>> iterator() {
            return this.outputs.iterator();
        }

        public synchronized <T> void output(@UnknownKeyFor @NonNull @Initialized TupleTag<T> tag, @UnknownKeyFor @NonNull @Initialized WindowedValue<T> output) {
            this.outputs.addLast(new Tuple2(tag, output));
        }
    }
}

