/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.translation.streaming;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.beam.runners.spark.coders.CoderHelpers;
import org.apache.beam.runners.spark.translation.Dataset;
import org.apache.beam.runners.spark.translation.TranslationUtils;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.values.WindowedValue;
import org.apache.spark.api.java.function.VoidFunction;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.streaming.api.java.JavaDStream;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnboundedDataset<@UnknownKeyFor T>
implements Dataset {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(UnboundedDataset.class);
    private @UnknownKeyFor @NonNull @Initialized JavaDStream<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>> dStream;
    private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Integer> streamSources = new ArrayList<Integer>();

    public UnboundedDataset(@UnknownKeyFor @NonNull @Initialized JavaDStream<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>> dStream, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Integer> streamSources) {
        this.dStream = dStream;
        this.streamSources.addAll(streamSources);
    }

    public @UnknownKeyFor @NonNull @Initialized JavaDStream<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>> getDStream() {
        return this.dStream;
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Integer> getStreamSources() {
        return this.streamSources;
    }

    @Override
    public void cache(@UnknownKeyFor @NonNull @Initialized String storageLevel, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> coder) {
        if (!StorageLevel.fromString((String)storageLevel).equals((Object)StorageLevel.MEMORY_ONLY_SER())) {
            LOG.warn("Provided StorageLevel: {} is ignored for streams, using the default level: {}", (Object)storageLevel, (Object)StorageLevel.MEMORY_ONLY_SER());
        }
        Coder<?> wc = coder;
        this.dStream = this.dStream.map(CoderHelpers.toByteFunction(wc)).cache().map(CoderHelpers.fromByteFunction(wc));
    }

    @Override
    public void action() {
        this.dStream.foreachRDD((VoidFunction & Serializable)rdd -> rdd.foreach(TranslationUtils.emptyVoidFunction()));
    }

    @Override
    public void setName(@UnknownKeyFor @NonNull @Initialized String name) {
    }
}

