/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.observation.interceptors;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.client5.http.async.AsyncExecCallback;
import org.apache.hc.client5.http.async.AsyncExecChain;
import org.apache.hc.client5.http.async.AsyncExecChainHandler;
import org.apache.hc.client5.http.observation.MetricConfig;
import org.apache.hc.client5.http.observation.ObservingOptions;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.nio.AsyncDataConsumer;
import org.apache.hc.core5.http.nio.AsyncEntityProducer;
import org.apache.hc.core5.util.Args;

public final class AsyncTimerExec
implements AsyncExecChainHandler {
    private final MeterRegistry registry;
    private final ObservingOptions opts;
    private final MetricConfig mc;
    private final AtomicInteger inflight = new AtomicInteger();

    public AsyncTimerExec(MeterRegistry reg, ObservingOptions opts, MetricConfig mc) {
        this.registry = (MeterRegistry)Args.notNull((Object)reg, (String)"registry");
        this.opts = (ObservingOptions)Args.notNull((Object)opts, (String)"options");
        MetricConfig metricConfig = this.mc = mc != null ? mc : MetricConfig.builder().build();
        if (this.registry.find(this.mc.prefix + ".inflight").tags(new String[]{"kind", "async"}).tags(this.mc.commonTags).gauge() == null) {
            Gauge.builder((String)(this.mc.prefix + ".inflight"), (Object)this.inflight, AtomicInteger::doubleValue).tag("kind", "async").tags(this.mc.commonTags).register(this.registry);
        }
    }

    public void execute(final HttpRequest request, AsyncEntityProducer entityProducer, final AsyncExecChain.Scope scope, AsyncExecChain chain, final AsyncExecCallback callback) throws HttpException, IOException {
        if (!this.opts.spanSampling.test(request.getRequestUri())) {
            chain.proceed(request, entityProducer, scope, callback);
            return;
        }
        this.inflight.incrementAndGet();
        final long start = System.nanoTime();
        final AtomicReference respRef = new AtomicReference();
        AsyncExecCallback wrapped = new AsyncExecCallback(){

            public AsyncDataConsumer handleResponse(HttpResponse response, EntityDetails entityDetails) throws HttpException, IOException {
                respRef.set(response);
                return callback.handleResponse(response, entityDetails);
            }

            public void handleInformationResponse(HttpResponse response) throws HttpException, IOException {
                callback.handleInformationResponse(response);
            }

            public void completed() {
                this.record();
                callback.completed();
            }

            public void failed(Exception cause) {
                this.record();
                callback.failed(cause);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void record() {
                try {
                    long dur = System.nanoTime() - start;
                    HttpResponse r = (HttpResponse)respRef.get();
                    int status = r != null ? r.getCode() : 599;
                    String protocol = scope.route.getTargetHost().getSchemeName();
                    String target = scope.route.getTargetHost().getHostName();
                    List tags = AsyncTimerExec.this.buildTags(request.getMethod(), status, protocol, target, request.getRequestUri());
                    Timer.Builder tb = Timer.builder((String)(((AsyncTimerExec)AsyncTimerExec.this).mc.prefix + ".request")).tags((Iterable)tags).tags(((AsyncTimerExec)AsyncTimerExec.this).mc.commonTags);
                    if (((AsyncTimerExec)AsyncTimerExec.this).mc.slo != null) {
                        tb = tb.serviceLevelObjectives(new Duration[]{((AsyncTimerExec)AsyncTimerExec.this).mc.slo});
                    }
                    if (((AsyncTimerExec)AsyncTimerExec.this).mc.percentiles != null && ((AsyncTimerExec)AsyncTimerExec.this).mc.percentiles.length > 0) {
                        tb = tb.publishPercentiles(((AsyncTimerExec)AsyncTimerExec.this).mc.percentiles);
                    }
                    tb.register(AsyncTimerExec.this.registry).record(dur, TimeUnit.NANOSECONDS);
                    Counter.builder((String)(((AsyncTimerExec)AsyncTimerExec.this).mc.prefix + ".response")).tags((Iterable)tags).tags(((AsyncTimerExec)AsyncTimerExec.this).mc.commonTags).register(AsyncTimerExec.this.registry).increment();
                }
                finally {
                    AsyncTimerExec.this.inflight.decrementAndGet();
                }
            }
        };
        chain.proceed(request, entityProducer, scope, wrapped);
    }

    private List<Tag> buildTags(String method, int status, String protocol, String target, String uri) {
        ArrayList<Tag> tags = new ArrayList<Tag>(6);
        tags.add(Tag.of((String)"method", (String)method));
        tags.add(Tag.of((String)"status", (String)Integer.toString(status)));
        if (this.opts.tagLevel == ObservingOptions.TagLevel.EXTENDED) {
            tags.add(Tag.of((String)"protocol", (String)protocol));
            tags.add(Tag.of((String)"target", (String)target));
        }
        return this.opts.tagCustomizer.apply(tags, method, status, protocol, target, uri);
    }
}

