/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.iceberg.hive;

import org.apache.iceberg.relocated.com.google.common.base.Preconditions;

public class NoLock implements HiveLock {
  public NoLock() {
    Preconditions.checkArgument(
        HiveVersion.min(HiveVersion.HIVE_2),
        "Minimally Hive 2 HMS client is needed to use HIVE-26882 based locking");
  }

  @Override
  public void lock() throws LockException {
    // no-op
  }

  @Override
  public void ensureActive() throws LockException {
    // no-op
  }

  @Override
  public void unlock() {
    // no-op
  }
}
