/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.configuration;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import javax.cache.CacheException;
import javax.cache.configuration.Factory;
import org.apache.ignite.internal.util.typedef.F;

public class IgniteReflectionFactory<T>
implements Factory<T> {
    private static final long serialVersionUID = 0L;
    private volatile boolean singleton;
    private volatile Class<? extends T> cls;
    private volatile Map<String, Serializable> props;
    private transient T instance;

    public IgniteReflectionFactory() {
    }

    public IgniteReflectionFactory(Class<? extends T> cls, boolean singleton) {
        this.cls = cls;
        this.singleton = singleton;
    }

    public IgniteReflectionFactory(Class<? extends T> cls) {
        this(cls, false);
    }

    public boolean isSingleton() {
        return this.singleton;
    }

    public void setSingleton(boolean singleton) {
        this.singleton = singleton;
    }

    public Class<? extends T> getComponentClass() {
        return this.cls;
    }

    public void setComponentClass(Class<T> cls) {
        this.cls = cls;
    }

    public Map<String, Serializable> getProperties() {
        return this.props;
    }

    public void setProperties(Map<String, Serializable> props) {
        this.props = props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T create() {
        IgniteReflectionFactory igniteReflectionFactory = this;
        synchronized (igniteReflectionFactory) {
            if (this.singleton) {
                if (this.instance == null) {
                    this.instance = this.createInstance();
                }
                return this.instance;
            }
            return this.createInstance();
        }
    }

    private T createInstance() {
        if (this.cls == null) {
            throw new IllegalStateException("Failed to create object (object type is not set).");
        }
        try {
            T obj = this.cls.newInstance();
            this.injectProperties(obj);
            return obj;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new CacheException("Failed to instantiate factory object: " + this.cls.getName(), (Throwable)e);
        }
    }

    private void injectProperties(T obj) {
        if (!F.isEmpty(this.props)) {
            for (Map.Entry<String, Serializable> entry : this.props.entrySet()) {
                String fieldName = entry.getKey().trim();
                if (fieldName.isEmpty()) continue;
                Serializable val = entry.getValue();
                this.setWithMethod(obj, fieldName, val);
            }
        }
    }

    private boolean setWithMethod(T obj, String fieldName, Serializable val) {
        StringBuilder sb = new StringBuilder("set");
        sb.append(fieldName);
        sb.setCharAt(3, Character.toUpperCase(sb.charAt(3)));
        Class<Object> paramCls = val.getClass();
        String mtdName = sb.toString();
        boolean res = this.setWithMethod(obj, mtdName, val, paramCls);
        if (!res) {
            if (Byte.class == paramCls) {
                paramCls = Byte.TYPE;
            } else if (Short.class == paramCls) {
                paramCls = Short.TYPE;
            } else if (Integer.class == paramCls) {
                paramCls = Integer.TYPE;
            } else if (Long.class == paramCls) {
                paramCls = Long.TYPE;
            } else if (Float.class == paramCls) {
                paramCls = Float.TYPE;
            } else if (Double.class == paramCls) {
                paramCls = Double.TYPE;
            } else if (Character.class == paramCls) {
                paramCls = Character.TYPE;
            } else if (Boolean.class == paramCls) {
                paramCls = Boolean.TYPE;
            } else {
                return false;
            }
            res = this.setWithMethod(obj, mtdName, val, paramCls);
        }
        return res;
    }

    private boolean setWithMethod(T obj, String mtdName, Serializable val, Class paramCls) {
        while (paramCls != null) {
            try {
                Method mtd = obj.getClass().getMethod(mtdName, paramCls);
                mtd.invoke(obj, val);
                return true;
            }
            catch (InvocationTargetException e) {
                throw new CacheException(e.getCause());
            }
            catch (IllegalAccessException | NoSuchMethodException ignore) {
                paramCls = paramCls.getSuperclass();
            }
        }
        for (Class<?> itf : val.getClass().getInterfaces()) {
            try {
                Method mtd = obj.getClass().getMethod(mtdName, itf);
                mtd.invoke(obj, val);
                return true;
            }
            catch (InvocationTargetException e) {
                throw new CacheException(e.getCause());
            }
            catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
            }
        }
        return false;
    }
}

