/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.netty;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.annotation.TypeHint;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.MutableConvertibleValues;
import io.micronaut.core.convert.value.MutableConvertibleValuesMap;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpHeaders;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.cookie.Cookie;
import io.micronaut.http.netty.NettyHttpHeaders;
import io.micronaut.http.netty.NettyHttpResponseBuilder;
import io.micronaut.http.netty.cookies.NettyCookie;
import io.micronaut.http.netty.stream.DefaultStreamedHttpResponse;
import io.micronaut.http.netty.stream.StreamedHttpResponse;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.reactivestreams.Publisher;

@Internal
@TypeHint(value={NettyMutableHttpResponse.class})
public class NettyMutableHttpResponse<B>
implements MutableHttpResponse<B>,
NettyHttpResponseBuilder {
    private static final ServerCookieEncoder DEFAULT_SERVER_COOKIE_ENCODER = ServerCookieEncoder.LAX;
    private final HttpVersion httpVersion;
    private HttpResponseStatus httpResponseStatus;
    private final NettyHttpHeaders headers;
    private Object body;
    private Optional<Object> optionalBody;
    private final HttpHeaders nettyHeaders;
    private final HttpHeaders trailingNettyHeaders;
    private final DecoderResult decoderResult;
    private final ConversionService conversionService;
    private MutableConvertibleValues<Object> attributes;
    private ServerCookieEncoder serverCookieEncoder = DEFAULT_SERVER_COOKIE_ENCODER;
    private final BodyConvertor bodyConvertor = this.newBodyConvertor();

    public NettyMutableHttpResponse(FullHttpResponse nettyResponse, ConversionService conversionService) {
        this(nettyResponse.protocolVersion(), nettyResponse.status(), nettyResponse.headers(), nettyResponse.trailingHeaders(), nettyResponse.content(), nettyResponse.decoderResult(), conversionService);
    }

    public NettyMutableHttpResponse(ConversionService conversionService) {
        this(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, null, conversionService);
    }

    public NettyMutableHttpResponse(HttpVersion httpVersion, HttpResponseStatus httpResponseStatus, ConversionService conversionService) {
        this(httpVersion, httpResponseStatus, null, conversionService);
    }

    public NettyMutableHttpResponse(HttpVersion httpVersion, HttpResponseStatus httpResponseStatus, Object body, ConversionService conversionService) {
        this(httpVersion, httpResponseStatus, (HttpHeaders)new DefaultHttpHeaders(), body, conversionService);
    }

    public NettyMutableHttpResponse(HttpVersion httpVersion, HttpResponseStatus httpResponseStatus, HttpHeaders nettyHeaders, Object body, ConversionService conversionService) {
        this(httpVersion, httpResponseStatus, nettyHeaders, (HttpHeaders)EmptyHttpHeaders.INSTANCE, body, null, conversionService);
    }

    private NettyMutableHttpResponse(HttpVersion httpVersion, HttpResponseStatus httpResponseStatus, HttpHeaders nettyHeaders, HttpHeaders trailingNettyHeaders, Object body, DecoderResult decoderResult, ConversionService conversionService) {
        this.httpVersion = httpVersion;
        this.httpResponseStatus = httpResponseStatus;
        this.nettyHeaders = nettyHeaders;
        this.trailingNettyHeaders = trailingNettyHeaders;
        this.decoderResult = decoderResult;
        this.conversionService = conversionService;
        this.headers = new NettyHttpHeaders(nettyHeaders, conversionService);
        this.setBody(body);
    }

    public HttpVersion getNettyHttpVersion() {
        return this.httpVersion;
    }

    public HttpResponseStatus getNettyHttpStatus() {
        return this.httpResponseStatus;
    }

    public HttpHeaders getNettyHeaders() {
        return this.nettyHeaders;
    }

    public String toString() {
        HttpStatus status = this.getStatus();
        return status.getCode() + " " + status.getReason();
    }

    public MutableHttpHeaders getHeaders() {
        return this.headers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableConvertibleValues<Object> getAttributes() {
        MutableConvertibleValuesMap attributes = this.attributes;
        if (attributes == null) {
            NettyMutableHttpResponse nettyMutableHttpResponse = this;
            synchronized (nettyMutableHttpResponse) {
                attributes = this.attributes;
                if (attributes == null) {
                    this.attributes = attributes = new MutableConvertibleValuesMap(new ConcurrentHashMap(4));
                }
            }
        }
        return attributes;
    }

    public HttpStatus getStatus() {
        return HttpStatus.valueOf((int)this.httpResponseStatus.code());
    }

    public int code() {
        return this.httpResponseStatus.code();
    }

    public String reason() {
        return this.httpResponseStatus.reasonPhrase();
    }

    public MutableHttpResponse<B> cookie(Cookie cookie) {
        if (!(cookie instanceof NettyCookie)) {
            throw new IllegalArgumentException("Argument is not a Netty compatible Cookie");
        }
        NettyCookie nettyCookie = (NettyCookie)cookie;
        String value = this.serverCookieEncoder.encode(nettyCookie.getNettyCookie());
        this.headers.add((CharSequence)HttpHeaderNames.SET_COOKIE, value);
        return this;
    }

    public MutableHttpResponse<B> cookies(Set<Cookie> cookies) {
        if (cookies == null || cookies.isEmpty()) {
            return this;
        }
        for (Cookie cookie : cookies) {
            this.cookie(cookie);
        }
        return this;
    }

    public Optional<B> getBody() {
        return this.optionalBody;
    }

    public <T1> Optional<T1> getBody(Class<T1> type) {
        return this.getBody(Argument.of(type));
    }

    public <T> Optional<T> getBody(Argument<T> type) {
        return this.bodyConvertor.convert(type, this.body);
    }

    public MutableHttpResponse<B> status(HttpStatus status, CharSequence message) {
        message = message == null ? status.getReason() : message;
        this.httpResponseStatus = new HttpResponseStatus(status.getCode(), message.toString());
        return this;
    }

    public <T> MutableHttpResponse<T> body(@Nullable T body) {
        if (this.body != body) {
            if (this.body instanceof ByteBuf) {
                ((ByteBuf)this.body).release();
            }
            this.setBody(body);
            this.bodyConvertor.cleanup();
        }
        return this;
    }

    public ServerCookieEncoder getServerCookieEncoder() {
        return this.serverCookieEncoder;
    }

    public void setServerCookieEncoder(ServerCookieEncoder serverCookieEncoder) {
        this.serverCookieEncoder = serverCookieEncoder;
    }

    @Override
    @NonNull
    public FullHttpResponse toFullHttpResponse() {
        ByteBuf content;
        if (this.body == null) {
            content = Unpooled.EMPTY_BUFFER;
        } else if (this.body instanceof ByteBuf) {
            content = (ByteBuf)this.body;
        } else {
            throw new IllegalStateException("Body needs to be converted to ByteBuf from " + this.body.getClass());
        }
        DefaultFullHttpResponse defaultFullHttpResponse = new DefaultFullHttpResponse(this.httpVersion, this.httpResponseStatus, content, this.nettyHeaders, this.trailingNettyHeaders);
        if (this.decoderResult != null) {
            defaultFullHttpResponse.setDecoderResult(this.decoderResult);
        }
        return defaultFullHttpResponse;
    }

    @Override
    @NonNull
    public StreamedHttpResponse toStreamHttpResponse() {
        ByteBuf content;
        if (this.body == null) {
            content = Unpooled.EMPTY_BUFFER;
        } else if (this.body instanceof ByteBuf) {
            content = (ByteBuf)this.body;
        } else {
            throw new IllegalStateException("Body needs to be converted to ByteBuf from " + this.body.getClass());
        }
        DefaultStreamedHttpResponse streamedHttpResponse = new DefaultStreamedHttpResponse(HttpVersion.HTTP_1_1, this.httpResponseStatus, true, (Publisher<HttpContent>)Publishers.just((Object)new DefaultLastHttpContent(content)));
        streamedHttpResponse.headers().setAll(this.nettyHeaders);
        return streamedHttpResponse;
    }

    @Override
    @NonNull
    public HttpResponse toHttpResponse() {
        return this.toFullHttpResponse();
    }

    @Override
    public boolean isStream() {
        return false;
    }

    private void setBody(Object body) {
        this.body = body;
        this.optionalBody = Optional.ofNullable(body);
        Optional contentType = this.getContentType();
        if (!contentType.isPresent() && body != null) {
            MediaType.fromType(body.getClass()).ifPresent(arg_0 -> ((NettyMutableHttpResponse)this).contentType(arg_0));
        }
    }

    private BodyConvertor newBodyConvertor() {
        return new BodyConvertor(){

            public Optional convert(Argument valueType, Object value) {
                if (value == null) {
                    return Optional.empty();
                }
                if (Argument.OBJECT_ARGUMENT.equalsType(valueType)) {
                    return Optional.of(value);
                }
                return this.convertFromNext(NettyMutableHttpResponse.this.conversionService, valueType, value);
            }
        };
    }

    private static abstract class BodyConvertor<T> {
        private BodyConvertor<T> nextConvertor;

        private BodyConvertor() {
        }

        public abstract Optional<T> convert(Argument<T> var1, T var2);

        protected synchronized Optional<T> convertFromNext(final ConversionService conversionService, final Argument<T> conversionValueType, T value) {
            if (this.nextConvertor == null) {
                ArgumentConversionContext context = ConversionContext.of(conversionValueType);
                final Optional conversion = value instanceof ByteBuffer ? conversionService.convert(((ByteBuffer)value).asNativeBuffer(), context) : conversionService.convert(value, context);
                this.nextConvertor = new BodyConvertor<T>(){

                    @Override
                    public Optional<T> convert(Argument<T> valueType, T value) {
                        if (conversionValueType.equalsType(valueType)) {
                            return conversion;
                        }
                        return this.convertFromNext(conversionService, valueType, value);
                    }
                };
                return conversion;
            }
            return this.nextConvertor.convert(conversionValueType, value);
        }

        public void cleanup() {
            this.nextConvertor = null;
        }
    }
}

