/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.dynamodb.model.DestinationStatus;
import software.amazon.awssdk.services.dynamodb.model.DynamoDbResponse;
import software.amazon.awssdk.services.dynamodb.model.EnableKinesisStreamingConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EnableKinesisStreamingDestinationResponse
extends DynamoDbResponse
implements ToCopyableBuilder<Builder, EnableKinesisStreamingDestinationResponse> {
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TableName").getter(EnableKinesisStreamingDestinationResponse.getter(EnableKinesisStreamingDestinationResponse::tableName)).setter(EnableKinesisStreamingDestinationResponse.setter(Builder::tableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()}).build();
    private static final SdkField<String> STREAM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreamArn").getter(EnableKinesisStreamingDestinationResponse.getter(EnableKinesisStreamingDestinationResponse::streamArn)).setter(EnableKinesisStreamingDestinationResponse.setter(Builder::streamArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamArn").build()}).build();
    private static final SdkField<String> DESTINATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationStatus").getter(EnableKinesisStreamingDestinationResponse.getter(EnableKinesisStreamingDestinationResponse::destinationStatusAsString)).setter(EnableKinesisStreamingDestinationResponse.setter(Builder::destinationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationStatus").build()}).build();
    private static final SdkField<EnableKinesisStreamingConfiguration> ENABLE_KINESIS_STREAMING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EnableKinesisStreamingConfiguration").getter(EnableKinesisStreamingDestinationResponse.getter(EnableKinesisStreamingDestinationResponse::enableKinesisStreamingConfiguration)).setter(EnableKinesisStreamingDestinationResponse.setter(Builder::enableKinesisStreamingConfiguration)).constructor(EnableKinesisStreamingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableKinesisStreamingConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_NAME_FIELD, STREAM_ARN_FIELD, DESTINATION_STATUS_FIELD, ENABLE_KINESIS_STREAMING_CONFIGURATION_FIELD));
    private final String tableName;
    private final String streamArn;
    private final String destinationStatus;
    private final EnableKinesisStreamingConfiguration enableKinesisStreamingConfiguration;

    private EnableKinesisStreamingDestinationResponse(BuilderImpl builder) {
        super(builder);
        this.tableName = builder.tableName;
        this.streamArn = builder.streamArn;
        this.destinationStatus = builder.destinationStatus;
        this.enableKinesisStreamingConfiguration = builder.enableKinesisStreamingConfiguration;
    }

    public final String tableName() {
        return this.tableName;
    }

    public final String streamArn() {
        return this.streamArn;
    }

    public final DestinationStatus destinationStatus() {
        return DestinationStatus.fromValue(this.destinationStatus);
    }

    public final String destinationStatusAsString() {
        return this.destinationStatus;
    }

    public final EnableKinesisStreamingConfiguration enableKinesisStreamingConfiguration() {
        return this.enableKinesisStreamingConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableKinesisStreamingConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableKinesisStreamingDestinationResponse)) {
            return false;
        }
        EnableKinesisStreamingDestinationResponse other = (EnableKinesisStreamingDestinationResponse)((Object)obj);
        return Objects.equals(this.tableName(), other.tableName()) && Objects.equals(this.streamArn(), other.streamArn()) && Objects.equals(this.destinationStatusAsString(), other.destinationStatusAsString()) && Objects.equals(this.enableKinesisStreamingConfiguration(), other.enableKinesisStreamingConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"EnableKinesisStreamingDestinationResponse").add("TableName", (Object)this.tableName()).add("StreamArn", (Object)this.streamArn()).add("DestinationStatus", (Object)this.destinationStatusAsString()).add("EnableKinesisStreamingConfiguration", (Object)this.enableKinesisStreamingConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TableName": {
                return Optional.ofNullable(clazz.cast(this.tableName()));
            }
            case "StreamArn": {
                return Optional.ofNullable(clazz.cast(this.streamArn()));
            }
            case "DestinationStatus": {
                return Optional.ofNullable(clazz.cast(this.destinationStatusAsString()));
            }
            case "EnableKinesisStreamingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.enableKinesisStreamingConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EnableKinesisStreamingDestinationResponse, T> g) {
        return obj -> g.apply((EnableKinesisStreamingDestinationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DynamoDbResponse.BuilderImpl
    implements Builder {
        private String tableName;
        private String streamArn;
        private String destinationStatus;
        private EnableKinesisStreamingConfiguration enableKinesisStreamingConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(EnableKinesisStreamingDestinationResponse model) {
            super(model);
            this.tableName(model.tableName);
            this.streamArn(model.streamArn);
            this.destinationStatus(model.destinationStatus);
            this.enableKinesisStreamingConfiguration(model.enableKinesisStreamingConfiguration);
        }

        public final String getTableName() {
            return this.tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final String getStreamArn() {
            return this.streamArn;
        }

        public final void setStreamArn(String streamArn) {
            this.streamArn = streamArn;
        }

        @Override
        public final Builder streamArn(String streamArn) {
            this.streamArn = streamArn;
            return this;
        }

        public final String getDestinationStatus() {
            return this.destinationStatus;
        }

        public final void setDestinationStatus(String destinationStatus) {
            this.destinationStatus = destinationStatus;
        }

        @Override
        public final Builder destinationStatus(String destinationStatus) {
            this.destinationStatus = destinationStatus;
            return this;
        }

        @Override
        public final Builder destinationStatus(DestinationStatus destinationStatus) {
            this.destinationStatus(destinationStatus == null ? null : destinationStatus.toString());
            return this;
        }

        public final EnableKinesisStreamingConfiguration.Builder getEnableKinesisStreamingConfiguration() {
            return this.enableKinesisStreamingConfiguration != null ? this.enableKinesisStreamingConfiguration.toBuilder() : null;
        }

        public final void setEnableKinesisStreamingConfiguration(EnableKinesisStreamingConfiguration.BuilderImpl enableKinesisStreamingConfiguration) {
            this.enableKinesisStreamingConfiguration = enableKinesisStreamingConfiguration != null ? enableKinesisStreamingConfiguration.build() : null;
        }

        @Override
        public final Builder enableKinesisStreamingConfiguration(EnableKinesisStreamingConfiguration enableKinesisStreamingConfiguration) {
            this.enableKinesisStreamingConfiguration = enableKinesisStreamingConfiguration;
            return this;
        }

        @Override
        public EnableKinesisStreamingDestinationResponse build() {
            return new EnableKinesisStreamingDestinationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DynamoDbResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, EnableKinesisStreamingDestinationResponse> {
        public Builder tableName(String var1);

        public Builder streamArn(String var1);

        public Builder destinationStatus(String var1);

        public Builder destinationStatus(DestinationStatus var1);

        public Builder enableKinesisStreamingConfiguration(EnableKinesisStreamingConfiguration var1);

        default public Builder enableKinesisStreamingConfiguration(Consumer<EnableKinesisStreamingConfiguration.Builder> enableKinesisStreamingConfiguration) {
            return this.enableKinesisStreamingConfiguration((EnableKinesisStreamingConfiguration)((EnableKinesisStreamingConfiguration.Builder)EnableKinesisStreamingConfiguration.builder().applyMutation(enableKinesisStreamingConfiguration)).build());
        }
    }
}

