/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.io.reader;

import java.util.Collection;
import java.util.concurrent.ExecutorService;
import org.apache.amoro.io.reader.ParallelTableScanIterable;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.io.CloseableIterable;

public class ParallelIcebergGenerics {
    private ParallelIcebergGenerics() {
    }

    public static ScanBuilder read(Table table, ExecutorService executorService) {
        return new ScanBuilder(table, executorService);
    }

    public static class ScanBuilder {
        private TableScan tableScan;
        private ExecutorService executorService;
        private boolean reuseContainers = false;

        public ScanBuilder(Table table, ExecutorService executorService) {
            this.tableScan = (TableScan)table.newScan().planWith(executorService);
            this.executorService = executorService;
        }

        public ScanBuilder reuseContainers() {
            this.reuseContainers = true;
            return this;
        }

        public ScanBuilder where(Expression rowFilter) {
            this.tableScan = (TableScan)this.tableScan.filter(rowFilter);
            return this;
        }

        public ScanBuilder caseInsensitive() {
            this.tableScan = (TableScan)this.tableScan.caseSensitive(false);
            return this;
        }

        public ScanBuilder select(String ... selectedColumns) {
            this.tableScan = (TableScan)this.tableScan.select(selectedColumns);
            return this;
        }

        public ScanBuilder select(Collection<String> columns) {
            this.tableScan = (TableScan)this.tableScan.select(columns);
            return this;
        }

        public ScanBuilder project(Schema schema) {
            this.tableScan = (TableScan)this.tableScan.project(schema);
            return this;
        }

        public ScanBuilder useSnapshot(long scanSnapshotId) {
            this.tableScan = this.tableScan.useSnapshot(scanSnapshotId);
            return this;
        }

        public ScanBuilder asOfTime(long scanTimestampMillis) {
            this.tableScan = this.tableScan.asOfTime(scanTimestampMillis);
            return this;
        }

        public ScanBuilder appendsBetween(long fromSnapshotId, long toSnapshotId) {
            this.tableScan = this.tableScan.appendsBetween(fromSnapshotId, toSnapshotId);
            return this;
        }

        public ScanBuilder appendsAfter(long fromSnapshotId) {
            this.tableScan = this.tableScan.appendsAfter(fromSnapshotId);
            return this;
        }

        public CloseableIterable<Record> build() {
            return new ParallelTableScanIterable(this.tableScan, this.reuseContainers, this.executorService);
        }
    }
}

