/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.utils;

import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileContent;

public class ContentFiles {
    private ContentFiles() {
        throw new UnsupportedOperationException();
    }

    public static boolean isDeleteFile(ContentFile<?> contentFile) {
        return !ContentFiles.isDataFile(contentFile);
    }

    public static boolean isDataFile(ContentFile<?> contentFile) {
        return contentFile.content() == FileContent.DATA;
    }

    public static DataFile asDataFile(ContentFile<?> contentFile) {
        Preconditions.checkArgument((boolean)ContentFiles.isDataFile(contentFile), (Object)"Not a data file");
        return (DataFile)contentFile;
    }

    public static DeleteFile asDeleteFile(ContentFile<?> contentFile) {
        Preconditions.checkArgument((boolean)ContentFiles.isDeleteFile(contentFile), (Object)"Not a delete file");
        return (DeleteFile)contentFile;
    }
}

