/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.failure;

import java.util.concurrent.Executor;
import org.apache.flink.api.common.JobInfo;
import org.apache.flink.core.failure.FailureEnricher;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.util.Preconditions;

public class DefaultFailureEnricherContext
implements FailureEnricher.Context {
    private final JobInfo jobInfo;
    private final MetricGroup metricGroup;
    private final Executor ioExecutor;
    private final ClassLoader userClassLoader;
    private final FailureEnricher.Context.FailureType failureType;

    private DefaultFailureEnricherContext(JobInfo jobInfo, MetricGroup metricGroup, FailureEnricher.Context.FailureType failureType, Executor ioExecutor, ClassLoader classLoader) {
        this.jobInfo = jobInfo;
        this.metricGroup = metricGroup;
        this.failureType = failureType;
        this.ioExecutor = (Executor)Preconditions.checkNotNull((Object)ioExecutor);
        this.userClassLoader = classLoader;
    }

    public MetricGroup getMetricGroup() {
        return this.metricGroup;
    }

    public FailureEnricher.Context.FailureType getFailureType() {
        return this.failureType;
    }

    public ClassLoader getUserClassLoader() {
        return this.userClassLoader;
    }

    public Executor getIOExecutor() {
        return this.ioExecutor;
    }

    public JobInfo getJobInfo() {
        return this.jobInfo;
    }

    public static FailureEnricher.Context forTaskFailure(JobInfo jobInfo, MetricGroup metricGroup, Executor ioExecutor, ClassLoader classLoader) {
        return new DefaultFailureEnricherContext(jobInfo, metricGroup, FailureEnricher.Context.FailureType.TASK, ioExecutor, classLoader);
    }

    public static FailureEnricher.Context forGlobalFailure(JobInfo jobInfo, MetricGroup metricGroup, Executor ioExecutor, ClassLoader classLoader) {
        return new DefaultFailureEnricherContext(jobInfo, metricGroup, FailureEnricher.Context.FailureType.GLOBAL, ioExecutor, classLoader);
    }

    public static FailureEnricher.Context forTaskManagerFailure(JobInfo jobInfo, MetricGroup metricGroup, Executor ioExecutor, ClassLoader classLoader) {
        return new DefaultFailureEnricherContext(jobInfo, metricGroup, FailureEnricher.Context.FailureType.TASK_MANAGER, ioExecutor, classLoader);
    }
}

