/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.parquet;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.apache.amoro.shade.guava32.com.google.common.collect.Sets;
import org.apache.iceberg.Schema;
import org.apache.iceberg.mapping.NameMapping;
import org.apache.iceberg.parquet.AdaptHiveTypeToMessageType;
import org.apache.iceberg.parquet.ApplyNameMapping;
import org.apache.iceberg.parquet.MessageTypeToType;
import org.apache.iceberg.parquet.ParquetTypeVisitor;
import org.apache.iceberg.parquet.PruneColumns;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Types;

public class AdaptHiveParquetSchemaUtil {
    private AdaptHiveParquetSchemaUtil() {
    }

    public static MessageType convert(Schema schema, String name) {
        return new AdaptHiveTypeToMessageType().convert(schema, name);
    }

    public static Schema convert(MessageType parquetSchema) {
        MessageType parquetSchemaWithIds = AdaptHiveParquetSchemaUtil.hasIds(parquetSchema) ? parquetSchema : AdaptHiveParquetSchemaUtil.addFallbackIds(parquetSchema);
        AtomicInteger nextId = new AtomicInteger(1000);
        return AdaptHiveParquetSchemaUtil.convertInternal(parquetSchemaWithIds, name -> nextId.getAndIncrement());
    }

    public static Schema convertAndPrune(MessageType parquetSchema) {
        return AdaptHiveParquetSchemaUtil.convertInternal(parquetSchema, name -> null);
    }

    private static Schema convertInternal(MessageType parquetSchema, Function<String[], Integer> nameToIdFunc) {
        MessageTypeToType converter = new MessageTypeToType(nameToIdFunc);
        return new Schema(((Type)ParquetTypeVisitor.visit((org.apache.parquet.schema.Type)parquetSchema, (ParquetTypeVisitor)converter)).asNestedType().fields(), converter.getAliases());
    }

    public static MessageType pruneColumns(MessageType fileSchema, Schema expectedSchema) {
        Set selectedIds = TypeUtil.getProjectedIds((Schema)expectedSchema);
        return (MessageType)ParquetTypeVisitor.visit((org.apache.parquet.schema.Type)fileSchema, (ParquetTypeVisitor)new PruneColumns(selectedIds));
    }

    public static MessageType pruneColumnsFallback(MessageType fileSchema, Schema expectedSchema) {
        HashSet selectedIds = Sets.newHashSet();
        for (Types.NestedField field : expectedSchema.columns()) {
            selectedIds.add(field.fieldId());
        }
        Types.MessageTypeBuilder builder = Types.buildMessage();
        int ordinal = 1;
        for (org.apache.parquet.schema.Type type : fileSchema.getFields()) {
            if (selectedIds.contains(ordinal)) {
                builder.addField(type.withId(ordinal));
            }
            ++ordinal;
        }
        return builder.named(fileSchema.getName());
    }

    public static boolean hasIds(MessageType fileSchema) {
        return (Boolean)ParquetTypeVisitor.visit((org.apache.parquet.schema.Type)fileSchema, (ParquetTypeVisitor)new HasIds());
    }

    public static MessageType addFallbackIds(MessageType fileSchema) {
        Types.MessageTypeBuilder builder = Types.buildMessage();
        int ordinal = 1;
        for (org.apache.parquet.schema.Type type : fileSchema.getFields()) {
            builder.addField(type.withId(ordinal));
            ++ordinal;
        }
        return builder.named(fileSchema.getName());
    }

    public static MessageType applyNameMapping(MessageType fileSchema, NameMapping nameMapping) {
        return (MessageType)ParquetTypeVisitor.visit((org.apache.parquet.schema.Type)fileSchema, (ParquetTypeVisitor)new ApplyNameMapping(nameMapping));
    }

    public static class HasIds
    extends ParquetTypeVisitor<Boolean> {
        public Boolean message(MessageType message, List<Boolean> fields) {
            return this.struct((GroupType)message, (List)fields);
        }

        public Boolean struct(GroupType struct, List<Boolean> hasIds) {
            for (Boolean hasId : hasIds) {
                if (!hasId.booleanValue()) continue;
                return true;
            }
            return struct.getId() != null;
        }

        public Boolean list(GroupType array, Boolean hasId) {
            return hasId != false || array.getId() != null;
        }

        public Boolean map(GroupType map, Boolean keyHasId, Boolean valueHasId) {
            return keyHasId != false || valueHasId != false || map.getId() != null;
        }

        public Boolean primitive(PrimitiveType primitive) {
            return primitive.getId() != null;
        }
    }
}

