/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.process;

import java.util.Map;
import java.util.Optional;
import org.apache.amoro.process.ProcessStage;
import org.apache.amoro.shade.guava32.com.google.common.collect.ImmutableMap;

public class OptimizingStages {
    public static final ProcessStage MINOR = new ProcessStage("minor", 13);
    public static final ProcessStage MAJOR = new ProcessStage("major", 14);
    public static final ProcessStage FULL = new ProcessStage("full", 15);
    public static final ProcessStage COMMITTING = new ProcessStage("committing", 18);
    public static final ProcessStage PLANNING = new ProcessStage("planning", 17);
    public static final ProcessStage EVALUATING = new ProcessStage("evaluating", 16);
    public static final ProcessStage PENDING = new ProcessStage("pending", 9);
    public static final ProcessStage SUSPENDING = new ProcessStage("suspending", 9);
    public static final ProcessStage IDLE = new ProcessStage("idle", 1);
    private static final Map<String, ProcessStage> STAGES = ImmutableMap.builder().put((Object)MINOR.getDesc(), (Object)MINOR).put((Object)MAJOR.getDesc(), (Object)MAJOR).put((Object)FULL.getDesc(), (Object)FULL).put((Object)COMMITTING.getDesc(), (Object)COMMITTING).put((Object)PLANNING.getDesc(), (Object)PLANNING).put((Object)EVALUATING.getDesc(), (Object)EVALUATING).put((Object)PENDING.getDesc(), (Object)PENDING).put((Object)SUSPENDING.getDesc(), (Object)SUSPENDING).put((Object)IDLE.getDesc(), (Object)IDLE).build();

    public static ProcessStage of(String desc) {
        return Optional.ofNullable(STAGES.get(desc)).orElseThrow(() -> new IllegalArgumentException("No optimizing stage with desc: " + desc));
    }
}

