/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.spark.writer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.amoro.api.BlockableOperation;
import org.apache.amoro.api.OperationConflictException;
import org.apache.amoro.hive.utils.HiveTableUtil;
import org.apache.amoro.mixed.MixedFormatCatalog;
import org.apache.amoro.shade.guava32.com.google.common.collect.Lists;
import org.apache.amoro.spark.io.TaskWriters;
import org.apache.amoro.spark.writer.MixedFormatSparkWriteBuilder;
import org.apache.amoro.spark.writer.SimpleInternalRowDataWriter;
import org.apache.amoro.spark.writer.SimpleRowLevelDataWriter;
import org.apache.amoro.spark.writer.WriteTaskCommit;
import org.apache.amoro.table.MixedTable;
import org.apache.amoro.table.UnkeyedTable;
import org.apache.amoro.table.blocker.Blocker;
import org.apache.amoro.table.blocker.TableBlockerManager;
import org.apache.iceberg.AppendFiles;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.OverwriteFiles;
import org.apache.iceberg.ReplacePartitions;
import org.apache.iceberg.RowDelta;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.io.TaskWriter;
import org.apache.iceberg.util.PropertyUtil;
import org.apache.iceberg.util.Tasks;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.write.BatchWrite;
import org.apache.spark.sql.connector.write.DataWriter;
import org.apache.spark.sql.connector.write.DataWriterFactory;
import org.apache.spark.sql.connector.write.LogicalWriteInfo;
import org.apache.spark.sql.connector.write.PhysicalWriteInfo;
import org.apache.spark.sql.connector.write.Write;
import org.apache.spark.sql.connector.write.WriterCommitMessage;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class UnkeyedSparkBatchWrite
implements MixedFormatSparkWriteBuilder.MixedFormatWrite,
Write {
    private final UnkeyedTable table;
    private final StructType dsSchema;
    private final String hiveSubdirectory = HiveTableUtil.newHiveSubdirectory();
    private final boolean orderedWriter;
    private final MixedFormatCatalog catalog;

    public UnkeyedSparkBatchWrite(UnkeyedTable table, LogicalWriteInfo info, MixedFormatCatalog catalog) {
        this.table = table;
        this.dsSchema = info.schema();
        this.orderedWriter = Boolean.parseBoolean((String)info.options().getOrDefault((Object)"writer.distributed-and-ordered", (Object)"false"));
        this.catalog = catalog;
    }

    @Override
    public BatchWrite asBatchAppend() {
        return new AppendWrite();
    }

    @Override
    public BatchWrite asDynamicOverwrite() {
        return new DynamicOverwrite();
    }

    @Override
    public BatchWrite asOverwriteByFilter(Expression overwriteExpr) {
        return new OverwriteByFilter(overwriteExpr);
    }

    @Override
    public BatchWrite asUpsertWrite() {
        return new UpsertWrite();
    }

    private static class DeltaUpsertWriteFactory
    extends WriterFactory {
        DeltaUpsertWriteFactory(UnkeyedTable table, StructType dsSchema, boolean ordredWriter) {
            super(table, dsSchema, false, null, ordredWriter);
        }

        @Override
        public DataWriter<InternalRow> createWriter(int partitionId, long taskId) {
            StructType schema = new StructType((StructField[])Arrays.stream(this.dsSchema.fields()).filter(f -> !f.name().equals("_file") && !f.name().equals("_pos") && !f.name().equals("_upsert_op")).toArray(StructField[]::new));
            return new SimpleRowLevelDataWriter(this.newWriter(partitionId, taskId, schema), this.newWriter(partitionId, taskId, schema), this.dsSchema, this.table.isKeyedTable());
        }
    }

    private static class WriterFactory
    implements DataWriterFactory,
    Serializable {
        protected final UnkeyedTable table;
        protected final StructType dsSchema;
        protected final String hiveSubdirectory;
        protected final boolean isOverwrite;
        protected final boolean orderedWriter;

        WriterFactory(UnkeyedTable table, StructType dsSchema, boolean isOverwrite, String hiveSubdirectory, boolean orderedWrite) {
            this.table = table;
            this.dsSchema = dsSchema;
            this.isOverwrite = isOverwrite;
            this.hiveSubdirectory = hiveSubdirectory;
            this.orderedWriter = orderedWrite;
        }

        public DataWriter<InternalRow> createWriter(int partitionId, long taskId) {
            TaskWriters builder = TaskWriters.of((MixedTable)this.table).withPartitionId(partitionId).withTaskId(taskId).withOrderedWriter(this.orderedWriter).withDataSourceSchema(this.dsSchema).withHiveSubdirectory(this.hiveSubdirectory);
            TaskWriter<InternalRow> writer = builder.newBaseWriter(this.isOverwrite);
            return new SimpleInternalRowDataWriter(writer);
        }

        public TaskWriter<InternalRow> newWriter(int partitionId, long taskId, StructType schema) {
            return TaskWriters.of((MixedTable)this.table).withPartitionId(partitionId).withTaskId(taskId).withDataSourceSchema(schema).newUnkeyedUpsertWriter();
        }
    }

    private class UpsertWrite
    extends BaseBatchWrite {
        private UpsertWrite() {
        }

        public DataWriterFactory createBatchWriterFactory(PhysicalWriteInfo info) {
            this.getBlocker();
            return new DeltaUpsertWriteFactory(UnkeyedSparkBatchWrite.this.table, UnkeyedSparkBatchWrite.this.dsSchema, UnkeyedSparkBatchWrite.this.orderedWriter);
        }

        public void commit(WriterCommitMessage[] messages) {
            this.checkBlocker(this.tableBlockerManager);
            RowDelta rowDelta = UnkeyedSparkBatchWrite.this.table.newRowDelta();
            if (WriteTaskCommit.deleteFiles(messages).iterator().hasNext()) {
                for (DeleteFile deleteFile : WriteTaskCommit.deleteFiles(messages)) {
                    rowDelta.addDeletes(deleteFile);
                }
            }
            if (WriteTaskCommit.files(messages).iterator().hasNext()) {
                for (DataFile dataFile : WriteTaskCommit.files(messages)) {
                    rowDelta.addRows(dataFile);
                }
            }
            rowDelta.commit();
            this.tableBlockerManager.release(this.block);
        }
    }

    private class OverwriteByFilter
    extends BaseBatchWrite {
        private final Expression overwriteExpr;

        private OverwriteByFilter(Expression overwriteExpr) {
            this.overwriteExpr = overwriteExpr;
        }

        public DataWriterFactory createBatchWriterFactory(PhysicalWriteInfo info) {
            this.getBlocker();
            return new WriterFactory(UnkeyedSparkBatchWrite.this.table, UnkeyedSparkBatchWrite.this.dsSchema, true, UnkeyedSparkBatchWrite.this.hiveSubdirectory, UnkeyedSparkBatchWrite.this.orderedWriter);
        }

        public void commit(WriterCommitMessage[] messages) {
            this.checkBlocker(this.tableBlockerManager);
            OverwriteFiles overwriteFiles = UnkeyedSparkBatchWrite.this.table.newOverwrite();
            overwriteFiles.overwriteByRowFilter(this.overwriteExpr);
            overwriteFiles.set("delete-untracked-hive-file", "true");
            for (DataFile file : WriteTaskCommit.files(messages)) {
                overwriteFiles.addFile(file);
            }
            overwriteFiles.commit();
            this.tableBlockerManager.release(this.block);
        }
    }

    private class DynamicOverwrite
    extends BaseBatchWrite {
        private DynamicOverwrite() {
        }

        public DataWriterFactory createBatchWriterFactory(PhysicalWriteInfo info) {
            this.getBlocker();
            return new WriterFactory(UnkeyedSparkBatchWrite.this.table, UnkeyedSparkBatchWrite.this.dsSchema, true, UnkeyedSparkBatchWrite.this.hiveSubdirectory, UnkeyedSparkBatchWrite.this.orderedWriter);
        }

        public void commit(WriterCommitMessage[] messages) {
            this.checkBlocker(this.tableBlockerManager);
            ReplacePartitions replacePartitions = UnkeyedSparkBatchWrite.this.table.newReplacePartitions();
            for (DataFile file : WriteTaskCommit.files(messages)) {
                replacePartitions.addFile(file);
            }
            replacePartitions.commit();
            this.tableBlockerManager.release(this.block);
        }
    }

    private class AppendWrite
    extends BaseBatchWrite {
        private AppendWrite() {
        }

        public DataWriterFactory createBatchWriterFactory(PhysicalWriteInfo info) {
            this.getBlocker();
            return new WriterFactory(UnkeyedSparkBatchWrite.this.table, UnkeyedSparkBatchWrite.this.dsSchema, false, null, UnkeyedSparkBatchWrite.this.orderedWriter);
        }

        public void commit(WriterCommitMessage[] messages) {
            this.checkBlocker(this.tableBlockerManager);
            AppendFiles appendFiles = UnkeyedSparkBatchWrite.this.table.newAppend();
            for (DataFile file : WriteTaskCommit.files(messages)) {
                appendFiles.appendFile(file);
            }
            appendFiles.commit();
            this.tableBlockerManager.release(this.block);
        }
    }

    private abstract class BaseBatchWrite
    implements BatchWrite {
        protected TableBlockerManager tableBlockerManager;
        protected Blocker block;

        private BaseBatchWrite() {
        }

        public void abort(WriterCommitMessage[] messages) {
            try {
                Map props = UnkeyedSparkBatchWrite.this.table.properties();
                Tasks.foreach(WriteTaskCommit.files(messages)).retry(PropertyUtil.propertyAsInt((Map)props, (String)"commit.retry.num-retries", (int)4)).exponentialBackoff((long)PropertyUtil.propertyAsInt((Map)props, (String)"commit.retry.min-wait-ms", (int)100), (long)PropertyUtil.propertyAsInt((Map)props, (String)"commit.retry.max-wait-ms", (int)60000), (long)PropertyUtil.propertyAsInt((Map)props, (String)"commit.retry.total-timeout-ms", (int)1800000), 2.0).throwFailureWhenFinished().run(file -> UnkeyedSparkBatchWrite.this.table.io().deleteFile(file.path().toString()));
            }
            finally {
                this.tableBlockerManager.release(this.block);
            }
        }

        public void checkBlocker(TableBlockerManager tableBlockerManager) {
            List blockerIds = tableBlockerManager.getBlockers().stream().map(Blocker::blockerId).collect(Collectors.toList());
            if (!blockerIds.contains(this.block.blockerId())) {
                throw new IllegalStateException("block is not in blockerManager");
            }
        }

        public void getBlocker() {
            this.tableBlockerManager = UnkeyedSparkBatchWrite.this.catalog.getTableBlockerManager(UnkeyedSparkBatchWrite.this.table.id());
            ArrayList operations = Lists.newArrayList();
            operations.add(BlockableOperation.BATCH_WRITE);
            operations.add(BlockableOperation.OPTIMIZE);
            try {
                this.block = this.tableBlockerManager.block((List)operations);
            }
            catch (OperationConflictException e) {
                throw new IllegalStateException("failed to block table " + UnkeyedSparkBatchWrite.this.table.id() + " with " + operations, e);
            }
        }
    }
}

