/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.manager;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.PodTemplate;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.apps.DeploymentFluent;
import io.fabric8.kubernetes.api.model.apps.DeploymentSpec;
import io.fabric8.kubernetes.api.model.apps.DeploymentSpecFluent;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.amoro.resource.Resource;
import org.apache.amoro.server.manager.AbstractResourceContainer;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.amoro.shade.guava32.com.google.common.collect.ImmutableMap;
import org.apache.amoro.shade.guava32.com.google.common.collect.Maps;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class KubernetesOptimizerContainer
extends AbstractResourceContainer {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesOptimizerContainer.class);
    public static final String MEMORY_PROPERTY = "memory";
    public static final String CPU_FACTOR_PROPERTY = "cpu.factor";
    public static final String NAMESPACE = "namespace";
    public static final String IMAGE = "image";
    public static final String PULL_POLICY = "pullPolicy";
    public static final String PODTEMPLATE = "podTemplate";
    public static final String PULL_SECRETS = "imagePullSecrets";
    public static final String KUBE_CONFIG_PATH = "kube-config-path";
    private static final String NAME_PREFIX = "amoro-optimizer-";
    private static final String KUBERNETES_NAME_PROPERTIES = "name";
    private static final String EXTRA_PROPERTY_PREFIX = "extra.";
    private static final Map<String, String> EXTRA_PROPERTY_DEFAULTS = new HashMap<String, String>();
    private KubernetesClient client;

    private String getExtraProperty(Map<String, String> properties, String key) {
        return properties.getOrDefault(EXTRA_PROPERTY_PREFIX + key, EXTRA_PROPERTY_DEFAULTS.getOrDefault(key, null));
    }

    @Override
    public void init(String name, Map<String, String> containerProperties) {
        super.init(name, containerProperties);
        Optional<String> kubeConfigPath = Optional.ofNullable(containerProperties.get(KUBE_CONFIG_PATH));
        Config config = kubeConfigPath.map(path -> Config.fromKubeconfig((String)this.getKubeConfigContent((String)path))).orElseGet(() -> new ConfigBuilder().build());
        this.client = new KubernetesClientBuilder().withConfig(config).build();
    }

    @Override
    protected Map<String, String> doScaleOut(Resource resource) {
        Deployment deployment;
        HashMap groupProperties = Maps.newHashMap();
        groupProperties.putAll(this.getContainerProperties());
        groupProperties.putAll(resource.getProperties());
        Map<String, Object> argsList = this.generatePodStartArgs(resource, groupProperties);
        String image = argsList.get(IMAGE).toString();
        String namespace = argsList.get(NAMESPACE).toString();
        String pullPolicy = argsList.get(PULL_POLICY).toString();
        List imagePullSecretsList = (List)argsList.get(PULL_SECRETS);
        int cpuLimit = (Integer)argsList.get("cpuLimit");
        long memory = (Long)argsList.get(MEMORY_PROPERTY);
        String groupName = argsList.get("groupName").toString();
        String resourceId = argsList.get("resourceId").toString();
        String startUpArgs = argsList.get("startUpArgs").toString();
        String kubernetesName = NAME_PREFIX + resourceId;
        if (null != groupProperties.get(PODTEMPLATE)) {
            PodTemplate podTemplate = this.initPodTemplateFromLocal(groupProperties);
            deployment = this.initPodTemplateFromFrontEnd(podTemplate, image, pullPolicy, cpuLimit, groupName, resourceId, startUpArgs, memory, imagePullSecretsList);
        } else {
            deployment = this.initPodTemplateWithoutConfig(image, pullPolicy, cpuLimit, groupName, resourceId, startUpArgs, memory, imagePullSecretsList);
        }
        ((RollableScalableResource)((NonNamespaceOperation)this.client.apps().deployments().inNamespace(namespace)).resource((Object)deployment)).create();
        HashMap startupProperties = Maps.newHashMap();
        startupProperties.put(NAMESPACE, namespace);
        startupProperties.put(KUBERNETES_NAME_PROPERTIES, kubernetesName);
        return startupProperties;
    }

    public Map<String, Object> generatePodStartArgs(Resource resource, Map<String, String> groupProperties) {
        long memory;
        if (resource.getMemoryMb() > 0) {
            memory = resource.getMemoryMb();
        } else {
            long memoryPerThread = Long.parseLong(KubernetesOptimizerContainer.checkAndGetProperty(groupProperties, MEMORY_PROPERTY));
            memory = memoryPerThread * (long)resource.getThreadCount();
        }
        double jvmHeapRatio = Double.parseDouble(this.getExtraProperty(groupProperties, "jvm.heap.ratio"));
        long jvmHeapMemory = (long)((double)memory * jvmHeapRatio);
        String startUpArgs = String.format("/entrypoint.sh optimizer %s %s", jvmHeapMemory, super.buildOptimizerStartupArgsString(resource));
        LOG.info("Starting k8s optimizer using k8s client with start command : {}", (Object)startUpArgs);
        String namespace = groupProperties.getOrDefault(NAMESPACE, "default");
        String image = KubernetesOptimizerContainer.checkAndGetProperty(groupProperties, IMAGE);
        String pullPolicy = KubernetesOptimizerContainer.checkAndGetProperty(groupProperties, PULL_POLICY);
        String pullSecrets = groupProperties.getOrDefault(PULL_SECRETS, "");
        String cpuLimitFactorString = groupProperties.getOrDefault(CPU_FACTOR_PROPERTY, "1.0");
        double cpuLimitFactor = Double.parseDouble(cpuLimitFactorString);
        int cpuLimit = (int)Math.ceil(cpuLimitFactor * (double)resource.getThreadCount());
        List imagePullSecretsList = Arrays.stream(pullSecrets.split(";")).map(secret -> ((LocalObjectReferenceBuilder)new LocalObjectReferenceBuilder().withName(secret)).build()).collect(Collectors.toList());
        String resourceId = resource.getResourceId();
        String groupName = resource.getGroupName();
        HashMap argsList = Maps.newHashMap();
        argsList.put(NAMESPACE, namespace);
        argsList.put(IMAGE, image);
        argsList.put(PULL_POLICY, pullPolicy);
        argsList.put(PULL_SECRETS, imagePullSecretsList);
        argsList.put(MEMORY_PROPERTY, memory);
        argsList.put("cpuLimit", cpuLimit);
        argsList.put("resourceId", resourceId);
        argsList.put("groupName", groupName);
        argsList.put("startUpArgs", startUpArgs);
        return argsList;
    }

    public Deployment initPodTemplateWithoutConfig(String image, String pullPolicy, int cpuLimit, String groupName, String resourceId, String startUpArgs, long memory, List<LocalObjectReference> imagePullSecretsList) {
        DeploymentBuilder deploymentBuilder = (DeploymentBuilder)((DeploymentFluent.SpecNested)((DeploymentSpecFluent.SelectorNested)((DeploymentFluent.SpecNested)((DeploymentSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((DeploymentSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((PodTemplateSpecFluent.MetadataNested)((PodTemplateSpecFluent.MetadataNested)((DeploymentFluent.SpecNested)((DeploymentBuilder)((DeploymentFluent.MetadataNested)new DeploymentBuilder().withNewMetadata().withName(NAME_PREFIX + resourceId)).endMetadata()).withNewSpec().withReplicas(Integer.valueOf(1))).withNewTemplate().withNewMetadata().addToLabels("app", NAME_PREFIX + resourceId)).addToLabels("AmoroOptimizerGroup", groupName)).addToLabels("AmoroResourceId", resourceId)).endMetadata()).withNewSpec().addNewContainer().withName("optimizer")).withImage(image)).withImagePullPolicy(pullPolicy)).withCommand(new String[]{"sh", "-c", startUpArgs})).withResources(((ResourceRequirementsBuilder)((ResourceRequirementsBuilder)new ResourceRequirementsBuilder().withLimits((Map)ImmutableMap.of((Object)MEMORY_PROPERTY, (Object)new Quantity(memory + "Mi"), (Object)"cpu", (Object)new Quantity(cpuLimit + "")))).withRequests((Map)ImmutableMap.of((Object)MEMORY_PROPERTY, (Object)new Quantity(memory + "Mi"), (Object)"cpu", (Object)new Quantity(cpuLimit + "")))).build())).endContainer()).endSpec()).endTemplate()).withNewSelector().addToMatchLabels("app", NAME_PREFIX + resourceId)).endSelector()).endSpec();
        if (!imagePullSecretsList.isEmpty()) {
            ((DeploymentFluent.SpecNested)((DeploymentSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)deploymentBuilder.editSpec().editTemplate().editSpec().withImagePullSecrets(imagePullSecretsList)).endSpec()).endTemplate()).endSpec();
        }
        return deploymentBuilder.build();
    }

    public PodTemplate initPodTemplateFromLocal(Map<String, String> groupProperties) {
        return (PodTemplate)new Yaml().loadAs(groupProperties.get(PODTEMPLATE), PodTemplate.class);
    }

    public Deployment initPodTemplateFromFrontEnd(PodTemplate podTemplate, String image, String pullPolicy, int cpuLimit, final String groupName, final String resourceId, String startUpArgs, long memory, List<LocalObjectReference> imagePullSecretsList) {
        podTemplate.getTemplate().getMetadata().setLabels((Map)new HashMap<String, String>(){
            {
                this.put("app", KubernetesOptimizerContainer.NAME_PREFIX + resourceId);
                this.put("AmoroOptimizerGroup", groupName);
                this.put("AmoroResourceId", resourceId);
            }
        });
        Container container = new Container();
        container.setName("optimizer");
        container.setImage(image);
        container.setImagePullPolicy(pullPolicy);
        container.setCommand(new ArrayList<String>(Arrays.asList("sh", "-c", startUpArgs)));
        ResourceRequirements resourceRequirements = new ResourceRequirements();
        resourceRequirements.setLimits((Map)ImmutableMap.of((Object)MEMORY_PROPERTY, (Object)new Quantity(memory + "Mi"), (Object)"cpu", (Object)new Quantity(cpuLimit + "")));
        resourceRequirements.setRequests((Map)ImmutableMap.of((Object)MEMORY_PROPERTY, (Object)new Quantity(memory + "Mi"), (Object)"cpu", (Object)new Quantity(cpuLimit + "")));
        container.setResources(resourceRequirements);
        podTemplate.getTemplate().getSpec().getContainers().set(0, container);
        if (!imagePullSecretsList.isEmpty()) {
            podTemplate.getTemplate().getSpec().setImagePullSecrets(imagePullSecretsList);
        }
        DeploymentSpec deploymentSpec = new DeploymentSpec();
        deploymentSpec.setTemplate(podTemplate.getTemplate());
        LabelSelector labelSelector = new LabelSelector();
        labelSelector.setMatchLabels((Map)new HashMap<String, String>(){
            {
                this.put("app", KubernetesOptimizerContainer.NAME_PREFIX + resourceId);
            }
        });
        deploymentSpec.setSelector(labelSelector);
        deploymentSpec.setReplicas(Integer.valueOf(1));
        Deployment deployment = new Deployment();
        deployment.setSpec(deploymentSpec);
        ObjectMeta deploymentMetadata = new ObjectMeta();
        deploymentMetadata.setName(NAME_PREFIX + resourceId);
        deployment.setMetadata(deploymentMetadata);
        return deployment;
    }

    public void releaseOptimizer(Resource resource) {
        String resourceId = resource.getResourceId();
        LOG.info("release Kubernetes Optimizer Container {}", (Object)resourceId);
        String namespace = (String)resource.getProperties().get(NAMESPACE);
        String name = (String)resource.getProperties().get(KUBERNETES_NAME_PROPERTIES);
        ((RollableScalableResource)((NonNamespaceOperation)this.client.apps().deployments().inNamespace(namespace)).withName(name)).delete();
    }

    private static String checkAndGetProperty(Map<String, String> properties, String key) {
        Preconditions.checkState((properties != null && properties.containsKey(key) ? 1 : 0) != 0, (String)"Cannot find %s in properties", (Object)key);
        return properties.get(key);
    }

    private String getKubeConfigContent(String path) {
        try {
            return IOUtils.toString((InputStream)Files.newInputStream(Paths.get(path, new String[0]), new OpenOption[0]), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        EXTRA_PROPERTY_DEFAULTS.put("jvm.heap.ratio", "0.8");
    }
}

