/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.persistence;

import com.github.pagehelper.PageInterceptor;
import com.github.pagehelper.dialect.helper.MySqlDialect;
import com.github.pagehelper.dialect.helper.PostgreSqlDialect;
import com.github.pagehelper.dialect.helper.SqlServer2012Dialect;
import com.github.pagehelper.page.PageAutoDialect;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.amoro.server.persistence.mapper.ApiTokensMapper;
import org.apache.amoro.server.persistence.mapper.CatalogMetaMapper;
import org.apache.amoro.server.persistence.mapper.OptimizerMapper;
import org.apache.amoro.server.persistence.mapper.OptimizingMapper;
import org.apache.amoro.server.persistence.mapper.PlatformFileMapper;
import org.apache.amoro.server.persistence.mapper.ResourceMapper;
import org.apache.amoro.server.persistence.mapper.TableBlockerMapper;
import org.apache.amoro.server.persistence.mapper.TableMetaMapper;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.mapping.VendorDatabaseIdProvider;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;
import org.apache.ibatis.transaction.TransactionFactory;
import org.apache.ibatis.transaction.jdbc.JdbcTransactionFactory;

public class SqlSessionFactoryProvider {
    private static final SqlSessionFactoryProvider INSTANCE = new SqlSessionFactoryProvider();
    private volatile SqlSessionFactory sqlSessionFactory;

    public static SqlSessionFactoryProvider getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(DataSource dataSource) throws SQLException {
        this.registerDialectAliases();
        JdbcTransactionFactory transactionFactory = new JdbcTransactionFactory();
        Environment environment = new Environment("develop", (TransactionFactory)transactionFactory, dataSource);
        Configuration configuration = new Configuration(environment);
        configuration.addMapper(TableMetaMapper.class);
        configuration.addMapper(OptimizingMapper.class);
        configuration.addMapper(CatalogMetaMapper.class);
        configuration.addMapper(OptimizerMapper.class);
        configuration.addMapper(ApiTokensMapper.class);
        configuration.addMapper(PlatformFileMapper.class);
        configuration.addMapper(ResourceMapper.class);
        configuration.addMapper(TableBlockerMapper.class);
        PageInterceptor interceptor = new PageInterceptor();
        Properties interceptorProperties = new Properties();
        interceptorProperties.setProperty("reasonable", "false");
        interceptor.setProperties(interceptorProperties);
        configuration.addInterceptor((Interceptor)interceptor);
        VendorDatabaseIdProvider provider = new VendorDatabaseIdProvider();
        Properties properties = new Properties();
        properties.setProperty("MySQL", "mysql");
        properties.setProperty("PostgreSQL", "postgres");
        properties.setProperty("Derby", "derby");
        provider.setProperties(properties);
        configuration.setDatabaseId(provider.getDatabaseId(dataSource));
        if (this.sqlSessionFactory == null) {
            SqlSessionFactoryProvider sqlSessionFactoryProvider = this;
            synchronized (sqlSessionFactoryProvider) {
                if (this.sqlSessionFactory == null) {
                    this.sqlSessionFactory = new SqlSessionFactoryBuilder().build(configuration);
                }
            }
        }
    }

    private void registerDialectAliases() {
        PageAutoDialect.registerDialectAlias((String)"postgres", PostgreSqlDialect.class);
        PageAutoDialect.registerDialectAlias((String)"mysql", MySqlDialect.class);
        PageAutoDialect.registerDialectAlias((String)"derby", SqlServer2012Dialect.class);
    }

    public SqlSessionFactory get() {
        Preconditions.checkState((this.sqlSessionFactory != null ? 1 : 0) != 0, (Object)"Persistent configuration is not initialized yet.");
        return this.sqlSessionFactory;
    }
}

