/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.geocoder.openstreetmap;

import org.apache.baremaps.geocoder.GeocoderConstants;
import org.apache.baremaps.geocoder.openstreetmap.OsmTags;
import org.apache.lucene.queryparser.classic.QueryParserBase;
import org.apache.lucene.queryparser.simple.SimpleQueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;

public class OpenStreetMapQuery {
    private final String query;

    public OpenStreetMapQuery(String query) {
        this.query = query;
    }

    public Query build() {
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        String queryTextEsc = QueryParserBase.escape((String)this.query);
        SimpleQueryParser parser = new SimpleQueryParser(GeocoderConstants.ANALYZER, OsmTags.NAME.key());
        Query termsQuery = parser.parse(queryTextEsc);
        builder.add(termsQuery, BooleanClause.Occur.MUST);
        return builder.build();
    }
}

