/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.geotiff.inflater;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.sis.image.DataType;
import org.apache.sis.pending.jdk.JDK17;
import org.apache.sis.storage.geotiff.inflater.CompressionChannel;
import org.apache.sis.storage.geotiff.inflater.PredictorChannel;

abstract class HorizontalPredictor
extends PredictorChannel {
    private final int sampleSizeM1;
    protected final int pixelStride;
    private final int scanlineStride;
    private int column;
    private final int truncationMask;

    HorizontalPredictor(CompressionChannel input, int samplesPerPixel, int width, int sampleSize) {
        super(input);
        this.sampleSizeM1 = sampleSize - 1;
        this.truncationMask = ~this.sampleSizeM1;
        this.pixelStride = samplesPerPixel * sampleSize;
        this.scanlineStride = Math.multiplyExact(width, this.pixelStride);
    }

    static HorizontalPredictor create(CompressionChannel input, DataType dataType, int pixelStride, int width) {
        switch (dataType) {
            case USHORT: 
            case SHORT: {
                return new Shorts(input, pixelStride, width);
            }
            case BYTE: {
                return new Bytes(input, pixelStride, width);
            }
            case INT: {
                return new Integers(input, pixelStride, width);
            }
            case FLOAT: {
                return new Floats(input, pixelStride, width);
            }
            case DOUBLE: {
                return new Doubles(input, pixelStride, width);
            }
        }
        return null;
    }

    @Override
    public final void setInputRegion(long start, long byteCount) throws IOException {
        super.setInputRegion(start, byteCount);
        this.column = 0;
    }

    @Override
    protected final int apply(ByteBuffer buffer, int start) {
        int endOfFirstPixel;
        int limit = buffer.position();
        int limitMS = limit - this.sampleSizeM1;
        int position = start;
        if (this.column < this.pixelStride) {
            position += Math.min(this.pixelStride - this.column, limit - position & this.truncationMask);
        }
        if ((this.column += (position = this.applyOnFirst(buffer, position, endOfFirstPixel = Math.min(Math.min(start + this.pixelStride, this.scanlineStride), limitMS), position - start)) - start) >= this.scanlineStride) {
            this.column = 0;
        }
        while (position < limitMS) {
            assert ((this.column & ~this.truncationMask) == 0) : this.column;
            if (this.column == 0) {
                this.column = Math.min(this.pixelStride, limit - position & this.truncationMask);
                position += this.column;
            }
            int startOfRow = position;
            if ((this.column += (position = this.applyOnRow(buffer, position, Math.min(position + (this.scanlineStride - this.column), limitMS))) - startOfRow) < this.scanlineStride) continue;
            this.column = 0;
        }
        int from = position - this.pixelStride;
        int keep = Math.max(start - from, 0);
        assert ((keep & ~this.truncationMask) == 0) : keep;
        this.saveLastPixel(buffer, keep, from + keep);
        return position;
    }

    abstract int applyOnFirst(ByteBuffer var1, int var2, int var3, int var4);

    abstract int applyOnRow(ByteBuffer var1, int var2, int var3);

    abstract void saveLastPixel(ByteBuffer var1, int var2, int var3);

    private static final class Shorts
    extends HorizontalPredictor {
        private final short[] savedValues;

        Shorts(CompressionChannel input, int samplesPerPixel, int width) {
            super(input, samplesPerPixel, width, 2);
            this.savedValues = new short[samplesPerPixel];
        }

        @Override
        void saveLastPixel(ByteBuffer buffer, int offset, int position) {
            assert (offset % 2 == 0) : offset;
            System.arraycopy(this.savedValues, this.savedValues.length - (offset /= 2), this.savedValues, 0, offset);
            while (offset < this.savedValues.length) {
                this.savedValues[offset++] = buffer.getShort(position);
                position += 2;
            }
        }

        @Override
        int applyOnFirst(ByteBuffer buffer, int position, int end, int offset) {
            assert (offset % 2 == 0) : offset;
            offset /= 2;
            while (position < end) {
                buffer.putShort(position, (short)(buffer.getShort(position) + this.savedValues[offset++]));
                position += 2;
            }
            return position;
        }

        @Override
        int applyOnRow(ByteBuffer buffer, int position, int end) {
            while (position < end) {
                buffer.putShort(position, (short)(buffer.getShort(position) + buffer.getShort(position - this.pixelStride)));
                position += 2;
            }
            return position;
        }
    }

    private static final class Bytes
    extends HorizontalPredictor {
        private final byte[] savedValues;

        Bytes(CompressionChannel input, int samplesPerPixel, int width) {
            super(input, samplesPerPixel, width, 1);
            this.savedValues = new byte[samplesPerPixel];
        }

        @Override
        void saveLastPixel(ByteBuffer buffer, int offset, int position) {
            System.arraycopy(this.savedValues, this.savedValues.length - offset, this.savedValues, 0, offset);
            JDK17.get((ByteBuffer)buffer, (int)position, (byte[])this.savedValues, (int)offset, (int)(this.savedValues.length - offset));
        }

        @Override
        int applyOnFirst(ByteBuffer buffer, int position, int end, int offset) {
            while (position < end) {
                buffer.put(position, (byte)(buffer.get(position) + this.savedValues[offset++]));
                ++position;
            }
            return position;
        }

        @Override
        int applyOnRow(ByteBuffer buffer, int position, int end) {
            while (position < end) {
                buffer.put(position, (byte)(buffer.get(position) + buffer.get(position - this.pixelStride)));
                ++position;
            }
            return position;
        }
    }

    private static final class Integers
    extends HorizontalPredictor {
        private final int[] savedValues;

        Integers(CompressionChannel input, int samplesPerPixel, int width) {
            super(input, samplesPerPixel, width, 4);
            this.savedValues = new int[samplesPerPixel];
        }

        @Override
        void saveLastPixel(ByteBuffer buffer, int offset, int position) {
            assert (offset % 4 == 0) : offset;
            System.arraycopy(this.savedValues, this.savedValues.length - (offset /= 4), this.savedValues, 0, offset);
            while (offset < this.savedValues.length) {
                this.savedValues[offset++] = buffer.getInt(position);
                position += 4;
            }
        }

        @Override
        int applyOnFirst(ByteBuffer buffer, int position, int end, int offset) {
            assert (offset % 4 == 0) : offset;
            offset /= 4;
            while (position < end) {
                buffer.putInt(position, buffer.getInt(position) + this.savedValues[offset++]);
                position += 4;
            }
            return position;
        }

        @Override
        int applyOnRow(ByteBuffer buffer, int position, int end) {
            while (position < end) {
                buffer.putInt(position, buffer.getInt(position) + buffer.getInt(position - this.pixelStride));
                position += 4;
            }
            return position;
        }
    }

    private static final class Floats
    extends HorizontalPredictor {
        private final float[] savedValues;

        Floats(CompressionChannel input, int samplesPerPixel, int width) {
            super(input, samplesPerPixel, width, 4);
            this.savedValues = new float[samplesPerPixel];
        }

        @Override
        void saveLastPixel(ByteBuffer buffer, int offset, int position) {
            assert (offset % 4 == 0) : offset;
            System.arraycopy(this.savedValues, this.savedValues.length - (offset /= 4), this.savedValues, 0, offset);
            while (offset < this.savedValues.length) {
                this.savedValues[offset++] = buffer.getFloat(position);
                position += 4;
            }
        }

        @Override
        int applyOnFirst(ByteBuffer buffer, int position, int end, int offset) {
            assert (offset % 4 == 0) : offset;
            offset /= 4;
            while (position < end) {
                buffer.putFloat(position, buffer.getFloat(position) + this.savedValues[offset++]);
                position += 4;
            }
            return position;
        }

        @Override
        int applyOnRow(ByteBuffer buffer, int position, int end) {
            while (position < end) {
                buffer.putFloat(position, buffer.getFloat(position) + buffer.getFloat(position - this.pixelStride));
                position += 4;
            }
            return position;
        }
    }

    private static final class Doubles
    extends HorizontalPredictor {
        private final double[] savedValues;

        Doubles(CompressionChannel input, int samplesPerPixel, int width) {
            super(input, samplesPerPixel, width, 8);
            this.savedValues = new double[samplesPerPixel];
        }

        @Override
        void saveLastPixel(ByteBuffer buffer, int offset, int position) {
            assert (offset % 8 == 0) : offset;
            System.arraycopy(this.savedValues, this.savedValues.length - (offset /= 8), this.savedValues, 0, offset);
            while (offset < this.savedValues.length) {
                this.savedValues[offset++] = buffer.getDouble(position);
                position += 8;
            }
        }

        @Override
        int applyOnFirst(ByteBuffer buffer, int position, int end, int offset) {
            assert (offset % 8 == 0) : offset;
            offset /= 8;
            while (position < end) {
                buffer.putDouble(position, buffer.getDouble(position) + this.savedValues[offset++]);
                position += 8;
            }
            return position;
        }

        @Override
        int applyOnRow(ByteBuffer buffer, int position, int end) {
            while (position < end) {
                buffer.putDouble(position, buffer.getDouble(position) + buffer.getDouble(position - this.pixelStride));
                position += 8;
            }
            return position;
        }
    }
}

