/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.dist.worker.schema.cache;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Interner;
import org.apache.bifromq.dist.rpc.proto.RouteGroup;
import org.apache.bifromq.dist.worker.schema.cache.GroupMatching;
import org.apache.bifromq.dist.worker.schema.cache.Matching;
import org.apache.bifromq.dist.worker.schema.cache.RouteDetail;

public class GroupMatchingCache {
    private static final Interner<CacheKey> CACHE_KEY_INTERNER = Interner.newWeakInterner();
    private static final Interner<GroupMatching> GROUP_MATCHING_INTERNER = Interner.newWeakInterner();
    private static final Cache<CacheKey, Matching> GROUP_MATCHING_CACHE = Caffeine.newBuilder().weakKeys().weakValues().build();

    public static Matching get(RouteDetail routeDetail, RouteGroup group) {
        CacheKey key = (CacheKey)CACHE_KEY_INTERNER.intern((Object)new CacheKey(routeDetail, group));
        return (Matching)GROUP_MATCHING_CACHE.get((Object)key, (T k) -> (Matching)GROUP_MATCHING_INTERNER.intern((Object)new GroupMatching(k.routeDetail.tenantId(), k.routeDetail.matcher(), k.routeGroup().getMembersMap())));
    }

    private record CacheKey(RouteDetail routeDetail, RouteGroup routeGroup) {
    }
}

