/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.inbox.util;

import org.apache.bifromq.inbox.record.InboxInstance;
import org.apache.bifromq.sysprops.props.InboxDelivererNum;

public class InboxServiceUtil {
    private static final int MAX_INBOX_DELIVERER = (Integer)InboxDelivererNum.INSTANCE.get();
    private static final char SEPARATOR = '_';
    private static final int INCARNATION_LENGTH = 20;
    private static final int DELIVERER_KEY_WIDTH = 5;

    public static String receiverId(String inboxId, long incarnation) {
        int totalLength = inboxId.length() + 1 + 20;
        char[] buf = new char[totalLength];
        int pos = 0;
        inboxId.getChars(0, inboxId.length(), buf, pos);
        pos += inboxId.length();
        buf[pos++] = 95;
        int numStart = pos;
        for (int i = 0; i < 20; ++i) {
            buf[pos + i] = 48;
        }
        int index = numStart + 20 - 1;
        for (long temp = incarnation; temp > 0L && index >= numStart; temp /= 10L) {
            buf[index--] = (char)(48 + (int)(temp % 10L));
        }
        return new String(buf);
    }

    public static InboxInstance parseReceiverId(String receiverId) {
        int incarnationStart = receiverId.length() - 20;
        String inboxId = receiverId.substring(0, incarnationStart - 1);
        long incarnation = Long.parseUnsignedLong(receiverId.substring(incarnationStart));
        return new InboxInstance(inboxId, incarnation);
    }

    public static String parseTenantId(String delivererKey) {
        int tenantIdLength = delivererKey.length() - 6;
        return delivererKey.substring(0, tenantIdLength);
    }

    public static String getDelivererKey(String tenantId, String inboxId) {
        int i;
        int k = inboxId.hashCode() % MAX_INBOX_DELIVERER;
        if (k < 0) {
            k = (k + MAX_INBOX_DELIVERER) % MAX_INBOX_DELIVERER;
        }
        int totalLength = tenantId.length() + 1 + 5;
        char[] buf = new char[totalLength];
        int pos = 0;
        tenantId.getChars(0, tenantId.length(), buf, pos);
        pos += tenantId.length();
        buf[pos++] = 95;
        int divisor = 1;
        for (i = 1; i < 5; ++i) {
            divisor *= 10;
        }
        for (i = 0; i < 5; ++i) {
            int digit = k / divisor;
            buf[pos++] = (char)(48 + digit);
            k %= divisor;
            divisor /= 10;
        }
        return new String(buf);
    }
}

