/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.inbox.store;

import com.google.protobuf.ByteString;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tags;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.apache.bifromq.basehlc.HLC;
import org.apache.bifromq.basekv.client.IBaseKVStoreClient;
import org.apache.bifromq.basekv.client.KVRangeRouterUtil;
import org.apache.bifromq.basekv.client.KVRangeSetting;
import org.apache.bifromq.basekv.proto.Boundary;
import org.apache.bifromq.basekv.proto.KVRangeId;
import org.apache.bifromq.basekv.store.proto.KVRangeRORequest;
import org.apache.bifromq.basekv.store.proto.ROCoProcInput;
import org.apache.bifromq.basekv.store.proto.ReplyCode;
import org.apache.bifromq.basekv.utils.BoundaryUtil;
import org.apache.bifromq.basekv.utils.KVRangeIdUtil;
import org.apache.bifromq.inbox.storage.proto.GCReply;
import org.apache.bifromq.inbox.storage.proto.GCRequest;
import org.apache.bifromq.inbox.storage.proto.InboxServiceROCoProcInput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InboxStoreCleaner {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InboxStoreCleaner.class);
    private static final int MAX_STEP = 10;
    private static final int SCAN_QUOTA_BASE = 512;
    private static final int FIRST_SWEEP_SCAN_QUOTA = 50000;
    private static final Duration FIRST_SWEEP_INTERVAL = Duration.ofSeconds(5L);
    private static final double HIGH_SUCCESS_RATIO = 0.005;
    private static final int LOW_HIT_THRESHOLD = 3;
    private static final double QUOTA_HIT_RATIO = 0.8;
    private static final double GROWTH = 1.5;
    private static final double SHRINK = 2.0;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final IBaseKVStoreClient inboxStoreClient;
    private final Duration minCleanInterval;
    private final Duration maxCleanInterval;
    private final ScheduledExecutorService jobScheduler;
    private final Clock clock;
    private final Map<KVRangeId, RangeGcState> rangeStates = new HashMap<KVRangeId, RangeGcState>();
    private volatile ScheduledFuture<?> cleanerFuture;

    InboxStoreCleaner(IBaseKVStoreClient inboxStoreClient, Duration minCleanInterval, Duration maxCleanInterval, ScheduledExecutorService jobScheduler) {
        this(inboxStoreClient, minCleanInterval, maxCleanInterval, jobScheduler, Clock.systemUTC());
    }

    InboxStoreCleaner(IBaseKVStoreClient inboxStoreClient, Duration minCleanInterval, Duration maxCleanInterval, ScheduledExecutorService jobScheduler, Clock clock) {
        this.inboxStoreClient = inboxStoreClient;
        this.minCleanInterval = minCleanInterval;
        this.maxCleanInterval = maxCleanInterval;
        this.jobScheduler = jobScheduler;
        this.clock = clock;
    }

    private static boolean equalsBoundary(Boundary a, Boundary b) {
        return BoundaryUtil.compareStartKey((ByteString)BoundaryUtil.startKey((Boundary)a), (ByteString)BoundaryUtil.startKey((Boundary)b)) == 0 && BoundaryUtil.compareEndKeys((ByteString)BoundaryUtil.endKey((Boundary)a), (ByteString)BoundaryUtil.endKey((Boundary)b)) == 0;
    }

    void start(String storeId) {
        if (this.started.compareAndSet(false, true)) {
            log.info("InboxStoreCleaner started");
            this.doStart(storeId);
        }
    }

    CompletableFuture<Void> stop() {
        if (this.started.compareAndSet(true, false)) {
            this.cleanerFuture.cancel(true);
            CompletableFuture<Void> onDone = new CompletableFuture<Void>();
            this.jobScheduler.execute(() -> {
                log.info("InboxStoreCleaner stopped");
                for (RangeGcState st : this.rangeStates.values()) {
                    if (st.stepGauge != null) {
                        Metrics.globalRegistry.removeByPreFilterId(st.stepGauge.getId());
                    }
                    if (st.intervalGauge == null) continue;
                    Metrics.globalRegistry.removeByPreFilterId(st.intervalGauge.getId());
                }
                this.rangeStates.clear();
                onDone.complete(null);
            });
            return onDone;
        }
        return CompletableFuture.completedFuture(null);
    }

    private void doStart(String storeId) {
        if (!this.started.get()) {
            return;
        }
        Instant now = this.clock.instant();
        Duration chosenDelay = null;
        boolean anyDueNow = false;
        for (RangeGcState state : this.rangeStates.values()) {
            if (state.nextDue.isAfter(now)) {
                Duration d = Duration.between(now, state.nextDue);
                if (chosenDelay != null && d.compareTo(chosenDelay) >= 0) continue;
                chosenDelay = d;
                continue;
            }
            anyDueNow = true;
        }
        Duration delay = anyDueNow ? Duration.ZERO : (chosenDelay == null ? this.minCleanInterval : chosenDelay);
        this.cleanerFuture = this.jobScheduler.schedule(() -> this.doClean(storeId).thenRun(() -> this.doStart(storeId)), delay.toMillis(), TimeUnit.MILLISECONDS);
    }

    private CompletableFuture<Void> doClean(String storeId) {
        if (!this.started.get()) {
            return CompletableFuture.completedFuture(null);
        }
        List<KVRangeSetting> leaders = KVRangeRouterUtil.findByBoundary((Boundary)BoundaryUtil.FULL_BOUNDARY, (NavigableMap)this.inboxStoreClient.latestEffectiveRouter()).stream().filter(r -> r.leader().equals(storeId)).toList();
        HashMap<KVRangeId, KVRangeSetting> currentLeaderMap = new HashMap<KVRangeId, KVRangeSetting>();
        for (KVRangeSetting rs2 : leaders) {
            currentLeaderMap.put(rs2.id(), rs2);
            RangeGcState state = this.rangeStates.computeIfAbsent(rs2.id(), rid -> {
                RangeGcState ns = new RangeGcState();
                ns.step = 1;
                ns.interval = FIRST_SWEEP_INTERVAL;
                ns.lowRatioHits = 0;
                ns.wrappedOnce = false;
                ns.nextDue = this.clock.instant();
                ns.ver = rs2.ver();
                ns.boundary = rs2.boundary();
                ns.sprinted = false;
                Tags tags = Tags.of((String)"storeId", (String)storeId).and("rangeId", KVRangeIdUtil.toString((KVRangeId)rs2.id()));
                ns.intervalGauge = Gauge.builder((String)"inbox.gc.interval.ms", (Object)ns, s -> s.interval.toMillis()).tags((Iterable)tags).register((MeterRegistry)Metrics.globalRegistry);
                ns.stepGauge = Gauge.builder((String)"inbox.gc.step", (Object)ns, s -> s.step).tags((Iterable)tags).register((MeterRegistry)Metrics.globalRegistry);
                return ns;
            });
            if (state.ver == rs2.ver() && InboxStoreCleaner.equalsBoundary(state.boundary, rs2.boundary())) continue;
            if (state.nextKey != null) {
                state.nextKey = BoundaryUtil.clampToBoundary((ByteString)state.nextKey, (Boundary)rs2.boundary());
            }
            state.step = 1;
            state.interval = state.sprinted ? this.minCleanInterval : FIRST_SWEEP_INTERVAL;
            state.lowRatioHits = 0;
            state.wrappedOnce = false;
            state.ver = rs2.ver();
            state.boundary = rs2.boundary();
        }
        Iterator<Map.Entry<KVRangeId, RangeGcState>> iter = this.rangeStates.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<KVRangeId, RangeGcState> e = iter.next();
            if (currentLeaderMap.containsKey(e.getKey())) continue;
            RangeGcState st = e.getValue();
            if (st.stepGauge != null) {
                Metrics.globalRegistry.removeByPreFilterId(st.stepGauge.getId());
            }
            if (st.intervalGauge != null) {
                Metrics.globalRegistry.removeByPreFilterId(st.intervalGauge.getId());
            }
            iter.remove();
        }
        long reqId = HLC.INST.getPhysical();
        Instant now = this.clock.instant();
        CompletableFuture[] futures = (CompletableFuture[])leaders.stream().map(rs -> {
            ByteString start;
            RangeGcState s = this.rangeStates.get(rs.id());
            if (s == null || s.nextDue.isAfter(now)) {
                return CompletableFuture.completedFuture(null);
            }
            GCRequest.Builder gcReq = GCRequest.newBuilder().setNow(now.toEpochMilli());
            int quotaToUse = s.sprinted ? 512 * s.step : 50000;
            gcReq.setScanQuota(quotaToUse);
            if (s.nextKey != null && (start = BoundaryUtil.clampToBoundary((ByteString)s.nextKey, (Boundary)rs.boundary())) != null) {
                gcReq.setStartKey(start);
            }
            String rangeIdStr = KVRangeIdUtil.toString((KVRangeId)rs.id());
            log.debug("[InboxStore] start gc: reqId={}, rangeId={}, step={}, quota={}", new Object[]{reqId, rangeIdStr, s.step, quotaToUse});
            return this.inboxStoreClient.query(rs.leader(), KVRangeRORequest.newBuilder().setReqId(reqId).setKvRangeId(rs.id()).setVer(rs.ver()).setRoCoProc(ROCoProcInput.newBuilder().setInboxService(InboxServiceROCoProcInput.newBuilder().setReqId(reqId).setGc(gcReq.build()).build()).build()).build()).handle((v, e) -> {
                try {
                    if (e != null) {
                        log.debug("[InboxStore] gc error: reqId={}, rangeId={}", new Object[]{reqId, rangeIdStr, e});
                        this.onGCFailure(s);
                        Object var7_6 = null;
                        return var7_6;
                    }
                    if (v.getCode() != ReplyCode.Ok) {
                        log.debug("[InboxStore] gc rejected: reqId={}, rangeId={}, reason={}", new Object[]{reqId, rangeIdStr, v.getCode()});
                        this.onGCFailure(s);
                        Object var7_7 = null;
                        return var7_7;
                    }
                    GCReply reply = v.getRoCoProcResult().getInboxService().getGc();
                    this.onGCSuccess(s, reply);
                    log.debug("[InboxStore] gc done: reqId={}, rangeId={}, inspected={}, removed={}, wrapped={}", new Object[]{reqId, rangeIdStr, reply.getInspectedCount(), reply.getRemoveSuccess(), reply.getWrapped()});
                }
                finally {
                    s.nextDue = this.clock.instant().plus(s.interval);
                }
                return null;
            });
        }).toArray(CompletableFuture[]::new);
        return CompletableFuture.allOf(futures);
    }

    private void onGCFailure(RangeGcState s) {
        s.step = 1;
        s.interval = s.sprinted ? this.minCleanInterval : FIRST_SWEEP_INTERVAL;
        s.lowRatioHits = 0;
        s.wrappedOnce = false;
    }

    private void onGCSuccess(RangeGcState s, GCReply reply) {
        boolean coverageOK;
        s.nextKey = reply.hasNextStartKey() ? BoundaryUtil.clampToBoundary((ByteString)reply.getNextStartKey(), (Boundary)s.boundary) : null;
        if (reply.getWrapped()) {
            s.wrappedOnce = true;
        }
        if (!s.sprinted) {
            if (reply.getWrapped()) {
                s.sprinted = true;
                s.step = 1;
                s.interval = this.minCleanInterval;
                s.lowRatioHits = 0;
                s.wrappedOnce = false;
            }
            return;
        }
        int inspected = reply.getInspectedCount();
        int removeSuccess = reply.getRemoveSuccess();
        double successRatio = inspected == 0 ? 0.0 : (double)removeSuccess / (double)inspected;
        int scanQuota = 512 * Math.max(1, s.step);
        boolean bl = coverageOK = s.wrappedOnce || inspected >= (int)((double)scanQuota * 0.8);
        if (successRatio >= 0.005) {
            s.step = Math.max(s.step / 2, 1);
            long shrunk = (long)((double)s.interval.toMillis() / 2.0);
            s.interval = Duration.ofMillis(Math.max(shrunk, this.minCleanInterval.toMillis()));
            s.lowRatioHits = 0;
            s.wrappedOnce = false;
        } else if (coverageOK && removeSuccess == 0) {
            ++s.lowRatioHits;
            if (s.lowRatioHits >= 3 && s.wrappedOnce) {
                if (inspected >= (int)((double)scanQuota * 0.8)) {
                    s.step = Math.min(s.step + 1, 10);
                }
                long grown = (long)((double)s.interval.toMillis() * 1.5);
                s.interval = Duration.ofMillis(Math.min(grown, this.maxCleanInterval.toMillis()));
                s.lowRatioHits = 0;
                s.wrappedOnce = false;
            }
        } else if (!s.wrappedOnce) {
            s.interval = this.minCleanInterval;
        }
    }

    private static class RangeGcState {
        ByteString nextKey;
        int step;
        Duration interval;
        int lowRatioHits;
        boolean wrappedOnce;
        Instant nextDue;
        long ver;
        Boundary boundary;
        boolean sprinted;
        Gauge stepGauge;
        Gauge intervalGauge;

        private RangeGcState() {
        }
    }
}

