/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.inbox.server;

import com.google.common.collect.Iterators;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import lombok.Generated;
import org.apache.bifromq.inbox.server.IInboxFetcher;
import org.apache.bifromq.inbox.server.IInboxFetcherRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InboxFetcherRegistry
implements IInboxFetcherRegistry {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InboxFetcherRegistry.class);
    private final ConcurrentMap<String, Map<String, Map<String, IInboxFetcher>>> fetchers = new ConcurrentHashMap<String, Map<String, Map<String, IInboxFetcher>>>();

    @Override
    public void reg(IInboxFetcher fetcher) {
        this.fetchers.compute(fetcher.tenantId(), (key, val) -> {
            IInboxFetcher prevFetcher;
            if (val == null) {
                val = new ConcurrentHashMap<String, Map>();
            }
            if ((prevFetcher = val.computeIfAbsent(fetcher.delivererKey(), k -> new ConcurrentHashMap()).put(fetcher.id(), fetcher)) != null) {
                prevFetcher.close();
            }
            return val;
        });
    }

    @Override
    public void unreg(IInboxFetcher fetcher) {
        this.fetchers.compute(fetcher.tenantId(), (tenantId, m) -> {
            if (m != null) {
                m.computeIfPresent(fetcher.delivererKey(), (k, v) -> {
                    v.remove(fetcher.id(), fetcher);
                    if (v.isEmpty()) {
                        return null;
                    }
                    return v;
                });
                if (m.isEmpty()) {
                    return null;
                }
            }
            return m;
        });
    }

    @Override
    public Collection<IInboxFetcher> get(String tenantId, String delivererKey) {
        return this.fetchers.getOrDefault(tenantId, Collections.emptyMap()).getOrDefault(delivererKey, Collections.emptyMap()).values();
    }

    @Override
    public Iterator<IInboxFetcher> iterator() {
        return Iterators.concat((Iterator)Iterators.transform((Iterator)Iterators.concat(this.fetchers.values().stream().map(m -> m.values().iterator()).iterator()), e -> e.values().iterator()));
    }
}

