/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.baserpc.server;

import io.grpc.stub.StreamObserver;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.subjects.PublishSubject;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.bifromq.baserpc.metrics.RPCMetric;
import org.apache.bifromq.baserpc.server.AbstractStreamObserver;

public abstract class AckStream<AckT, MsgT>
extends AbstractStreamObserver<AckT, MsgT> {
    private final PublishSubject<AckT> ackSubject = PublishSubject.create();
    private final AtomicBoolean closed = new AtomicBoolean();

    protected AckStream(StreamObserver<MsgT> responseObserver) {
        super(responseObserver);
    }

    public Observable<AckT> ack() {
        return this.ackSubject;
    }

    public void send(MsgT message) {
        this.responseObserver.onNext(message);
        this.meter.recordCount(RPCMetric.StreamMsgSendCount);
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.ackSubject.onComplete();
            if (!this.responseObserver.isCancelled()) {
                this.responseObserver.onCompleted();
            }
        }
    }

    public final void onNext(AckT value) {
        this.meter.recordCount(RPCMetric.StreamAckReceiveCount);
        this.ackSubject.onNext(value);
    }

    public final void onError(Throwable t) {
        this.close();
    }

    public final void onCompleted() {
        this.close();
    }
}

