/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.retain.server;

import com.google.common.util.concurrent.MoreExecutors;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.jvm.ExecutorServiceMetrics;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.bifromq.baseenv.EnvProvider;
import org.apache.bifromq.deliverer.BatchDeliveryCallBuilderFactory;
import org.apache.bifromq.deliverer.IMessageDeliverer;
import org.apache.bifromq.deliverer.MessageDeliverer;
import org.apache.bifromq.retain.RPCBluePrint;
import org.apache.bifromq.retain.server.IRetainServer;
import org.apache.bifromq.retain.server.RetainServerBuilder;
import org.apache.bifromq.retain.server.RetainService;
import org.apache.bifromq.retain.server.scheduler.DeleteCallScheduler;
import org.apache.bifromq.retain.server.scheduler.MatchCallScheduler;
import org.apache.bifromq.retain.server.scheduler.RetainCallScheduler;
import org.apache.bifromq.retain.store.gc.IRetainStoreGCProcessor;
import org.apache.bifromq.retain.store.gc.RetainStoreGCProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RetainServer
implements IRetainServer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RetainServer.class);
    private final RetainService retainService;
    private final ExecutorService rpcExecutor;

    RetainServer(RetainServerBuilder builder) {
        this.retainService = new RetainService((IRetainStoreGCProcessor)new RetainStoreGCProcessor(builder.retainStoreClient, null), (IMessageDeliverer)new MessageDeliverer(new BatchDeliveryCallBuilderFactory(builder.distClient, builder.subBrokerManager)), new MatchCallScheduler(builder.retainStoreClient, builder.settingProvider), new RetainCallScheduler(builder.retainStoreClient), new DeleteCallScheduler(builder.retainStoreClient));
        this.rpcExecutor = builder.workerThreads == 0 ? MoreExecutors.newDirectExecutorService() : ExecutorServiceMetrics.monitor((MeterRegistry)Metrics.globalRegistry, (ExecutorService)new ThreadPoolExecutor(builder.workerThreads, builder.workerThreads, 0L, TimeUnit.MILLISECONDS, new LinkedTransferQueue<Runnable>(), EnvProvider.INSTANCE.newThreadFactory("retain-server-executor")), (String)"retain-server-executor", (Tag[])new Tag[0]);
        builder.rpcServerBuilder.bindService(this.retainService.bindService(), RPCBluePrint.INSTANCE, builder.attributes, builder.defaultGroupTags, (Executor)this.rpcExecutor);
    }

    @Override
    public void close() {
        log.info("Stopping RetainService");
        this.retainService.close();
        MoreExecutors.shutdownAndAwaitTermination((ExecutorService)this.rpcExecutor, (long)5L, (TimeUnit)TimeUnit.SECONDS);
        log.debug("RetainService stopped");
    }
}

