/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.store.range;

import com.google.protobuf.ByteString;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.binder.jvm.ExecutorServiceMetrics;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.bifromq.base.util.AsyncRunner;
import org.apache.bifromq.baseenv.EnvProvider;
import org.apache.bifromq.basekv.proto.KVPair;
import org.apache.bifromq.basekv.proto.KVRangeId;
import org.apache.bifromq.basekv.proto.KVRangeMessage;
import org.apache.bifromq.basekv.proto.KVRangeSnapshot;
import org.apache.bifromq.basekv.proto.SaveSnapshotDataReply;
import org.apache.bifromq.basekv.proto.SaveSnapshotDataRequest;
import org.apache.bifromq.basekv.store.api.IKVIterator;
import org.apache.bifromq.basekv.store.api.IKVRangeReader;
import org.apache.bifromq.basekv.store.range.IKVRange;
import org.apache.bifromq.basekv.store.range.IKVRangeMessenger;
import org.apache.bifromq.basekv.store.range.SnapshotBandwidthGovernor;
import org.apache.bifromq.logger.MDCLogger;
import org.slf4j.Logger;

class KVRangeDumpSession {
    private static final int MIN_CHUNK_BYTES = 131072;
    private static final int MAX_CHUNK_BYTES = 0x200000;
    private static final double TARGET_ROUND_TRIP_NANOS = Duration.ofMillis(70L).toNanos();
    private static final double EMA_ALPHA = 0.2;
    private static final long PROGRESS_LOG_INTERVAL_NANOS = Duration.ofSeconds(5L).toNanos();
    private final Logger log;
    private final String sessionId;
    private final KVRangeSnapshot snapshot;
    private final KVRangeId receiverRangeId;
    private final String receiverStoreId;
    private final IKVRangeMessenger messenger;
    private final ExecutorService executor;
    private final AsyncRunner runner;
    private final AtomicInteger reqId = new AtomicInteger();
    private final AtomicBoolean canceled = new AtomicBoolean();
    private final Duration maxIdleDuration;
    private final CompletableFuture<Result> doneSignal = new CompletableFuture();
    private final DumpBytesRecorder recorder;
    private final SnapshotBandwidthGovernor bandwidthGovernor;
    private final long startDumpTS = System.nanoTime();
    private IKVRangeReader snapshotReader;
    private IKVIterator snapshotDataItr;
    private long totalEntries = 0L;
    private long totalBytes = 0L;
    private long lastSendTS;
    private long lastProgressLogTS = this.startDumpTS;
    private double buildTimeEwma = TARGET_ROUND_TRIP_NANOS;
    private double roundTripEwma = TARGET_ROUND_TRIP_NANOS;
    private int chunkHint;
    private volatile KVRangeMessage currentRequest;
    private volatile long lastReplyTS;

    KVRangeDumpSession(String sessionId, KVRangeSnapshot snapshot, KVRangeId receiverRangeId, String receiverStoreId, IKVRange accessor, IKVRangeMessenger messenger, Duration maxIdleDuration, long bandwidth, SnapshotBandwidthGovernor bandwidthGovernor, DumpBytesRecorder recorder, String ... tags) {
        this.sessionId = sessionId;
        this.snapshot = snapshot;
        this.receiverRangeId = receiverRangeId;
        this.receiverStoreId = receiverStoreId;
        this.messenger = messenger;
        this.executor = ExecutorServiceMetrics.monitor((MeterRegistry)Metrics.globalRegistry, (ExecutorService)new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedTransferQueue<Runnable>(), EnvProvider.INSTANCE.newThreadFactory("basekv-snapshot-dumper")), (String)"mutator", (String)"basekv.range", (Iterable)Tags.of((String[])tags));
        this.runner = new AsyncRunner("basekv.runner.sessiondump", (Executor)this.executor, new String[0]);
        this.maxIdleDuration = maxIdleDuration;
        this.recorder = recorder;
        this.bandwidthGovernor = bandwidthGovernor;
        this.chunkHint = this.initialChunkHint(bandwidth);
        this.log = MDCLogger.getLogger(KVRangeDumpSession.class, (String[])tags);
        if (!snapshot.hasCheckpointId()) {
            messenger.send(KVRangeMessage.newBuilder().setRangeId(receiverRangeId).setHostStoreId(receiverStoreId).setSaveSnapshotDataRequest(SaveSnapshotDataRequest.newBuilder().setSessionId(sessionId).setFlag(SaveSnapshotDataRequest.Flag.End).build()).build());
            this.executor.execute(() -> this.doneSignal.complete(Result.OK));
        } else if (!accessor.hasCheckpoint(snapshot)) {
            this.log.warn("No checkpoint found for snapshot: {}", (Object)snapshot);
            messenger.send(KVRangeMessage.newBuilder().setRangeId(receiverRangeId).setHostStoreId(receiverStoreId).setSaveSnapshotDataRequest(SaveSnapshotDataRequest.newBuilder().setSessionId(sessionId).setFlag(SaveSnapshotDataRequest.Flag.NotFound).build()).build());
            this.executor.execute(() -> this.doneSignal.complete(Result.NoCheckpoint));
        } else {
            this.snapshotReader = accessor.open(snapshot);
            this.snapshotDataItr = this.snapshotReader.iterator();
            this.snapshotDataItr.seekToFirst();
            Disposable disposable = messenger.receive().mapOptional(m -> {
                SaveSnapshotDataReply reply;
                if (m.hasSaveSnapshotDataReply() && (reply = m.getSaveSnapshotDataReply()).getSessionId().equals(sessionId)) {
                    return Optional.of(reply);
                }
                return Optional.empty();
            }).observeOn(Schedulers.from((Executor)this.executor)).subscribe(this::handleReply);
            this.doneSignal.whenComplete((v, e) -> {
                this.snapshotDataItr.close();
                this.snapshotReader.close();
                disposable.dispose();
            });
            this.nextSaveRequest();
        }
    }

    String id() {
        return this.sessionId;
    }

    String checkpointId() {
        return this.snapshot.getCheckpointId();
    }

    void tick() {
        if (this.lastReplyTS == 0L || this.canceled.get()) {
            return;
        }
        long elapseNanos = Duration.ofNanos(System.nanoTime() - this.lastReplyTS).toNanos();
        if (this.maxIdleDuration.toNanos() < elapseNanos) {
            this.log.debug("DumpSession idle: session={}, follower={}", (Object)this.sessionId, (Object)this.receiverStoreId);
            this.cancel();
        } else if (this.maxIdleDuration.toNanos() / 2L < elapseNanos && this.currentRequest != null) {
            this.runner.add(() -> {
                if (this.maxIdleDuration.toNanos() / 2L < Duration.ofNanos(System.nanoTime() - this.lastReplyTS).toNanos()) {
                    this.messenger.send(this.currentRequest);
                }
            });
        }
    }

    void cancel() {
        if (this.canceled.compareAndSet(false, true)) {
            this.messenger.send(KVRangeMessage.newBuilder().setRangeId(this.receiverRangeId).setHostStoreId(this.receiverStoreId).setSaveSnapshotDataRequest(SaveSnapshotDataRequest.newBuilder().setSessionId(this.sessionId).setFlag(SaveSnapshotDataRequest.Flag.Error).build()).build());
            this.runner.add(() -> this.doneSignal.complete(Result.Canceled));
        }
    }

    CompletableFuture<Result> awaitDone() {
        return this.doneSignal.whenComplete((v, e) -> this.executor.shutdown());
    }

    private void handleReply(SaveSnapshotDataReply reply) {
        KVRangeMessage currReq = this.currentRequest;
        if (currReq == null) {
            return;
        }
        SaveSnapshotDataRequest req = currReq.getSaveSnapshotDataRequest();
        this.lastReplyTS = System.nanoTime();
        if (req.getReqId() == reply.getReqId()) {
            long ackLatency;
            long l = ackLatency = this.lastSendTS > 0L ? this.lastReplyTS - this.lastSendTS : 0L;
            if (ackLatency > 0L) {
                this.roundTripEwma = this.ema(this.roundTripEwma, ackLatency);
            }
            this.currentRequest = null;
            block0 : switch (reply.getResult()) {
                case OK: {
                    switch (req.getFlag()) {
                        case More: {
                            this.nextSaveRequest();
                            break block0;
                        }
                        case End: {
                            this.runner.add(() -> this.doneSignal.complete(Result.OK));
                            break block0;
                        }
                    }
                    break;
                }
                case NoSessionFound: 
                case Error: {
                    this.runner.add(() -> this.doneSignal.complete(Result.Abort));
                    break;
                }
            }
        }
    }

    private void nextSaveRequest() {
        this.runner.add(() -> {
            long now;
            SaveSnapshotDataRequest.Builder reqBuilder = SaveSnapshotDataRequest.newBuilder().setSessionId(this.sessionId).setReqId(this.reqId.getAndIncrement());
            long buildStart = System.nanoTime();
            int dumpEntries = 0;
            int dumpBytes = 0;
            int maxChunkBytes = this.chunkHint;
            if (!this.canceled.get()) {
                try {
                    boolean firstKv = true;
                    while (!this.canceled.get() && this.snapshotDataItr.isValid()) {
                        ByteString key = this.snapshotDataItr.key();
                        ByteString value = this.snapshotDataItr.value();
                        int kvBytes = key.size() + value.size();
                        if (firstKv || dumpBytes + kvBytes <= maxChunkBytes) {
                            reqBuilder.addKv(KVPair.newBuilder().setKey(key).setValue(value).build());
                            dumpBytes += kvBytes;
                            ++dumpEntries;
                            firstKv = false;
                            this.snapshotDataItr.next();
                            continue;
                        }
                        break;
                    }
                }
                catch (Throwable e) {
                    this.log.error("DumpSession error: session={}, follower={}", new Object[]{this.sessionId, this.receiverStoreId, e});
                    reqBuilder.clearKv();
                    reqBuilder.setFlag(SaveSnapshotDataRequest.Flag.Error);
                }
            }
            if (this.canceled.get() && reqBuilder.getFlag() != SaveSnapshotDataRequest.Flag.Error) {
                this.log.debug("DumpSession has been canceled: session={}, follower={}", (Object)this.sessionId, (Object)this.receiverStoreId);
                reqBuilder.clearKv();
                reqBuilder.setFlag(SaveSnapshotDataRequest.Flag.Error);
            }
            if (reqBuilder.getFlag() != SaveSnapshotDataRequest.Flag.Error) {
                if (dumpBytes == 0) {
                    if (!this.snapshotDataItr.isValid()) {
                        reqBuilder.setFlag(SaveSnapshotDataRequest.Flag.End);
                    } else {
                        reqBuilder.setFlag(SaveSnapshotDataRequest.Flag.More);
                    }
                } else {
                    reqBuilder.setFlag(this.snapshotDataItr.isValid() ? SaveSnapshotDataRequest.Flag.More : SaveSnapshotDataRequest.Flag.End);
                }
            }
            if (dumpBytes > 0 && reqBuilder.getFlag() != SaveSnapshotDataRequest.Flag.Error) {
                this.bandwidthGovernor.acquire(dumpBytes);
                long buildCost = System.nanoTime() - buildStart;
                this.adjustChunkHint(buildCost);
            }
            this.currentRequest = KVRangeMessage.newBuilder().setRangeId(this.receiverRangeId).setHostStoreId(this.receiverStoreId).setSaveSnapshotDataRequest(reqBuilder.build()).build();
            this.lastReplyTS = now = System.nanoTime();
            this.lastSendTS = now;
            this.recorder.record(dumpBytes);
            this.totalEntries += (long)dumpEntries;
            this.totalBytes += (long)dumpBytes;
            if (reqBuilder.getFlag() == SaveSnapshotDataRequest.Flag.End) {
                this.log.info("Dump snapshot completed: sessionId={}, follower={}, totalEntries={}, totalBytes={}, cost={}ms", new Object[]{this.sessionId, this.receiverStoreId, this.totalEntries, this.totalBytes, TimeUnit.NANOSECONDS.toMillis(now - this.startDumpTS)});
            } else if (now - this.lastProgressLogTS >= PROGRESS_LOG_INTERVAL_NANOS) {
                this.log.info("Dump snapshot progress: sessionId={}, follower={}, totalEntries={}, totalBytes={}, elapsed={}ms", new Object[]{this.sessionId, this.receiverStoreId, this.totalEntries, this.totalBytes, TimeUnit.NANOSECONDS.toMillis(now - this.startDumpTS)});
                this.lastProgressLogTS = now;
            }
            this.messenger.send(this.currentRequest);
            if (this.currentRequest.getSaveSnapshotDataRequest().getFlag() == SaveSnapshotDataRequest.Flag.Error) {
                this.doneSignal.complete(Result.Error);
            }
        });
    }

    private int initialChunkHint(long bandwidth) {
        if (bandwidth <= 0L) {
            return 262144;
        }
        long suggested = bandwidth / 20L;
        if (suggested <= 0L) {
            suggested = 131072L;
        }
        return (int)Math.max(131072L, Math.min(0x200000L, suggested));
    }

    private void adjustChunkHint(long buildCostNanos) {
        this.buildTimeEwma = this.ema(this.buildTimeEwma, buildCostNanos);
        double dominant = Math.max(this.buildTimeEwma, this.roundTripEwma);
        int current = this.chunkHint;
        if (dominant < TARGET_ROUND_TRIP_NANOS / 2.0 && current < 0x200000) {
            int increased = current + Math.max(32768, (int)((double)current * 0.2));
            this.chunkHint = Math.min(0x200000, increased);
        } else if (dominant > TARGET_ROUND_TRIP_NANOS * 2.0 && current > 131072) {
            this.chunkHint = Math.max(131072, current / 2);
        }
    }

    private double ema(double current, long sample) {
        return current + 0.2 * ((double)sample - current);
    }

    static interface DumpBytesRecorder {
        public void record(int var1);
    }

    static enum Result {
        OK,
        NoCheckpoint,
        Canceled,
        Abort,
        Error;

    }
}

