/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.store.wal;

import com.google.common.collect.Maps;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Parser;
import com.google.protobuf.UnsafeByteOperations;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Deque;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.Consumer;
import org.apache.bifromq.baseenv.ZeroCopyParser;
import org.apache.bifromq.basekv.localengine.IKVSpaceIterator;
import org.apache.bifromq.basekv.localengine.IKVSpaceRefreshableReader;
import org.apache.bifromq.basekv.localengine.IKVSpaceWriter;
import org.apache.bifromq.basekv.localengine.IWALableKVSpace;
import org.apache.bifromq.basekv.proto.Boundary;
import org.apache.bifromq.basekv.proto.KVRangeId;
import org.apache.bifromq.basekv.raft.ILogEntryIterator;
import org.apache.bifromq.basekv.raft.IRaftStateStore;
import org.apache.bifromq.basekv.raft.proto.ClusterConfig;
import org.apache.bifromq.basekv.raft.proto.LogEntry;
import org.apache.bifromq.basekv.raft.proto.Snapshot;
import org.apache.bifromq.basekv.raft.proto.Voting;
import org.apache.bifromq.basekv.store.exception.KVRangeStoreException;
import org.apache.bifromq.basekv.store.util.KVUtil;
import org.apache.bifromq.basekv.store.wal.IKVRangeWALStore;
import org.apache.bifromq.basekv.store.wal.KVRangeWALKeys;
import org.apache.bifromq.basekv.store.wal.LogEntryIterator;
import org.apache.bifromq.basekv.utils.BoundaryUtil;
import org.apache.bifromq.basekv.utils.KVRangeIdUtil;
import org.apache.bifromq.logger.MDCLogger;
import org.slf4j.Logger;

class KVRangeWALStore
implements IKVRangeWALStore {
    private static final IRaftStateStore.StableListener DEFAULT_STABLE_LISTENER = stabledIndex -> {};
    private final Logger log;
    private final String storeId;
    private final KVRangeId rangeId;
    private final IWALableKVSpace kvSpace;
    private final TreeMap<Long, ClusterConfig> configEntryMap = Maps.newTreeMap();
    private final Deque<StabilizingIndex> stabilizingIndices = new ConcurrentLinkedDeque<StabilizingIndex>();
    private final Consumer<KVRangeWALStore> onDestroy;
    private long currentTerm = 0L;
    private Voting currentVoting;
    private Snapshot latestSnapshot;
    private long lastIndex;
    private int logEntriesKeyInfix;
    private volatile IRaftStateStore.StableListener stableListener = DEFAULT_STABLE_LISTENER;

    KVRangeWALStore(String clusterId, String storeId, KVRangeId rangeId, IWALableKVSpace kvSpace, Consumer<KVRangeWALStore> onDestroy) {
        this.rangeId = rangeId;
        this.kvSpace = kvSpace;
        this.storeId = storeId;
        this.onDestroy = onDestroy;
        this.log = MDCLogger.getLogger(KVRangeWALStore.class, (String[])new String[]{"clusterId", clusterId, "storeId", storeId, "rangeId", KVRangeIdUtil.toString((KVRangeId)rangeId)});
        this.load();
    }

    public String local() {
        return this.storeId;
    }

    public Optional<Voting> currentVoting() {
        return Optional.ofNullable(this.currentVoting);
    }

    public void saveVoting(Voting voting) {
        this.trace("Save voting: {}", voting);
        ((IKVSpaceWriter)this.kvSpace.toWriter().put(KVRangeWALKeys.KEY_CURRENT_VOTING_BYTES, voting.toByteString())).done();
        this.flush();
        this.currentVoting = voting;
    }

    public long currentTerm() {
        return this.currentTerm;
    }

    public void saveTerm(long term) {
        this.trace("Save term: {}", term);
        ((IKVSpaceWriter)this.kvSpace.toWriter().put(KVRangeWALKeys.KEY_CURRENT_TERM_BYTES, UnsafeByteOperations.unsafeWrap((byte[])ByteBuffer.allocate(8).putLong(term).array()))).done();
        this.flush();
        this.currentTerm = term;
    }

    public ClusterConfig latestClusterConfig() {
        if (this.configEntryMap.isEmpty()) {
            return this.latestSnapshot.getClusterConfig();
        }
        return this.configEntryMap.lastEntry().getValue();
    }

    public void applySnapshot(Snapshot snapshot) {
        block16: {
            long snapLastIndex = snapshot.getIndex();
            long snapLastTerm = snapshot.getTerm();
            Optional<LogEntry> lastEntryInSS = this.entryAt(snapLastIndex);
            this.log.debug("Compact logs using snapshot[term={}, index={}]", (Object)snapLastTerm, (Object)snapLastIndex);
            IKVSpaceWriter writer = this.kvSpace.toWriter();
            if (lastEntryInSS.isPresent() && lastEntryInSS.get().getTerm() == snapLastTerm || lastEntryInSS.isEmpty() && this.latestSnapshot != null && this.latestSnapshot.getIndex() == snapLastIndex && this.latestSnapshot.getTerm() == snapLastTerm) {
                writer.put(KVRangeWALKeys.KEY_LATEST_SNAPSHOT_BYTES, snapshot.toByteString());
                this.latestSnapshot = snapshot;
                this.lastIndex = Math.max(this.lastIndex, snapLastIndex);
                long truncateBeforeIndex = Math.min(this.lastIndex(), snapLastIndex) + 1L;
                while (!this.configEntryMap.isEmpty() && this.configEntryMap.firstKey() <= truncateBeforeIndex) {
                    this.configEntryMap.pollFirstEntry();
                }
                this.log.trace("Truncating logs before index[{}]", (Object)truncateBeforeIndex);
                try (IKVSpaceRefreshableReader reader = this.kvSpace.reader();){
                    IKVSpaceIterator it = reader.newIterator();
                    writer.clear(Boundary.newBuilder().setStartKey(KVRangeWALKeys.logEntriesKeyPrefixInfix(0)).setEndKey(KVRangeWALKeys.logEntryKey(this.logEntriesKeyInfix, truncateBeforeIndex)).build());
                    it.seek(KVRangeWALKeys.configEntriesKeyPrefixInfix(0));
                    while (it.isValid() && it.key().startsWith(KVRangeWALKeys.KEY_CONFIG_ENTRY_INDEXES_BYTES) && it.value().asReadOnlyByteBuffer().getLong() < truncateBeforeIndex) {
                        writer.delete(it.key());
                        it.next();
                    }
                    writer.done();
                    break block16;
                }
                catch (Throwable e) {
                    this.log.error("Unexpected error during truncating log", e);
                    throw e;
                }
                finally {
                    this.log.debug("Logs truncated before index[{}]", (Object)truncateBeforeIndex);
                }
            }
            writer.put(KVRangeWALKeys.KEY_LATEST_SNAPSHOT_BYTES, snapshot.toByteString());
            this.latestSnapshot = snapshot;
            this.lastIndex = this.latestSnapshot.getIndex();
            int lastLogEntriesKeyInfix = this.logEntriesKeyInfix;
            writer.put(KVRangeWALKeys.KEY_LOG_ENTRIES_INCAR, KVUtil.toByteString(this.logEntriesKeyInfix + 1));
            ++this.logEntriesKeyInfix;
            this.configEntryMap.clear();
            try {
                this.log.trace("Truncating all logs");
                writer.clear(BoundaryUtil.toBoundary((ByteString)KVRangeWALKeys.logEntriesKeyPrefixInfix(0), (ByteString)BoundaryUtil.upperBound((ByteString)KVRangeWALKeys.logEntriesKeyPrefixInfix(lastLogEntriesKeyInfix))));
                writer.clear(BoundaryUtil.toBoundary((ByteString)KVRangeWALKeys.configEntriesKeyPrefixInfix(0), (ByteString)BoundaryUtil.upperBound((ByteString)KVRangeWALKeys.configEntriesKeyPrefixInfix(lastLogEntriesKeyInfix))));
                writer.done();
                this.flush();
                this.log.debug("All logs of truncated");
            }
            catch (Throwable e) {
                this.log.error("Log truncation failed", e);
                throw e;
            }
        }
    }

    public Snapshot latestSnapshot() {
        return this.latestSnapshot;
    }

    public long firstIndex() {
        return this.latestSnapshot.getIndex() + 1L;
    }

    public long lastIndex() {
        return this.lastIndex;
    }

    public Optional<LogEntry> entryAt(long index) {
        Optional<LogEntry> optional;
        block9: {
            if (index < this.firstIndex() || index > this.lastIndex()) {
                return Optional.empty();
            }
            IKVSpaceRefreshableReader reader = this.kvSpace.reader();
            try {
                ByteString data = (ByteString)reader.get(KVRangeWALKeys.logEntryKey(this.logEntriesKeyInfix, index)).get();
                optional = Optional.of((LogEntry)ZeroCopyParser.parse((ByteString)data, (Parser)LogEntry.parser()));
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    this.log.error("Failed to parse log entry[index={}]", (Object)index, (Object)e);
                    return Optional.empty();
                }
            }
            reader.close();
        }
        return optional;
    }

    public ILogEntryIterator entries(long lo, long hi, long maxSize) {
        if (lo < this.firstIndex()) {
            throw new IndexOutOfBoundsException("lo[" + lo + "] must not be less than firstIndex[" + this.firstIndex() + "]");
        }
        if (hi > this.lastIndex() + 1L) {
            throw new IndexOutOfBoundsException("hi[" + hi + "] must not be greater than lastIndex[" + this.lastIndex() + "]");
        }
        if (maxSize < 0L) {
            maxSize = Long.MAX_VALUE;
        }
        return new LogEntryIterator(this.kvSpace, lo, hi, maxSize, this.logEntriesKeyInfix);
    }

    public void append(List<LogEntry> entries, boolean flush) {
        assert (!entries.isEmpty());
        LogEntry startEntry = entries.get(0);
        if (this.lastIndex() >= this.firstIndex()) {
            if (this.firstIndex() > startEntry.getIndex() || this.lastIndex() + 1L < startEntry.getIndex()) {
                throw new IndexOutOfBoundsException(String.format("first index[%d] must be in [%d,%d]", startEntry.getIndex(), this.firstIndex(), this.lastIndex() + 1L));
            }
        } else if (startEntry.getIndex() != this.firstIndex()) {
            throw new IndexOutOfBoundsException(String.format("log index must start from %d", this.firstIndex()));
        }
        long afterIndex = entries.get(0).getIndex() - 1L;
        IKVSpaceWriter writer = this.kvSpace.toWriter();
        while (!this.configEntryMap.isEmpty() && this.configEntryMap.lastKey() > afterIndex) {
            long removedIndex = this.configEntryMap.pollLastEntry().getKey();
            writer.delete(KVRangeWALKeys.configEntriesKey(this.logEntriesKeyInfix, removedIndex));
        }
        for (LogEntry entry : entries) {
            if (entry.hasConfig()) {
                this.configEntryMap.put(entry.getIndex(), entry.getConfig());
                writer.insert(KVRangeWALKeys.configEntriesKey(this.logEntriesKeyInfix, entry.getIndex()), KVUtil.toByteString(entry.getIndex()));
                flush = true;
            }
            this.trace("Append log entry[index={}, term={}, type={}], flush? {}", entry.getIndex(), entry.getTerm(), entry.getTypeCase().name(), flush);
            writer.insert(KVRangeWALKeys.logEntryKey(this.logEntriesKeyInfix, entry.getIndex()), entry.toByteString());
        }
        writer.done();
        this.lastIndex = entries.get(entries.size() - 1).getIndex();
        this.stabilizingIndices.add(new StabilizingIndex(this.lastIndex));
        if (flush) {
            this.flush();
        } else {
            this.asyncFlush();
        }
    }

    public void addStableListener(IRaftStateStore.StableListener listener) {
        this.stableListener = listener;
    }

    public void stop() {
        this.log.debug("Stop WALStore");
        this.stableListener = DEFAULT_STABLE_LISTENER;
    }

    @Override
    public void destroy() {
        this.log.debug("Destroy WALStore");
        this.kvSpace.destroy();
        this.onDestroy.accept(this);
    }

    @Override
    public long size() {
        return this.kvSpace.size();
    }

    private void onStable(long flushTime) {
        StabilizingIndex stabilizingIndex;
        while ((stabilizingIndex = this.stabilizingIndices.poll()) != null) {
            if (stabilizingIndex.ts < flushTime) {
                this.stableListener.onStabilized(stabilizingIndex.index);
                continue;
            }
            this.stabilizingIndices.addLast(stabilizingIndex);
            break;
        }
        if (!this.stabilizingIndices.isEmpty()) {
            this.asyncFlush();
        }
    }

    private void flush() {
        try {
            long flushTime = (Long)this.kvSpace.flush().join();
            this.onStable(flushTime);
        }
        catch (Throwable e) {
            this.log.warn("Flush error, try again", e);
        }
    }

    private void asyncFlush() {
        this.kvSpace.flush().whenComplete((ts, e) -> {
            if (e != null) {
                this.log.warn("Flush error, try again", e);
                this.asyncFlush();
            } else {
                this.onStable((long)ts);
            }
        });
    }

    private void load() {
        try (IKVSpaceRefreshableReader reader = this.kvSpace.reader();){
            this.loadLogEntryInfix(reader);
            this.loadVoting(reader);
            this.loadCurrentTerm(reader);
            this.loadLatestSnapshot(reader);
            this.loadConfigEntryIndexes(reader);
            this.loadLastIndex(reader);
        }
        this.trace("New raft state storage loaded", new Object[0]);
    }

    private void loadVoting(IKVSpaceRefreshableReader reader) {
        try {
            Optional votingBytes = reader.get(KVRangeWALKeys.KEY_CURRENT_VOTING_BYTES);
            if (votingBytes.isPresent()) {
                this.currentVoting = (Voting)ZeroCopyParser.parse((ByteString)((ByteString)votingBytes.get()), (Parser)Voting.parser());
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw new KVRangeStoreException("Failed to parse currentVoting", e);
        }
    }

    private void loadCurrentTerm(IKVSpaceRefreshableReader reader) {
        this.currentTerm = reader.get(KVRangeWALKeys.KEY_CURRENT_TERM_BYTES).map(KVUtil::toLong).orElse(0L);
    }

    private void loadLatestSnapshot(IKVSpaceRefreshableReader reader) {
        try {
            ByteString latestSnapshotBytes = (ByteString)reader.get(KVRangeWALKeys.KEY_LATEST_SNAPSHOT_BYTES).get();
            this.latestSnapshot = (Snapshot)ZeroCopyParser.parse((ByteString)latestSnapshotBytes, (Parser)Snapshot.parser());
        }
        catch (InvalidProtocolBufferException e) {
            throw new KVRangeStoreException("Failed to parse snapshot", e);
        }
    }

    private void loadConfigEntryIndexes(IKVSpaceRefreshableReader reader) {
        IKVSpaceIterator it = reader.newIterator();
        ByteString prefix = KVRangeWALKeys.KEY_CONFIG_ENTRY_INDEXES_BYTES;
        it.seek(prefix);
        while (it.isValid() && it.key().startsWith(prefix)) {
            long configEntryIndex = it.value().asReadOnlyByteBuffer().getLong();
            this.configEntryMap.put(configEntryIndex, this.loadConfigEntry(configEntryIndex));
            it.next();
        }
    }

    private ClusterConfig loadConfigEntry(long configEntryIndex) {
        ClusterConfig clusterConfig;
        block10: {
            IKVSpaceRefreshableReader reader = this.kvSpace.reader();
            try {
                ByteString data = (ByteString)reader.get(KVRangeWALKeys.logEntryKey(this.logEntriesKeyInfix, configEntryIndex)).get();
                LogEntry logEntry = (LogEntry)ZeroCopyParser.parse((ByteString)data, (Parser)LogEntry.parser());
                assert (logEntry.hasConfig());
                clusterConfig = logEntry.getConfig();
                if (reader == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new KVRangeStoreException("Failed to parse", e);
                }
                catch (NoSuchElementException e) {
                    this.log.error("Cluster config not found at index[{}]", (Object)configEntryIndex);
                    throw new KVRangeStoreException("config not found", e);
                }
            }
            reader.close();
        }
        return clusterConfig;
    }

    private void loadLastIndex(IKVSpaceRefreshableReader reader) {
        IKVSpaceIterator it = reader.newIterator();
        it.seekToLast();
        this.lastIndex = it.isValid() && it.key().startsWith(KVRangeWALKeys.KEY_PREFIX_LOG_ENTRIES_BYTES) ? KVRangeWALKeys.parseLogIndex(it.key()) : this.latestSnapshot.getIndex();
    }

    private void loadLogEntryInfix(IKVSpaceRefreshableReader reader) {
        this.logEntriesKeyInfix = reader.get(KVRangeWALKeys.KEY_LOG_ENTRIES_INCAR).map(KVUtil::toInt).orElse(0);
    }

    private void trace(String msg, Object ... args) {
        if (this.log.isTraceEnabled()) {
            this.log.trace(msg, args);
        }
    }

    private static class StabilizingIndex {
        final long ts = System.nanoTime();
        final long index;

        private StabilizingIndex(long index) {
            this.index = index;
        }
    }
}

