/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.baserpc.client;

import com.google.common.util.concurrent.MoreExecutors;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.ConnectivityState;
import io.grpc.LoadBalancerProvider;
import io.grpc.LoadBalancerRegistry;
import io.grpc.ManagedChannel;
import io.grpc.internal.ManagedChannelImplBuilder;
import io.grpc.netty.InProcAware;
import io.grpc.netty.NegotiationType;
import io.grpc.netty.NettyChannelBuilder;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.jvm.ExecutorServiceMetrics;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.ssl.SslContext;
import io.reactivex.rxjava3.core.Observable;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.bifromq.baseenv.EnvProvider;
import org.apache.bifromq.baseenv.NettyEnv;
import org.apache.bifromq.baserpc.BluePrint;
import org.apache.bifromq.baserpc.client.ConnStateListener;
import org.apache.bifromq.baserpc.client.IClientChannel;
import org.apache.bifromq.baserpc.client.IConnectable;
import org.apache.bifromq.baserpc.client.interceptor.TenantAwareClientInterceptor;
import org.apache.bifromq.baserpc.client.loadbalancer.IServerSelector;
import org.apache.bifromq.baserpc.client.loadbalancer.TrafficDirectiveLoadBalancerProvider;
import org.apache.bifromq.baserpc.client.nameresolver.TrafficGovernorNameResolverProvider;
import org.apache.bifromq.baserpc.client.util.FastBehaviorSubject;
import org.apache.bifromq.baserpc.trafficgovernor.IRPCServiceLandscape;
import org.apache.bifromq.baserpc.trafficgovernor.IRPCServiceTrafficService;

class ClientChannel
implements IClientChannel {
    private final String serviceUniqueName;
    private final ExecutorService executorService;
    private final ManagedChannel internalChannel;
    private final FastBehaviorSubject<IServerSelector> serverSelectorSubject = FastBehaviorSubject.create();
    private final FastBehaviorSubject<IConnectable.ConnState> connStateSubject = FastBehaviorSubject.create();
    private final Observable<Map<String, Map<String, String>>> serverListSubject;
    private final LoadBalancerProvider loadBalancerProvider;

    ClientChannel(int workerThreads, long keepAliveInSec, long idleTimeoutInSec, BluePrint bluePrint, IRPCServiceTrafficService trafficService, EventLoopGroup eventLoopGroup, SslContext sslContext) {
        this.serviceUniqueName = bluePrint.serviceDescriptor().getName();
        IRPCServiceLandscape serviceLandscape = trafficService.getServiceLandscape(this.serviceUniqueName);
        this.loadBalancerProvider = new TrafficDirectiveLoadBalancerProvider(bluePrint, this.serverSelectorSubject::onNext);
        this.serverListSubject = serviceLandscape.serverEndpoints().map(sl -> sl.stream().collect(Collectors.toMap(s -> s.id(), s -> s.attrs())));
        LoadBalancerRegistry.getDefaultRegistry().register(this.loadBalancerProvider);
        TrafficGovernorNameResolverProvider.register(this.serviceUniqueName, serviceLandscape);
        this.executorService = workerThreads == 0 ? MoreExecutors.newDirectExecutorService() : ExecutorServiceMetrics.monitor((MeterRegistry)Metrics.globalRegistry, (ExecutorService)new ThreadPoolExecutor(workerThreads, workerThreads, 0L, TimeUnit.MILLISECONDS, new LinkedTransferQueue<Runnable>(), EnvProvider.INSTANCE.newThreadFactory(this.serviceUniqueName + "-client-executor")), (String)(this.serviceUniqueName + "-rpc-client-executor"), (Tag[])new Tag[0]);
        String target = "tgov://" + this.serviceUniqueName;
        NettyChannelBuilder internalChannelBuilder = NettyChannelBuilder.forTarget((String)("tgov://" + this.serviceUniqueName)).keepAliveTime(keepAliveInSec <= 0L ? 600L : keepAliveInSec, TimeUnit.SECONDS).keepAliveWithoutCalls(true).maxInboundMessageSize(Integer.MAX_VALUE);
        if (sslContext != null) {
            internalChannelBuilder.negotiationType(NegotiationType.TLS).sslContext(sslContext);
        } else {
            internalChannelBuilder.negotiationType(NegotiationType.PLAINTEXT);
        }
        if (eventLoopGroup != null) {
            internalChannelBuilder.eventLoopGroup(eventLoopGroup).channelType(NettyEnv.determineSocketChannelClass((EventLoopGroup)eventLoopGroup));
        }
        this.internalChannel = ((ManagedChannelImplBuilder)InProcAware.wrap((String)target, (NettyChannelBuilder)internalChannelBuilder).idleTimeout(idleTimeoutInSec <= 0L ? 31536000L : idleTimeoutInSec, TimeUnit.SECONDS)).defaultLoadBalancingPolicy(this.loadBalancerProvider.getPolicyName()).intercept(new ClientInterceptor[]{new TenantAwareClientInterceptor()}).executor((Executor)this.executorService).build();
        ConnStateListener connStateListener = (server, connState) -> this.connStateSubject.onNext(IConnectable.ConnState.values()[connState.ordinal()]);
        this.startStateListener(connStateListener);
    }

    @Override
    public Channel channel() {
        return this.internalChannel;
    }

    @Override
    public Observable<IConnectable.ConnState> connState() {
        return this.connStateSubject;
    }

    @Override
    public Observable<Map<String, Map<String, String>>> serverList() {
        return this.serverListSubject;
    }

    @Override
    public Observable<IServerSelector> serverSelectorObservable() {
        return this.serverSelectorSubject.distinctUntilChanged();
    }

    @Override
    public boolean shutdown(long timeout, TimeUnit unit) {
        boolean result;
        if (this.internalChannel.isShutdown()) {
            return true;
        }
        LoadBalancerRegistry.getDefaultRegistry().deregister(this.loadBalancerProvider);
        long start = System.nanoTime();
        try {
            this.internalChannel.shutdownNow();
            result = this.internalChannel.awaitTermination(timeout / 2L, unit);
        }
        catch (InterruptedException e) {
            result = this.internalChannel.isTerminated();
        }
        long left = timeout - unit.convert(System.nanoTime() - start, TimeUnit.NANOSECONDS);
        MoreExecutors.shutdownAndAwaitTermination((ExecutorService)this.executorService, (long)Math.max(1L, left), (TimeUnit)unit);
        this.serverSelectorSubject.onComplete();
        this.connStateSubject.onComplete();
        return result;
    }

    private void startStateListener(ConnStateListener connStateListener) {
        ConnectivityState currentState = this.internalChannel.getState(true);
        connStateListener.onChange(this.serviceUniqueName, currentState);
        if (currentState != ConnectivityState.SHUTDOWN) {
            this.internalChannel.notifyWhenStateChanged(currentState, () -> this.startStateListener(connStateListener));
        }
    }

    @Generated
    public static ClientChannelBuilder builder() {
        return new ClientChannelBuilder();
    }

    @Generated
    public static class ClientChannelBuilder {
        @Generated
        private int workerThreads;
        @Generated
        private long keepAliveInSec;
        @Generated
        private long idleTimeoutInSec;
        @Generated
        private BluePrint bluePrint;
        @Generated
        private IRPCServiceTrafficService trafficService;
        @Generated
        private EventLoopGroup eventLoopGroup;
        @Generated
        private SslContext sslContext;

        @Generated
        ClientChannelBuilder() {
        }

        @Generated
        public ClientChannelBuilder workerThreads(int workerThreads) {
            this.workerThreads = workerThreads;
            return this;
        }

        @Generated
        public ClientChannelBuilder keepAliveInSec(long keepAliveInSec) {
            this.keepAliveInSec = keepAliveInSec;
            return this;
        }

        @Generated
        public ClientChannelBuilder idleTimeoutInSec(long idleTimeoutInSec) {
            this.idleTimeoutInSec = idleTimeoutInSec;
            return this;
        }

        @Generated
        public ClientChannelBuilder bluePrint(BluePrint bluePrint) {
            this.bluePrint = bluePrint;
            return this;
        }

        @Generated
        public ClientChannelBuilder trafficService(IRPCServiceTrafficService trafficService) {
            this.trafficService = trafficService;
            return this;
        }

        @Generated
        public ClientChannelBuilder eventLoopGroup(EventLoopGroup eventLoopGroup) {
            this.eventLoopGroup = eventLoopGroup;
            return this;
        }

        @Generated
        public ClientChannelBuilder sslContext(SslContext sslContext) {
            this.sslContext = sslContext;
            return this;
        }

        @Generated
        public ClientChannel build() {
            return new ClientChannel(this.workerThreads, this.keepAliveInSec, this.idleTimeoutInSec, this.bluePrint, this.trafficService, this.eventLoopGroup, this.sslContext);
        }

        @Generated
        public String toString() {
            return "ClientChannel.ClientChannelBuilder(workerThreads=" + this.workerThreads + ", keepAliveInSec=" + this.keepAliveInSec + ", idleTimeoutInSec=" + this.idleTimeoutInSec + ", bluePrint=" + String.valueOf(this.bluePrint) + ", trafficService=" + String.valueOf(this.trafficService) + ", eventLoopGroup=" + String.valueOf(this.eventLoopGroup) + ", sslContext=" + String.valueOf(this.sslContext) + ")";
        }
    }
}

