/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.baserpc.client.exception;

import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import org.apache.bifromq.baserpc.client.exception.RequestCanceledException;
import org.apache.bifromq.baserpc.client.exception.ServerNotFoundException;

public class ExceptionUtil {
    public static final Status SERVER_NOT_FOUND = Status.UNAVAILABLE.withDescription("direct targeted server not found");
    public static final Status SERVER_UNREACHABLE = Status.UNAVAILABLE.withDescription("server is unreachable now");

    public static Throwable toConcreteException(Throwable throwable) {
        if (throwable instanceof StatusRuntimeException) {
            StatusRuntimeException statusRuntimeException = (StatusRuntimeException)throwable;
            if (statusRuntimeException.getStatus().equals((Object)SERVER_NOT_FOUND)) {
                return new ServerNotFoundException(throwable);
            }
            if (statusRuntimeException.getStatus().equals((Object)SERVER_UNREACHABLE)) {
                return new ServerNotFoundException(throwable);
            }
            if (statusRuntimeException.getStatus().equals((Object)Status.CANCELLED)) {
                return new RequestCanceledException(throwable);
            }
        }
        return throwable;
    }
}

