/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.apiserver.http.handler;

import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import java.util.concurrent.CompletableFuture;
import org.apache.bifromq.apiserver.Headers;
import org.apache.bifromq.apiserver.http.handler.TenantAwareHandler;
import org.apache.bifromq.apiserver.http.handler.utils.HeaderUtils;
import org.apache.bifromq.plugin.settingprovider.ISettingProvider;
import org.apache.bifromq.sessiondict.client.ISessionDictClient;
import org.apache.bifromq.sessiondict.rpc.proto.GetInboxStateReply;
import org.apache.bifromq.sessiondict.rpc.proto.GetInboxStateRequest;
import org.apache.bifromq.type.InboxState;

@Path(value="/session/inbox")
final class GetSessionInboxStateHandler
extends TenantAwareHandler {
    private final ISessionDictClient sessionDictClient;

    GetSessionInboxStateHandler(ISettingProvider settingProvider, ISessionDictClient sessionDictClient) {
        super(settingProvider);
        this.sessionDictClient = sessionDictClient;
    }

    @Override
    @GET
    @Operation(summary="Get the inbox state of a mqtt session")
    @Parameters(value={@Parameter(name="req_id", in=ParameterIn.HEADER, description="optional caller provided request id", schema=@Schema(implementation=Long.class)), @Parameter(name="tenant_id", in=ParameterIn.HEADER, required=true, description="the id of tenant", schema=@Schema(implementation=String.class)), @Parameter(name="user_id", in=ParameterIn.HEADER, required=true, description="the id of user who established the session", schema=@Schema(implementation=String.class)), @Parameter(name="client_id", in=ParameterIn.HEADER, required=true, description="the client id of the mqtt session", schema=@Schema(implementation=String.class))})
    @RequestBody(required=false)
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Success", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="404", description="No session found for the given user and client id", content={@Content(schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="409", description="Try later", content={@Content(schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=String.class))})})
    public CompletableFuture<FullHttpResponse> handle(@Parameter(hidden=true) long reqId, @Parameter(hidden=true) String tenantId, @Parameter(hidden=true) FullHttpRequest req) {
        String userId = HeaderUtils.getHeader(Headers.HEADER_USER_ID, (HttpRequest)req, true);
        String clientId = HeaderUtils.getHeader(Headers.HEADER_CLIENT_ID, (HttpRequest)req, true);
        return this.sessionDictClient.inboxState(GetInboxStateRequest.newBuilder().setReqId(reqId).setTenantId(tenantId).setUserId(userId).setClientId(clientId).build()).thenApply(reply -> switch (reply.getCode()) {
            case GetInboxStateReply.Code.OK -> {
                DefaultFullHttpResponse resp = new DefaultFullHttpResponse(req.protocolVersion(), HttpResponseStatus.OK, Unpooled.wrappedBuffer((byte[])this.toJSON(reply.getState()).getBytes()));
                resp.headers().set("Content-Type", (Object)"application/json");
                yield resp;
            }
            case GetInboxStateReply.Code.NO_INBOX -> new DefaultFullHttpResponse(req.protocolVersion(), HttpResponseStatus.NOT_FOUND, Unpooled.copiedBuffer((byte[])reply.getCode().name().getBytes()));
            case GetInboxStateReply.Code.TRY_LATER -> new DefaultFullHttpResponse(req.protocolVersion(), HttpResponseStatus.CONFLICT, Unpooled.copiedBuffer((byte[])reply.getCode().name().getBytes()));
            case GetInboxStateReply.Code.BACK_PRESSURE_REJECTED -> new DefaultFullHttpResponse(req.protocolVersion(), HttpResponseStatus.TOO_MANY_REQUESTS, Unpooled.copiedBuffer((byte[])reply.getCode().name().getBytes()));
            default -> new DefaultFullHttpResponse(req.protocolVersion(), HttpResponseStatus.INTERNAL_SERVER_ERROR, Unpooled.EMPTY_BUFFER);
        });
    }

    private String toJSON(InboxState inboxState) {
        return JsonFormat.printer().print((MessageOrBuilder)inboxState);
    }
}

