/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.base.util;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import java.lang.ref.Cleaner;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import lombok.Generated;

public final class AsyncRunner {
    private static final Cleaner CLEANER = Cleaner.create();
    private final ConcurrentLinkedDeque<Task<?>> taskQueue;
    private final Executor executor;
    private final AtomicReference<State> state = new AtomicReference<State>(State.EMPTY_STOP);
    private final Timer queueingTimer;
    private final Timer execTimer;
    private volatile CompletableFuture<Void> whenDone = CompletableFuture.completedFuture(null);

    public AsyncRunner(Executor executor) {
        this("async.runner", executor, new String[0]);
    }

    public AsyncRunner(String name, Executor executor, String ... tags) {
        this.taskQueue = new ConcurrentLinkedDeque();
        this.executor = executor;
        this.queueingTimer = Timer.builder((String)name).tags(new String[]{"type", "queueing"}).tags(tags).register((MeterRegistry)Metrics.globalRegistry);
        this.execTimer = Timer.builder((String)name).tags(new String[]{"type", "exec"}).tags(tags).register((MeterRegistry)Metrics.globalRegistry);
        CLEANER.register(this, new ClosableState((Meter)this.queueingTimer));
        CLEANER.register(this, new ClosableState((Meter)this.execTimer));
    }

    public CompletableFuture<Void> add(Runnable runnable) {
        return this.add(runnable, false);
    }

    public <T> CompletableFuture<T> add(Supplier<CompletableFuture<T>> taskSupplier) {
        return this.add(taskSupplier, false);
    }

    private CompletableFuture<Void> add(Runnable runnable, boolean first) {
        return this.add(() -> {
            CompletableFuture onDone = new CompletableFuture();
            if (onDone.isCancelled()) {
                return CompletableFuture.completedFuture(null);
            }
            try {
                runnable.run();
            }
            catch (Throwable e) {
                onDone.completeExceptionally(e);
            }
            finally {
                onDone.complete(null);
            }
            return onDone;
        }, first);
    }

    private <T> CompletableFuture<T> add(Supplier<CompletableFuture<T>> taskSupplier, boolean first) {
        CompletableFuture f = new CompletableFuture();
        if (first) {
            this.taskQueue.addFirst(new Task<T>(taskSupplier, f));
        } else {
            this.taskQueue.addLast(new Task<T>(taskSupplier, f));
        }
        do {
            if (!this.state.compareAndSet(State.EMPTY_STOP, State.NONEMPTY_STOP)) continue;
            this.whenDone = new CompletableFuture();
            this.executor.execute(this::runTask);
            break;
        } while (this.state.get() != State.NONEMPTY_STOP && this.state.get() != State.NONEMPTY_RUNNING && !this.state.compareAndSet(State.EMPTY_RUNNING, State.NONEMPTY_RUNNING));
        return f;
    }

    public CompletableFuture<Void> addFirst(Runnable runnable) {
        return this.add(runnable, true);
    }

    public <T> CompletableFuture<T> addFirst(Supplier<CompletableFuture<T>> taskSupplier) {
        return this.add(taskSupplier, true);
    }

    public void cancelAll() {
        this.taskQueue.descendingIterator().forEachRemaining(t -> t.future.cancel(true));
    }

    private <T> void runTask() {
        block4: {
            do {
                if (!this.state.compareAndSet(State.NONEMPTY_STOP, State.NONEMPTY_RUNNING) && this.state.get() != State.NONEMPTY_RUNNING) continue;
                Task<?> task = this.taskQueue.peek();
                if (task != null) {
                    Supplier taskSupplier = task.supplier;
                    this.executor.execute(() -> {
                        if (task.future.isDone()) {
                            this.taskQueue.removeFirstOccurrence(task);
                            this.runTask();
                            return;
                        }
                        try {
                            long now = System.nanoTime();
                            this.queueingTimer.record(now - task.submitAtNanos, TimeUnit.NANOSECONDS);
                            CompletableFuture taskFuture = (CompletableFuture)taskSupplier.get();
                            task.future.whenCompleteAsync((v, e) -> {
                                if (task.future.isCancelled()) {
                                    taskFuture.cancel(true);
                                }
                            }, this.executor);
                            taskFuture.whenCompleteAsync((v, e) -> {
                                if (!task.future.isDone()) {
                                    if (e != null) {
                                        task.future.completeExceptionally((Throwable)e);
                                    } else {
                                        this.execTimer.record(System.nanoTime() - now, TimeUnit.NANOSECONDS);
                                        task.future.complete(v);
                                    }
                                }
                                this.taskQueue.removeFirstOccurrence(task);
                                this.runTask();
                            }, this.executor);
                        }
                        catch (Throwable e2) {
                            task.future.completeExceptionally(e2);
                            this.taskQueue.removeFirstOccurrence(task);
                            this.runTask();
                        }
                    });
                } else {
                    if (!this.state.compareAndSet(State.NONEMPTY_RUNNING, State.EMPTY_RUNNING)) continue;
                    if (!this.taskQueue.isEmpty()) {
                        this.state.set(State.NONEMPTY_RUNNING);
                    }
                    this.executor.execute(this::runTask);
                }
                break block4;
            } while (!this.state.compareAndSet(State.EMPTY_RUNNING, State.EMPTY_STOP));
            this.whenDone.complete(null);
            this.whenDone = CompletableFuture.completedFuture(null);
        }
    }

    public CompletionStage<Void> awaitDone() {
        CompletableFuture<Void> onDone = new CompletableFuture<Void>();
        this.whenDone.whenComplete((v, e) -> onDone.complete(null));
        return onDone;
    }

    private static enum State {
        EMPTY_STOP,
        NONEMPTY_STOP,
        NONEMPTY_RUNNING,
        EMPTY_RUNNING;

    }

    private record ClosableState(Meter meter) implements Runnable
    {
        @Override
        public void run() {
            Metrics.globalRegistry.remove(this.meter);
        }
    }

    private static class Task<T> {
        final long submitAtNanos = System.nanoTime();
        final Supplier<CompletableFuture<T>> supplier;
        final CompletableFuture<T> future;

        @Generated
        public Task(Supplier<CompletableFuture<T>> supplier, CompletableFuture<T> future) {
            this.supplier = supplier;
            this.future = future;
        }
    }
}

