/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.plugin.clientbalancer;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.bifromq.plugin.clientbalancer.DummyClientBalancer;
import org.apache.bifromq.plugin.clientbalancer.IClientBalancer;
import org.apache.bifromq.plugin.clientbalancer.Redirection;
import org.apache.bifromq.type.ClientInfo;
import org.pf4j.PluginManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientBalancerManager
implements IClientBalancer,
AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClientBalancerManager.class);
    private static final Logger pluginLog = LoggerFactory.getLogger((String)"plugin.manager");
    private final AtomicBoolean stopped = new AtomicBoolean();
    private final IClientBalancer delegate;
    private final Timer callTimer;
    private final Counter callErrorCounter;

    public ClientBalancerManager(PluginManager pluginMgr) {
        Map<String, IClientBalancer> loadedClientBalancers = pluginMgr.getExtensions(IClientBalancer.class).stream().collect(Collectors.toMap(e -> e.getClass().getName(), e -> e));
        if (loadedClientBalancers.isEmpty()) {
            pluginLog.warn("No client balancer plugin available");
            this.delegate = new DummyClientBalancer();
        } else {
            if (loadedClientBalancers.size() > 1) {
                pluginLog.warn("Multiple client balancer plugins available, use the first found");
            }
            String clientBalancerFQN = loadedClientBalancers.keySet().iterator().next();
            pluginLog.info("Client balancer loaded: {}", (Object)clientBalancerFQN);
            this.delegate = loadedClientBalancers.get(clientBalancerFQN);
        }
        this.callTimer = Timer.builder((String)"call.exec.timer").tag("method", "ClientBalancer/needRedirect").tag("type", this.delegate.getClass().getName()).register((MeterRegistry)Metrics.globalRegistry);
        this.callErrorCounter = Counter.builder((String)"call.exec.fail.count").tag("method", "ClientBalancer/needRedirect").tag("type", this.delegate.getClass().getName()).register((MeterRegistry)Metrics.globalRegistry);
    }

    public Optional<Redirection> needRedirect(ClientInfo clientInfo) {
        assert (!this.stopped.get());
        Timer.Sample sample = Timer.start();
        try {
            Optional redirection = this.delegate.needRedirect(clientInfo);
            sample.stop(this.callTimer);
            return redirection;
        }
        catch (Throwable e) {
            pluginLog.error("Client balancer plugin error", e);
            this.callErrorCounter.increment();
            return Optional.empty();
        }
    }

    @Override
    public void close() {
        if (this.stopped.compareAndSet(false, true)) {
            log.debug("Closing client balancer manager");
            try {
                this.delegate.close();
            }
            catch (Throwable e) {
                pluginLog.error("Failed to close client balancer plugin", e);
            }
            Metrics.globalRegistry.remove((Meter)this.callTimer);
            Metrics.globalRegistry.remove((Meter)this.callErrorCounter);
            log.debug("Client balancer manager closed");
        }
    }
}

