/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluss.fs.hdfs;

import java.io.IOException;
import java.net.URI;
import java.net.UnknownHostException;
import org.apache.fluss.fs.FileSystem;
import org.apache.fluss.fs.FileSystemPlugin;
import org.apache.fluss.fs.UnsupportedFileSystemSchemeException;
import org.apache.fluss.fs.hdfs.HdfsFileSystem;
import org.apache.fluss.fs.hdfs.utils.HadoopUtils;
import org.apache.fluss.utils.Preconditions;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdfsPlugin
implements FileSystemPlugin {
    public static final String SCHEME = "hdfs";
    private static final Logger LOG = LoggerFactory.getLogger(HdfsPlugin.class);

    public String getScheme() {
        return SCHEME;
    }

    public FileSystem create(URI fsUri, org.apache.fluss.config.Configuration flussConfig) throws IOException {
        Preconditions.checkNotNull((Object)fsUri, (String)"fsUri");
        String scheme = fsUri.getScheme();
        Preconditions.checkArgument((scheme != null ? 1 : 0) != 0, (String)"file system has null scheme", (Object[])new Object[0]);
        try {
            URI initUri;
            Class<? extends org.apache.hadoop.fs.FileSystem> fsClass;
            Configuration hadoopConfig = HadoopUtils.getHadoopConfiguration(flussConfig);
            try {
                fsClass = org.apache.hadoop.fs.FileSystem.getFileSystemClass(scheme, hadoopConfig);
            }
            catch (IOException e) {
                throw new UnsupportedFileSystemSchemeException("Hadoop File System abstraction does not support scheme '" + scheme + "'. Either no file system implementation exists for that scheme, or the relevant classes are missing from the classpath.", (Throwable)e);
            }
            LOG.debug("Instantiating for file system scheme {} Hadoop File System {}", (Object)scheme, (Object)fsClass.getName());
            org.apache.hadoop.fs.FileSystem hadoopFs = fsClass.newInstance();
            if (fsUri.getAuthority() != null) {
                initUri = fsUri;
            } else {
                String configEntry;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("URI {} does not specify file system authority, trying to load default authority (fs.defaultFS)", (Object)fsUri);
                }
                if ((configEntry = hadoopConfig.get("fs.defaultFS", null)) == null) {
                    configEntry = hadoopConfig.get("fs.default.name", null);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Hadoop's 'fs.defaultFS' is set to {}", (Object)configEntry);
                }
                if (configEntry == null) {
                    throw new IOException(HdfsPlugin.getMissingAuthorityErrorPrefix(fsUri) + "Hadoop configuration did not contain an entry for the default file system ('fs.defaultFS').");
                }
                try {
                    initUri = URI.create(configEntry);
                }
                catch (IllegalArgumentException e) {
                    throw new IOException(HdfsPlugin.getMissingAuthorityErrorPrefix(fsUri) + "The configuration contains an invalid file system default name ('fs.default.name' or 'fs.defaultFS'): " + configEntry);
                }
                if (initUri.getAuthority() == null) {
                    throw new IOException(HdfsPlugin.getMissingAuthorityErrorPrefix(fsUri) + "Hadoop configuration for default file system ('fs.default.name' or 'fs.defaultFS') contains no valid authority component (like hdfs namenode, S3 host, etc)");
                }
            }
            try {
                hadoopFs.initialize(initUri, hadoopConfig);
            }
            catch (UnknownHostException e) {
                String message = "The Hadoop file system's authority (" + initUri.getAuthority() + "), specified by either the file URI or the configuration, cannot be resolved.";
                throw new IOException(message, e);
            }
            return new HdfsFileSystem(hadoopFs);
        }
        catch (LinkageError | ReflectiveOperationException e) {
            throw new UnsupportedFileSystemSchemeException("Cannot support file system for '" + fsUri.getScheme() + "' via Hadoop, because Hadoop is not in the classpath, or some classes are missing from the classpath.", e);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException("Cannot instantiate file system for URI: " + String.valueOf(fsUri), e);
        }
    }

    private static String getMissingAuthorityErrorPrefix(URI fsURI) {
        return "The given file system URI (" + fsURI.toString() + ") did not describe the authority (like for example HDFS NameNode address/port or S3 host). The attempt to use a configured default authority failed: ";
    }
}

