/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluss.lake.paimon.source;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.fluss.config.Configuration;
import org.apache.fluss.lake.paimon.source.PaimonSplit;
import org.apache.fluss.lake.paimon.utils.PaimonConversions;
import org.apache.fluss.lake.source.Planner;
import org.apache.fluss.metadata.TablePath;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.CatalogContext;
import org.apache.paimon.catalog.CatalogFactory;
import org.apache.paimon.options.Options;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.table.BucketMode;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.source.DataSplit;
import org.apache.paimon.table.source.InnerTableScan;
import org.apache.paimon.table.source.Split;

public class PaimonSplitPlanner
implements Planner<PaimonSplit> {
    private final Configuration paimonConfig;
    private final TablePath tablePath;
    @Nullable
    private final Predicate predicate;
    private final long snapshotId;

    public PaimonSplitPlanner(Configuration paimonConfig, TablePath tablePath, @Nullable Predicate predicate, long snapshotId) {
        this.paimonConfig = paimonConfig;
        this.tablePath = tablePath;
        this.predicate = predicate;
        this.snapshotId = snapshotId;
    }

    public List<PaimonSplit> plan() {
        try {
            ArrayList<PaimonSplit> splits = new ArrayList<PaimonSplit>();
            try (Catalog catalog = this.getCatalog();){
                boolean isBucketUnAware;
                FileStoreTable fileStoreTable = this.getTable(catalog, this.tablePath, this.snapshotId);
                InnerTableScan tableScan = fileStoreTable.newScan();
                boolean bl = isBucketUnAware = fileStoreTable.bucketMode() == BucketMode.BUCKET_UNAWARE;
                if (this.predicate != null) {
                    tableScan = tableScan.withFilter(this.predicate);
                }
                for (Split split : tableScan.plan().splits()) {
                    DataSplit dataSplit = (DataSplit)split;
                    splits.add(new PaimonSplit(dataSplit, isBucketUnAware));
                }
            }
            return splits;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to plan splits for paimon.", e);
        }
    }

    private Catalog getCatalog() {
        return CatalogFactory.createCatalog(CatalogContext.create(Options.fromMap(this.paimonConfig.toMap())));
    }

    private FileStoreTable getTable(Catalog catalog, TablePath tablePath, long snapshotId) throws Exception {
        return (FileStoreTable)catalog.getTable(PaimonConversions.toPaimon(tablePath)).copy(Collections.singletonMap(CoreOptions.SCAN_SNAPSHOT_ID.key(), String.valueOf(snapshotId)));
    }
}

