/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.compact;

import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.compact.CompactManager;
import org.apache.paimon.compact.CompactResult;

public abstract class CompactFutureManager
implements CompactManager {
    protected Future<CompactResult> taskFuture;

    @Override
    public void cancelCompaction() {
        if (this.taskFuture != null && !this.taskFuture.isCancelled()) {
            this.taskFuture.cancel(true);
        }
    }

    @Override
    public boolean compactNotCompleted() {
        return this.taskFuture != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Optional<CompactResult> innerGetCompactionResult(boolean blocking) throws ExecutionException, InterruptedException {
        if (this.taskFuture != null && (blocking || this.taskFuture.isDone())) {
            CompactResult result;
            try {
                result = this.obtainCompactResult();
            }
            catch (CancellationException e) {
                Optional<CompactResult> optional = Optional.empty();
                return optional;
            }
            finally {
                this.taskFuture = null;
            }
            return Optional.of(result);
        }
        return Optional.empty();
    }

    @VisibleForTesting
    protected CompactResult obtainCompactResult() throws InterruptedException, ExecutionException {
        return this.taskFuture.get();
    }
}

