/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.data.serializer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.paimon.data.serializer.Serializer;
import org.apache.paimon.io.DataInputView;
import org.apache.paimon.io.DataOutputView;
import org.apache.paimon.utils.Preconditions;

public final class ListSerializer<T>
implements Serializer<List<T>> {
    private static final long serialVersionUID = 1L;
    private final Serializer<T> elementSerializer;

    public ListSerializer(Serializer<T> elementSerializer) {
        this.elementSerializer = Preconditions.checkNotNull(elementSerializer);
    }

    public Serializer<T> getElementSerializer() {
        return this.elementSerializer;
    }

    @Override
    public Serializer<List<T>> duplicate() {
        Serializer<T> duplicateElement = this.elementSerializer.duplicate();
        return duplicateElement == this.elementSerializer ? this : new ListSerializer<T>(duplicateElement);
    }

    @Override
    public List<T> copy(List<T> from) {
        ArrayList<T> newList = new ArrayList<T>(from.size());
        for (T element : from) {
            newList.add(this.elementSerializer.copy(element));
        }
        return newList;
    }

    @Override
    public void serialize(List<T> list, DataOutputView target) throws IOException {
        int size = list.size();
        target.writeInt(size);
        for (T element : list) {
            this.elementSerializer.serialize(element, target);
        }
    }

    @Override
    public List<T> deserialize(DataInputView source2) throws IOException {
        int size = source2.readInt();
        ArrayList<T> list = new ArrayList<T>(size + 1);
        for (int i = 0; i < size; ++i) {
            list.add(this.elementSerializer.deserialize(source2));
        }
        return list;
    }

    public boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass() == this.getClass() && this.elementSerializer.equals(((ListSerializer)obj).elementSerializer);
    }

    public int hashCode() {
        return this.elementSerializer.hashCode();
    }
}

