/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.schema;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.apache.paimon.schema.SchemaChange;
import org.apache.paimon.types.ArrayType;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeRoot;
import org.apache.paimon.types.MapType;
import org.apache.paimon.types.MultisetType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.Preconditions;

public class NestedSchemaUtils {
    public static void generateNestedColumnUpdates(List<String> fieldNames, DataType oldType, DataType newType, List<SchemaChange> schemaChanges) {
        if (oldType.getTypeRoot() == DataTypeRoot.ROW) {
            NestedSchemaUtils.handleRowTypeUpdate(fieldNames, oldType, newType, schemaChanges);
        } else if (oldType.getTypeRoot() == DataTypeRoot.ARRAY) {
            NestedSchemaUtils.handleArrayTypeUpdate(fieldNames, oldType, newType, schemaChanges);
        } else if (oldType.getTypeRoot() == DataTypeRoot.MAP) {
            NestedSchemaUtils.handleMapTypeUpdate(fieldNames, oldType, newType, schemaChanges);
        } else if (oldType.getTypeRoot() == DataTypeRoot.MULTISET) {
            NestedSchemaUtils.handleMultisetTypeUpdate(fieldNames, oldType, newType, schemaChanges);
        } else {
            NestedSchemaUtils.handlePrimitiveTypeUpdate(fieldNames, oldType, newType, schemaChanges);
        }
        NestedSchemaUtils.handleNullabilityChange(fieldNames, oldType, newType, schemaChanges);
    }

    /*
     * WARNING - void declaration
     */
    private static void handleRowTypeUpdate(List<String> fieldNames, DataType oldType, DataType newType, List<SchemaChange> schemaChanges) {
        void var11_14;
        String joinedNames = String.join((CharSequence)".", fieldNames);
        Preconditions.checkArgument(newType.getTypeRoot() == DataTypeRoot.ROW, "Column %s can only be updated to row type, and cannot be updated to %s type", new Object[]{joinedNames, newType.getTypeRoot()});
        RowType oldRowType = (RowType)oldType;
        RowType newRowType = (RowType)newType;
        HashMap<String, Integer> oldFieldOrders = new HashMap<String, Integer>();
        for (int i = 0; i < oldRowType.getFieldCount(); ++i) {
            oldFieldOrders.put(oldRowType.getFields().get(i).name(), i);
        }
        int lastIdx = -1;
        String lastFieldName = "";
        for (DataField dataField : newRowType.getFields()) {
            String name = dataField.name();
            if (!oldFieldOrders.containsKey(name)) continue;
            int idx = (Integer)oldFieldOrders.get(name);
            Preconditions.checkState(lastIdx < idx, "Order of existing fields in column %s must be kept the same. However, field %s and %s have changed their orders.", joinedNames, lastFieldName, name);
            lastIdx = idx;
            lastFieldName = name;
        }
        HashSet<String> newFieldNames = new HashSet<String>(newRowType.getFieldNames());
        for (String name : oldRowType.getFieldNames()) {
            if (newFieldNames.contains(name)) continue;
            ArrayList<String> dropColumnNames = new ArrayList<String>(fieldNames);
            dropColumnNames.add(name);
            schemaChanges.add(SchemaChange.dropColumn(dropColumnNames.toArray(new String[0])));
        }
        boolean bl = false;
        while (var11_14 < newRowType.getFieldCount()) {
            DataField field = newRowType.getFields().get((int)var11_14);
            String name = field.name();
            ArrayList<String> fullFieldNames = new ArrayList<String>(fieldNames);
            fullFieldNames.add(name);
            if (!oldFieldOrders.containsKey(name)) {
                SchemaChange.Move move;
                if (var11_14 == false) {
                    move = SchemaChange.Move.first(name);
                } else {
                    String lastName = newRowType.getFields().get((int)(var11_14 - true)).name();
                    move = SchemaChange.Move.after(name, lastName);
                }
                schemaChanges.add(SchemaChange.addColumn(fullFieldNames.toArray(new String[0]), field.type(), field.description(), move));
            } else {
                DataField oldField = oldRowType.getFields().get((Integer)oldFieldOrders.get(name));
                if (!Objects.equals(oldField.description(), field.description())) {
                    schemaChanges.add(SchemaChange.updateColumnComment(fullFieldNames.toArray(new String[0]), field.description()));
                }
                NestedSchemaUtils.generateNestedColumnUpdates(fullFieldNames, oldField.type(), field.type(), schemaChanges);
            }
            ++var11_14;
        }
    }

    private static void handleArrayTypeUpdate(List<String> fieldNames, DataType oldType, DataType newType, List<SchemaChange> schemaChanges) {
        String joinedNames = String.join((CharSequence)".", fieldNames);
        Preconditions.checkArgument(newType.getTypeRoot() == DataTypeRoot.ARRAY, "Column %s can only be updated to array type, and cannot be updated to %s type", joinedNames, newType);
        ArrayList<String> fullFieldNames = new ArrayList<String>(fieldNames);
        fullFieldNames.add("element");
        NestedSchemaUtils.generateNestedColumnUpdates(fullFieldNames, ((ArrayType)oldType).getElementType(), ((ArrayType)newType).getElementType(), schemaChanges);
    }

    private static void handleMapTypeUpdate(List<String> fieldNames, DataType oldType, DataType newType, List<SchemaChange> schemaChanges) {
        String joinedNames = String.join((CharSequence)".", fieldNames);
        Preconditions.checkArgument(newType.getTypeRoot() == DataTypeRoot.MAP, "Column %s can only be updated to map type, and cannot be updated to %s type", joinedNames, newType);
        MapType oldMapType = (MapType)oldType;
        MapType newMapType = (MapType)newType;
        Preconditions.checkArgument(oldMapType.getKeyType().equals(newMapType.getKeyType()), "Cannot update key type of column %s from %s type to %s type", joinedNames, oldMapType.getKeyType(), newMapType.getKeyType());
        ArrayList<String> fullFieldNames = new ArrayList<String>(fieldNames);
        fullFieldNames.add("value");
        NestedSchemaUtils.generateNestedColumnUpdates(fullFieldNames, oldMapType.getValueType(), newMapType.getValueType(), schemaChanges);
    }

    private static void handleMultisetTypeUpdate(List<String> fieldNames, DataType oldType, DataType newType, List<SchemaChange> schemaChanges) {
        String joinedNames = String.join((CharSequence)".", fieldNames);
        Preconditions.checkArgument(newType.getTypeRoot() == DataTypeRoot.MULTISET, "Column %s can only be updated to multiset type, and cannot be updated to %s type", joinedNames, newType);
        ArrayList<String> fullFieldNames = new ArrayList<String>(fieldNames);
        fullFieldNames.add("element");
        NestedSchemaUtils.generateNestedColumnUpdates(fullFieldNames, ((MultisetType)oldType).getElementType(), ((MultisetType)newType).getElementType(), schemaChanges);
    }

    private static void handlePrimitiveTypeUpdate(List<String> fieldNames, DataType oldType, DataType newType, List<SchemaChange> schemaChanges) {
        if (!oldType.equalsIgnoreNullable(newType)) {
            schemaChanges.add(SchemaChange.updateColumnType(fieldNames.toArray(new String[0]), newType, false));
        }
    }

    private static void handleNullabilityChange(List<String> fieldNames, DataType oldType, DataType newType, List<SchemaChange> schemaChanges) {
        if (oldType.isNullable() != newType.isNullable()) {
            schemaChanges.add(SchemaChange.updateColumnNullability(fieldNames.toArray(new String[0]), newType.isNullable()));
        }
    }
}

